/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.measurement;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.measurement.MeasurementManager;
import org.rhq.core.pc.measurement.ScheduledMeasurementInfo;
import org.rhq.core.pc.util.ComponentUtil;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.util.exception.ThrowableUtil;

public class MeasurementCollectorRunner
implements Callable<MeasurementReport>,
Runnable {
    private static final Log log = LogFactory.getLog(MeasurementCollectorRunner.class);
    private final MeasurementManager measurementManager;
    private final ScheduleHistory scheduleHistory = new ScheduleHistory();

    public MeasurementCollectorRunner(MeasurementManager measurementManager) {
        this.measurementManager = measurementManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MeasurementReport call() {
        MeasurementReport report = null;
        try {
            this.measurementManager.getLock().readLock().lock();
            report = this.measurementManager.getActiveReport();
            long start = System.currentTimeMillis();
            InventoryManager im = this.measurementManager.getInventoryManager();
            Set<ScheduledMeasurementInfo> requests = this.measurementManager.getNextScheduledSet();
            if (requests != null) {
                ScheduledMeasurementInfo next = requests.iterator().next();
                if (System.currentTimeMillis() - 30000L > next.getNextCollection()) {
                    this.measurementManager.incrementLateCollections(requests.size());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Measurement collection is falling behind... Missed requested time by [" + (System.currentTimeMillis() - requests.iterator().next().getNextCollection()) + "ms]"));
                        if (!this.scheduleHistory.isEmpty()) {
                            log.debug((Object)("The most recent measurement requests prior to this detected delay: " + this.scheduleHistory));
                        }
                    }
                    this.measurementManager.rescheduleLateCollections(requests);
                    MeasurementReport measurementReport = report;
                    return measurementReport;
                }
                Integer resourceId = next.getResourceId();
                ResourceContainer container = im.getResourceContainer(resourceId);
                if (container.getResourceComponentState() != ResourceContainer.ResourceComponentState.STARTED || container.getAvailability() == null || container.getAvailability().getAvailabilityType() == AvailabilityType.DOWN) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Measurements not collected for inactive resource component: " + container.getResource()));
                    }
                } else {
                    MeasurementFacet measurementComponent = ComponentUtil.getComponent(resourceId, MeasurementFacet.class, FacetLockType.READ, 30000L, true, true, true);
                    if (log.isDebugEnabled()) {
                        this.scheduleHistory.addRequests(requests);
                    }
                    this.getValues(measurementComponent, report, requests, container.getResource());
                }
                this.measurementManager.reschedule(requests);
                report.incrementCollectionTime(System.currentTimeMillis() - start);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to run measurement collection", t);
        }
        finally {
            this.measurementManager.getLock().readLock().unlock();
        }
        return report;
    }

    private void getValues(MeasurementFacet measurementComponent, MeasurementReport report, Set<? extends MeasurementScheduleRequest> requests, Resource resource) {
        try {
            long start = System.currentTimeMillis();
            measurementComponent.getValues(report, Collections.unmodifiableSet(requests));
            long duration = System.currentTimeMillis() - start;
            if (duration > 2000L || log.isTraceEnabled()) {
                String message = "[PERF] Collection of measurements for [" + resource + "] (component=[" + measurementComponent + "]) took [" + duration + "]ms";
                if (log.isDebugEnabled()) {
                    message = message + " for requests: " + requests;
                }
                log.info((Object)message);
            }
        }
        catch (Throwable t) {
            this.measurementManager.incrementFailedCollections(requests.size());
            if (log.isDebugEnabled()) {
                log.warn((Object)("Failure to collect measurement data for " + resource + ", requests=" + requests + ", report.size()=" + report.getDataCount()), t);
            }
            log.warn((Object)("Failure to collect measurement data for " + resource + " - cause: " + ThrowableUtil.getAllMessages((Throwable)t)));
        }
    }

    @Override
    public void run() {
        try {
            this.call();
        }
        catch (Exception e) {
            log.error((Object)"Could not get measurement report.", (Throwable)e);
        }
    }

    private static class ScheduleHistory
    extends ArrayDeque<String> {
        private static final long serialVersionUID = 1L;
        private static final int HISTORY_SIZE;

        private ScheduleHistory() {
        }

        private void makeSpace() {
            if (this.size() == HISTORY_SIZE) {
                this.removeLast();
            }
        }

        public void addRequests(Set<ScheduledMeasurementInfo> requests) {
            String now = new Date().toString() + " ";
            for (ScheduledMeasurementInfo request : requests) {
                this.push(now + request.toString());
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            while (!this.isEmpty()) {
                sb.append("\n  ");
                sb.append((String)this.pop());
            }
            return sb.toString();
        }

        @Override
        public void push(String e) {
            this.makeSpace();
            super.push(e);
        }

        @Override
        public boolean add(String e) {
            this.makeSpace();
            return super.add(e);
        }

        @Override
        public void addFirst(String e) {
            this.makeSpace();
            super.addFirst(e);
        }

        @Override
        public void addLast(String e) {
            this.makeSpace();
            super.addLast(e);
        }

        static {
            int historySize;
            try {
                historySize = Integer.parseInt(System.getProperty("rhq.agent.plugins.measurement-schedule.history.size", "500"));
            }
            catch (Throwable t) {
                historySize = 500;
            }
            HISTORY_SIZE = historySize;
        }
    }
}

