/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.plugin;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.clientapi.agent.metadata.ResourceTypeNotEnabledException;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.plugin.ClassLoaderManager;
import org.rhq.core.pc.plugin.PluginManager;
import org.rhq.core.pluginapi.inventory.ClassLoaderFacet;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryCallback;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;

public class PluginComponentFactory
implements ContainerService {
    private static final Log log = LogFactory.getLog(PluginComponentFactory.class);
    private final InventoryManager inventoryManager;
    private final PluginManager pluginManager;

    public PluginComponentFactory(InventoryManager inventoryManager, PluginManager pluginManager) {
        this.inventoryManager = inventoryManager;
        this.pluginManager = pluginManager;
    }

    public ResourceDiscoveryComponent getDiscoveryComponent(ResourceType resourceType, ResourceContainer parentResourceContainer) throws PluginContainerException, ResourceTypeNotEnabledException {
        if (resourceType.equals((Object)PluginMetadataManager.TEST_PLATFORM_TYPE)) {
            return null;
        }
        PluginMetadataManager metadataManager = this.pluginManager.getMetadataManager();
        String className = metadataManager.getDiscoveryClass(resourceType);
        String typeName = resourceType.getName();
        String pluginName = resourceType.getPlugin();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating discovery component [" + className + "] for resource type [" + typeName + ']'));
        }
        ClassLoader classLoader = this.getDiscoveryComponentClassLoader(parentResourceContainer, pluginName);
        ResourceDiscoveryComponent discoveryComponent = (ResourceDiscoveryComponent)this.instantiateClass(classLoader, className);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created discovery component [" + className + "] for resource type [" + typeName + ']'));
        }
        return discoveryComponent;
    }

    public ClassLoader getDiscoveryComponentClassLoader(ResourceContainer parentResourceContainer, String pluginName) throws PluginContainerException {
        ClassLoader classLoader;
        ClassLoaderManager classLoaderMgr = this.pluginManager.getClassLoaderManager();
        if (parentResourceContainer == null || this.inventoryManager.getPlatform().equals((Object)parentResourceContainer.getResource())) {
            classLoader = classLoaderMgr.obtainPluginClassLoader(pluginName);
        } else {
            ClassLoader parentClassLoader = parentResourceContainer.getResourceClassLoader();
            classLoader = pluginName.equals(parentResourceContainer.getResource().getResourceType().getPlugin()) ? parentClassLoader : classLoaderMgr.obtainDiscoveryClassLoader(pluginName, parentClassLoader);
        }
        return classLoader;
    }

    public ResourceComponent buildResourceComponent(Resource resource) throws PluginContainerException, ResourceTypeNotEnabledException {
        ResourceType resourceType = resource.getResourceType();
        if (PluginMetadataManager.TEST_PLATFORM_TYPE.equals((Object)resourceType)) {
            return new ResourceComponent(){

                public AvailabilityType getAvailability() {
                    return AvailabilityType.UP;
                }

                public void start(ResourceContext context) {
                }

                public void stop() {
                }
            };
        }
        String className = this.pluginManager.getMetadataManager().getComponentClass(resourceType);
        ResourceContainer resourceContainer = this.inventoryManager.getResourceContainer(resource);
        if (resourceContainer == null) {
            throw new PluginContainerException("Resource container not found for " + resource + " - cannot create ResourceComponent.");
        }
        ClassLoader resourceClassloader = resourceContainer.getResourceClassLoader();
        if (resourceClassloader == null) {
            throw new PluginContainerException("Resource classLoader not found for " + resource + " - cannot create ResourceComponent.");
        }
        ResourceComponent component = (ResourceComponent)this.instantiateClass(resourceClassloader, className);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created resource component [" + className + "] of resource type [" + resourceType + ']'));
        }
        return component;
    }

    public ClassLoader getResourceClassloader(Resource resource) throws PluginContainerException {
        try {
            ResourceContainer parentContainer;
            ClassLoaderManager classLoaderMgr = this.pluginManager.getClassLoaderManager();
            ResourceType resourceType = resource.getResourceType();
            if (resourceType.equals((Object)PluginMetadataManager.TEST_PLATFORM_TYPE)) {
                return Thread.currentThread().getContextClassLoader();
            }
            Resource parentResource = resource.getParentResource();
            if (parentResource != null) {
                parentContainer = this.inventoryManager.getResourceContainer(parentResource);
                if (parentContainer == null) {
                    throw new PluginContainerException("Missing container for parent " + parentResource + " of " + resource + ".");
                }
            } else {
                if (resource.equals((Object)this.inventoryManager.getPlatform())) {
                    return classLoaderMgr.obtainPluginClassLoader(resourceType.getPlugin());
                }
                throw new PluginContainerException("Missing parent resource for resource=" + resource);
            }
            List<URL> additionalJars = classLoaderMgr.isCreateResourceClassLoaders() ? this.askDiscoveryComponentForAdditionalClasspathUrls(resource, parentContainer) : Collections.emptyList();
            ClassLoader cl = classLoaderMgr.obtainResourceClassLoader(resource, parentContainer, additionalJars);
            return cl;
        }
        catch (Throwable t) {
            throw new PluginContainerException("Failed to obtain classloader for resource: " + resource, t);
        }
    }

    public ResourceDiscoveryCallback getDiscoveryCallback(String pluginName, String callbackClassName) throws PluginContainerException {
        ClassLoader classLoader = this.getDiscoveryComponentClassLoader(null, pluginName);
        ResourceDiscoveryCallback callback = (ResourceDiscoveryCallback)this.instantiateClass(classLoader, callbackClassName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created discovery callback [" + callbackClassName + "] for plugin [" + pluginName + ']'));
        }
        return callback;
    }

    private List<URL> askDiscoveryComponentForAdditionalClasspathUrls(Resource resource, ResourceContainer parentContainer) throws Throwable {
        List<URL> additionalJars = null;
        ResourceDiscoveryComponent discoveryComponent = this.getDiscoveryComponent(resource.getResourceType(), parentContainer);
        if (discoveryComponent != null && discoveryComponent instanceof ClassLoaderFacet) {
            additionalJars = this.inventoryManager.invokeDiscoveryComponentClassLoaderFacet(resource, discoveryComponent, parentContainer);
        }
        return additionalJars;
    }

    private Object instantiateClass(ClassLoader loader, String className) throws PluginContainerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading class [" + className + "] via classloader [" + loader + ']'));
        }
        if (loader == null) {
            throw new PluginContainerException("Cannot load class [" + className + "] with null classloader");
        }
        try {
            Class<?> clazz = Class.forName(className, true, loader);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loaded class [" + clazz + "] from classloader [" + loader + ']'));
            }
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new PluginContainerException("Could not instantiate plugin class [" + className + "] from classloader [" + loader + "]", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PluginContainerException("Could not access plugin class [" + className + "] from classloader [" + loader + "]", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new PluginContainerException("Could not find plugin class [" + className + "] from classloader [" + loader + "]", (Throwable)e);
        }
        catch (NullPointerException npe) {
            throw new PluginContainerException("Plugin class was 'null' using loader [" + loader + "]", (Throwable)npe);
        }
    }

    @Override
    public void shutdown() {
    }
}

