/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.plugin;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.pc.plugin.PluginEnvironment;
import org.rhq.core.pc.plugin.PluginLifecycleListenerManager;
import org.rhq.core.pluginapi.plugin.PluginLifecycleListener;

public class PluginLifecycleListenerManagerImpl
implements PluginLifecycleListenerManager {
    private static final Log log = LogFactory.getLog(PluginLifecycleListenerManagerImpl.class);
    private Map<String, PluginLifecycleListener> cache = new HashMap<String, PluginLifecycleListener>();

    @Override
    public PluginLifecycleListener loadListener(PluginDescriptor pluginDescriptor, PluginEnvironment pluginEnvironment) throws PluginContainerException {
        String listenerClassName;
        PluginLifecycleListener listener = this.cache.get(pluginDescriptor.getName());
        if (listener == null && (listenerClassName = this.getPluginLifecycleListenerClass(pluginDescriptor)) != null) {
            log.debug((Object)("Creating plugin lifecycle listener [" + listenerClassName + "] for plugin [" + pluginDescriptor.getName() + "]"));
            listener = (PluginLifecycleListener)this.instantiatePluginClass(pluginEnvironment, listenerClassName);
            log.debug((Object)("Created plugin lifecycle listener [" + listenerClassName + "] for plugin [" + pluginDescriptor.getName() + "]"));
        }
        return listener;
    }

    private String getPluginLifecycleListenerClass(PluginDescriptor pluginDescriptor) {
        String className = pluginDescriptor.getPluginLifecycleListener();
        if (className != null) {
            String pkg = pluginDescriptor.getPackage();
            if (className.indexOf(46) == -1 && pkg != null) {
                className = pkg + '.' + className;
            }
        }
        return className;
    }

    private Object instantiatePluginClass(PluginEnvironment environment, String className) throws PluginContainerException {
        ClassLoader loader = environment.getPluginClassLoader();
        log.debug((Object)("Loading class [" + className + "]..."));
        try {
            Class<?> clazz = Class.forName(className, true, loader);
            log.debug((Object)("Loaded class [" + clazz + "]."));
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new PluginContainerException("Could not instantiate plugin class [" + className + "] from plugin environment [" + environment + "]", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PluginContainerException("Could not access plugin class " + className + "] from plugin environment [" + environment + "]", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new PluginContainerException("Could not find plugin class " + className + "] from plugin environment [" + environment + "]", (Throwable)e);
        }
        catch (NullPointerException npe) {
            throw new PluginContainerException("Plugin class was 'null' in plugin environment [" + environment + "]", (Throwable)npe);
        }
    }

    @Override
    public PluginLifecycleListener getListener(String pluginName) {
        return this.cache.get(pluginName);
    }

    @Override
    public void setListener(String pluginName, PluginLifecycleListener listener) {
        this.cache.put(pluginName, listener);
    }

    @Override
    public void shutdown() {
        this.cache.clear();
        this.cache = null;
    }
}

