/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.plugin;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.metadata.PluginDependencyGraph;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.clientapi.descriptor.AgentPluginDescriptorUtil;
import org.rhq.core.clientapi.descriptor.PluginTransformer;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.plugin.ClassLoaderManager;
import org.rhq.core.pc.plugin.PluginDescriptorLoader;
import org.rhq.core.pc.plugin.PluginEnvironment;
import org.rhq.core.pc.plugin.PluginFinder;
import org.rhq.core.pc.plugin.PluginLifecycleListenerManager;
import org.rhq.core.pc.plugin.RootPluginClassLoader;
import org.rhq.core.pluginapi.plugin.PluginContext;
import org.rhq.core.pluginapi.plugin.PluginLifecycleListener;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.util.exception.ThrowableUtil;

public class PluginManager
implements ContainerService {
    private static final Log log = LogFactory.getLog(PluginManager.class);
    private final Map<String, PluginEnvironment> loadedPluginEnvironments;
    private final List<Plugin> loadedPlugins;
    private final PluginMetadataManager metadataManager;
    private final ClassLoaderManager classLoaderManager;
    private final PluginContainerConfiguration pluginContainerConfiguration;
    private final PluginLifecycleListenerManager pluginLifecycleListenerMgr;
    private final UpdateLoadedPlugins updateLoadedPlugins;

    public PluginManager(PluginContainerConfiguration pluginContainerConfiguration, PluginLifecycleListenerManager pluginLifecycleListenerManager) {
        if (pluginContainerConfiguration == null) {
            throw new NullPointerException("pluginContainerConfiguration is null");
        }
        if (pluginLifecycleListenerManager == null) {
            throw new NullPointerException("pluginLifecycleListenerManager is null");
        }
        this.pluginContainerConfiguration = pluginContainerConfiguration;
        this.pluginLifecycleListenerMgr = pluginLifecycleListenerManager;
        this.loadedPluginEnvironments = new HashMap<String, PluginEnvironment>();
        this.loadedPlugins = new ArrayList<Plugin>();
        this.metadataManager = new PluginMetadataManager();
        this.metadataManager.setDisabledResourceTypes(pluginContainerConfiguration.getDisabledResourceTypes());
        this.updateLoadedPlugins = new UpdateLoadedPlugins(){
            PluginTransformer transformer = new PluginTransformer();

            @Override
            public void execute(PluginDescriptor pluginDescriptor, URL pluginURL) {
                Plugin plugin = this.transformer.toPlugin(pluginDescriptor, pluginURL);
                PluginManager.this.loadedPlugins.add(plugin);
            }
        };
        PluginFinder finder = pluginContainerConfiguration.getPluginFinder();
        File tmpDir = pluginContainerConfiguration.getTemporaryDirectory();
        List<String> disabledPlugins = pluginContainerConfiguration.getDisabledPlugins();
        ClassLoader thisClassLoader = this.getClass().getClassLoader();
        String rootPluginClassLoaderRegex = pluginContainerConfiguration.getRootPluginClassLoaderRegex();
        RootPluginClassLoader rootCL = new RootPluginClassLoader(new URL[0], thisClassLoader, rootPluginClassLoaderRegex);
        HashMap<String, URL> pluginNamesUrls = new HashMap<String, URL>();
        HashMap<URL, PluginDescriptor> descriptors = new HashMap<URL, PluginDescriptor>();
        PluginDependencyGraph graph = new PluginDependencyGraph();
        boolean createResourceCL = pluginContainerConfiguration.isCreateResourceClassloaders();
        this.classLoaderManager = new ClassLoaderManager(pluginNamesUrls, graph, rootCL, tmpDir, createResourceCL);
        if (finder == null) {
            log.warn((Object)"No plugin finder was specified in the plugin container configuration - this should only occur within test environments.");
            return;
        }
        try {
            Collection<URL> pluginUrls = finder.findPlugins();
            for (URL url : pluginUrls) {
                log.debug((Object)("Plugin found at: " + url));
                try {
                    PluginDescriptor descriptor = AgentPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)url);
                    if (!disabledPlugins.contains(descriptor.getName())) {
                        AgentPluginDescriptorUtil.addPluginToDependencyGraph((PluginDependencyGraph)graph, (PluginDescriptor)descriptor);
                        pluginNamesUrls.put(descriptor.getName(), url);
                        descriptors.put(url, descriptor);
                        continue;
                    }
                    log.info((Object)("Not loading disabled plugin: " + url));
                }
                catch (Throwable t) {
                    log.error((Object)("Plugin at [" + url + "] could not be loaded and will therefore not be deployed."), t);
                }
            }
            List deploymentOrder = graph.getDeploymentOrder();
            for (String nextPlugin : deploymentOrder) {
                URL pluginUrl = (URL)pluginNamesUrls.get(nextPlugin);
                try {
                    ClassLoader pluginClassLoader = this.classLoaderManager.obtainPluginClassLoader(nextPlugin);
                    PluginDescriptor descriptor = (PluginDescriptor)descriptors.get(pluginUrl);
                    this.loadPlugin(pluginUrl, pluginClassLoader, descriptor);
                }
                catch (Throwable t) {
                    log.error((Object)("Plugin [" + nextPlugin + "] at [" + pluginUrl + "] could not be loaded and will therefore not be deployed."), t);
                }
            }
            log.info((Object)("Deployed plugins: " + this.loadedPlugins));
            this.metadataManager.cleanupDescriptors();
        }
        catch (Exception e) {
            this.shutdown();
            log.error((Object)"Error initializing plugin container", (Throwable)e);
            throw new RuntimeException("Cannot initialize the plugin container", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Collections.reverse(this.loadedPlugins);
        for (Plugin plugin : this.loadedPlugins) {
            PluginLifecycleListener listener = this.pluginLifecycleListenerMgr.getListener(plugin.getName());
            if (listener == null) continue;
            try {
                ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.classLoaderManager.obtainPluginClassLoader(plugin.getName()));
                try {
                    listener.shutdown();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalCL);
                }
            }
            catch (Throwable t) {
                log.warn((Object)("Failed to get lifecycle listener to shutdown [" + plugin.getName() + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)t)));
            }
        }
        for (PluginEnvironment pluginEnvironment : this.loadedPluginEnvironments.values()) {
            pluginEnvironment.destroy();
        }
        this.classLoaderManager.destroy();
        this.loadedPluginEnvironments.clear();
        this.loadedPlugins.clear();
        this.pluginLifecycleListenerMgr.shutdown();
    }

    public Collection<PluginEnvironment> getPlugins() {
        return this.loadedPluginEnvironments.values();
    }

    @Nullable
    public PluginEnvironment getPlugin(String name) {
        return this.loadedPluginEnvironments.get(name);
    }

    public PluginMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    public ClassLoaderManager getClassLoaderManager() {
        return this.classLoaderManager;
    }

    public String getAmpsVersion(String pluginName) {
        for (Plugin plugin : this.loadedPlugins) {
            if (!plugin.getName().equals(pluginName)) continue;
            return plugin.getAmpsVersion();
        }
        return null;
    }

    private void loadPlugin(URL pluginUrl, ClassLoader classLoader, PluginDescriptor pluginDescriptor) throws PluginContainerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading plugin from [" + pluginUrl + "] in classloader [" + classLoader + "]..."));
        }
        PluginDescriptorLoader pluginDescriptorLoader = new PluginDescriptorLoader(pluginUrl, classLoader);
        PluginEnvironment pluginEnvironment = new PluginEnvironment(pluginDescriptor.getName(), pluginDescriptorLoader);
        String pluginName = pluginEnvironment.getPluginName();
        PluginLifecycleListener overseer = this.getPluginLifecycleListener(pluginName, pluginEnvironment, pluginDescriptor);
        if (overseer != null) {
            PluginContext context = this.createPluginContext(pluginName);
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                overseer.initialize(context);
            }
            catch (Throwable t) {
                throw new PluginContainerException("Plugin Lifecycle Listener failed to initialize plugin", t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
        this.loadedPluginEnvironments.put(pluginName, pluginEnvironment);
        this.metadataManager.loadPlugin(pluginDescriptor);
        this.pluginLifecycleListenerMgr.setListener(pluginDescriptor.getName(), overseer);
        this.updateLoadedPlugins.execute(pluginDescriptor, pluginUrl);
    }

    private PluginLifecycleListener getPluginLifecycleListener(String pluginName, PluginEnvironment pluginEnvironment, PluginDescriptor pluginDescriptor) throws PluginContainerException {
        return this.pluginLifecycleListenerMgr.loadListener(pluginDescriptor, pluginEnvironment);
    }

    private PluginContext createPluginContext(String pluginName) {
        SystemInfo sysInfo = SystemInfoFactory.createSystemInfo();
        File dataDir = new File(this.pluginContainerConfiguration.getDataDirectory(), pluginName);
        File tmpDir = this.pluginContainerConfiguration.getTemporaryDirectory();
        String pcName = this.pluginContainerConfiguration.getContainerName();
        PluginContext context = new PluginContext(pluginName, sysInfo, tmpDir, dataDir, pcName);
        return context;
    }

    private void getDependentUrls(String pluginName, Map<String, URL> pluginNamesUrls, Set<URL> allUrls) {
        List deps = this.classLoaderManager.getPluginDependencyGraph().getPluginDependencies(pluginName);
        for (String dep : deps) {
            this.getDependentUrls(dep, pluginNamesUrls, allUrls);
            allUrls.add(pluginNamesUrls.get(dep));
        }
    }

    private static interface UpdateLoadedPlugins {
        public void execute(PluginDescriptor var1, URL var2);
    }
}

