/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.upgrade;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.metadata.ResourceTypeNotEnabledException;
import org.rhq.core.clientapi.agent.upgrade.ResourceUpgradeRequest;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;

public class ResourceUpgradeDelegate {
    private static final Log log = LogFactory.getLog(ResourceUpgradeDelegate.class);
    private boolean enabled = true;
    private final Set<ResourceUpgradeRequest> requests = new HashSet<ResourceUpgradeRequest>();
    private final Set<ResourceUpgradeRequest> originalResourceData = new HashSet<ResourceUpgradeRequest>();
    private final InventoryManager inventoryManager;
    private final Set<Resource> failedResources = new HashSet<Resource>();
    private final Map<Resource, Set<ResourceType>> failedResourceTypesPerParent = new HashMap<Resource, Set<ResourceType>>();
    private boolean mergeFailed;

    public ResourceUpgradeDelegate(InventoryManager inventoryManager) {
        this.inventoryManager = inventoryManager;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean processAndQueue(ResourceContainer resourceContainer) throws PluginContainerException {
        if (this.enabled) {
            return this.executeResourceUpgradeFacetAndStoreRequest(resourceContainer);
        }
        return true;
    }

    public boolean hasUpgradeMergeFailed() {
        return this.mergeFailed;
    }

    public boolean hasUpgradeFailed(Resource resource) {
        return this.mergeFailed || this.failedResources.contains(resource);
    }

    public boolean hasUpgradeFailedInChildren(Resource parentResource, ResourceType childrenResourceType) {
        if (this.mergeFailed) {
            return true;
        }
        Set<ResourceType> failedTypes = this.failedResourceTypesPerParent.get(parentResource);
        return failedTypes != null && failedTypes.contains(childrenResourceType);
    }

    public void sendRequests() throws Throwable {
        if (this.enabled && this.requests.size() > 0) {
            try {
                Resource resource;
                ResourceContainer container;
                for (ResourceUpgradeRequest request : this.requests) {
                    container = this.inventoryManager.getResourceContainer(request.getResourceId());
                    if (container == null) continue;
                    resource = container.getResource();
                    String upgradeErrors = null;
                    upgradeErrors = this.checkUpgradeValid(resource, (ResourceUpgradeReport)request);
                    if (upgradeErrors == null) continue;
                    ResourceUpgradeRequest orig = this.findOriginal(request);
                    if (orig != null) {
                        orig.updateResource(resource);
                    }
                    String errorString = "Upgrading the resource [" + resource + "] using these updates [" + request + "] would render the inventory invalid because of the following reasons: " + upgradeErrors;
                    request.updateResource(resource);
                    log.error((Object)errorString);
                    IllegalStateException ex = new IllegalStateException(errorString);
                    ex.fillInStackTrace();
                    request.setErrorProperties((Throwable)ex);
                    request.clearUpgradeData();
                    if (request.getUpgradeErrorMessage() == null) continue;
                    this.rememberFailure(resource);
                    this.inventoryManager.deactivateResource(resource);
                }
                for (ResourceUpgradeRequest request : this.originalResourceData) {
                    container = this.inventoryManager.getResourceContainer(request.getResourceId());
                    if (container == null) continue;
                    resource = container.getResource();
                    request.updateResource(resource);
                }
                this.inventoryManager.mergeResourcesFromUpgrade(this.requests);
                for (ResourceUpgradeRequest request : this.requests) {
                    container = this.inventoryManager.getResourceContainer(request.getResourceId());
                    if (container == null) continue;
                    resource = container.getResource();
                    try {
                        this.inventoryManager.activateResource(resource, container, true);
                    }
                    catch (InvalidPluginConfigurationException e) {
                        log.debug((Object)("Resource [" + resource + "] failed to start up after upgrade."), (Throwable)e);
                        this.inventoryManager.handleInvalidPluginConfigurationResourceError(resource, e);
                    }
                    catch (Throwable t) {
                        log.error((Object)("Failed to activate the resource [" + resource + "] after upgrade."), t);
                        this.inventoryManager.handleInvalidPluginConfigurationResourceError(resource, t);
                    }
                }
            }
            catch (Throwable t) {
                this.mergeFailed = true;
                for (ResourceUpgradeRequest request : this.requests) {
                    ResourceContainer container = this.inventoryManager.getResourceContainer(request.getResourceId());
                    if (container == null) continue;
                    this.inventoryManager.deactivateResource(container.getResource());
                }
                throw t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ResourceComponent<?>> boolean executeResourceUpgradeFacetAndStoreRequest(ResourceContainer resourceContainer) throws PluginContainerException {
        boolean isResConfigCompacted;
        ResourceDiscoveryComponent discoveryComponent;
        ResourceComponent parentResourceComponent = resourceContainer.getResourceContext().getParentResourceComponent();
        Resource parentResource = resourceContainer.getResource().getParentResource();
        ResourceContainer parentResourceContainer = parentResource != null ? this.inventoryManager.getResourceContainer(resourceContainer.getResource().getParentResource()) : null;
        ResourceContext parentResourceContext = parentResourceContainer == null ? null : parentResourceContainer.getResourceContext();
        Resource resource = resourceContainer.getResource();
        try {
            discoveryComponent = this.inventoryManager.getPluginComponentFactory().getDiscoveryComponent(resource.getResourceType(), parentResourceContainer);
        }
        catch (ResourceTypeNotEnabledException rtne) {
            return true;
        }
        if (!(discoveryComponent instanceof ResourceUpgradeFacet)) {
            return true;
        }
        boolean bl = isResConfigCompacted = null == resource.getResourceConfiguration();
        if (isResConfigCompacted) {
            resource.setResourceConfiguration(InventoryManager.getResourceConfiguration(resource));
        }
        ResourceUpgradeContext<ResourceComponent> upgradeContext = this.inventoryManager.createResourceUpgradeContext(resource, parentResourceContext, parentResourceComponent, discoveryComponent);
        ResourceUpgradeRequest request = new ResourceUpgradeRequest(resource.getId());
        request.setTimestamp(System.currentTimeMillis());
        ResourceUpgradeReport upgradeReport = null;
        try {
            upgradeReport = this.inventoryManager.invokeDiscoveryComponentResourceUpgradeFacet(resource.getResourceType(), discoveryComponent, upgradeContext, parentResourceContainer);
        }
        catch (Throwable t) {
            log.error((Object)("ResourceUpgradeFacet threw an exception while upgrading resource [" + resource + "]"), t);
            request.setErrorProperties(t);
        }
        finally {
            if (isResConfigCompacted) {
                resource.setResourceConfiguration(null);
            }
        }
        if (upgradeReport != null && upgradeReport.hasSomethingToUpgrade()) {
            request.fillInFromReport(upgradeReport);
        }
        if (request.hasSomethingToUpgrade()) {
            this.requests.add(request);
        }
        if (request.getUpgradeErrorMessage() != null) {
            this.rememberFailure(resource);
            return false;
        }
        ResourceUpgradeRequest original = new ResourceUpgradeRequest(resource.getId());
        original.fillInFromResource(resource);
        this.originalResourceData.add(original);
        request.updateResource(resource);
        return true;
    }

    private String checkUpgradeValid(Resource resource, ResourceUpgradeReport upgradeReport) {
        StringBuilder s = new StringBuilder();
        Set<Resource> duplicitSiblings = this.findDuplicitSiblingResources(resource, upgradeReport);
        if (!duplicitSiblings.isEmpty()) {
            s.append("After the upgrade, the following resources would have the same resource key which is illegal. This is an issue of either the old or the new version of the plugin '" + resource.getResourceType().getPlugin() + "'. Please consult the documentation of the plugin to see what are the recommended steps to resolve this situation:\n");
            for (Resource r : duplicitSiblings) {
                ResourceUpgradeRequest fakeRequest = new ResourceUpgradeRequest(r.getId());
                fakeRequest.fillInFromResource(r);
                ResourceUpgradeRequest orig = this.findOriginal(fakeRequest);
                if (orig != null) {
                    orig.updateResource(r);
                }
                s.append(r).append(",\n");
                if (orig == null) continue;
                fakeRequest.updateResource(r);
            }
            s.replace(s.length() - 2, s.length(), "");
        }
        return s.length() > 0 ? s.toString() : null;
    }

    private Set<Resource> findDuplicitSiblingResources(Resource resource, ResourceUpgradeReport upgradeReport) {
        Resource parent = resource.getParentResource();
        if (parent == null) {
            return Collections.emptySet();
        }
        HashSet<Resource> ret = new HashSet<Resource>();
        for (Resource sibling : parent.getChildResources()) {
            if (upgradeReport.getNewResourceKey() == null || !sibling.getResourceType().equals((Object)resource.getResourceType()) || sibling.getUuid().equals(resource.getUuid()) || !sibling.getResourceKey().equals(upgradeReport.getNewResourceKey())) continue;
            ret.add(sibling);
        }
        return ret;
    }

    private void rememberFailure(Resource resource) {
        this.failedResources.add(resource);
        Resource parentResource = resource.getParentResource();
        Set<ResourceType> failedResourceTypesInParent = this.failedResourceTypesPerParent.get(parentResource);
        if (failedResourceTypesInParent == null) {
            failedResourceTypesInParent = new HashSet<ResourceType>();
            this.failedResourceTypesPerParent.put(parentResource, failedResourceTypesInParent);
        }
        failedResourceTypesInParent.add(resource.getResourceType());
    }

    private ResourceUpgradeRequest findOriginal(ResourceUpgradeRequest request) {
        for (ResourceUpgradeRequest original : this.originalResourceData) {
            if (!original.equals((Object)request)) continue;
            return original;
        }
        return null;
    }
}

