/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.plugin.BlacklistedException;
import org.rhq.core.pc.plugin.PluginComponentFactory;
import org.rhq.core.pc.util.LoggingThreadFactory;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;

public class DiscoveryComponentProxyFactory {
    private static final Log log = LogFactory.getLog(DiscoveryComponentProxyFactory.class);
    private static final String DAEMON_THREAD_POOL_NAME = "ResourceDiscoveryComponent.invoker.daemon";
    private ExecutorService daemonThreadPool = null;
    private final Set<ResourceType> blacklist = new HashSet<ResourceType>();
    private final PluginComponentFactory pluginComponentFactory;
    private static boolean blacklistDisable;

    public DiscoveryComponentProxyFactory(PluginComponentFactory pluginComponentFactory) {
        this.pluginComponentFactory = pluginComponentFactory;
    }

    public <T> T getDiscoveryComponentProxy(ResourceType type, ResourceDiscoveryComponent component, long timeout, Class<T> componentInterface, ResourceContainer parentResourceContainer) throws PluginContainerException, BlacklistedException {
        if (this.isResourceTypeBlacklisted(type)) {
            throw new BlacklistedException("Discovery component for resource type [" + type + "] has been blacklisted");
        }
        try {
            ClassLoader pluginClassLoader = this.pluginComponentFactory.getDiscoveryComponentClassLoader(parentResourceContainer, type.getPlugin());
            ResourceDiscoveryComponentInvocationHandler handler = new ResourceDiscoveryComponentInvocationHandler(type, component, timeout, pluginClassLoader, componentInterface);
            Object proxy = Proxy.newProxyInstance(pluginClassLoader, new Class[]{componentInterface}, (InvocationHandler)handler);
            return (T)proxy;
        }
        catch (Throwable t) {
            throw new PluginContainerException("Cannot get discovery component proxy for [" + component + "]", t);
        }
    }

    public ResourceDiscoveryComponent getDiscoveryComponentProxy(ResourceType type, ResourceDiscoveryComponent component, long timeout, ResourceContainer parentResourceContainer) throws PluginContainerException, BlacklistedException {
        return this.getDiscoveryComponentProxy(type, component, timeout, ResourceDiscoveryComponent.class, parentResourceContainer);
    }

    public void initialize() {
        LoggingThreadFactory daemonFactory = new LoggingThreadFactory(DAEMON_THREAD_POOL_NAME, true);
        this.daemonThreadPool = Executors.newCachedThreadPool(daemonFactory);
    }

    public void shutdown() {
        if (this.daemonThreadPool != null) {
            PluginContainer.shutdownExecutorService(this.daemonThreadPool, true);
            this.daemonThreadPool = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<ResourceType> getResourceTypeBlacklist() {
        Set<ResourceType> set = this.blacklist;
        synchronized (set) {
            return new HashSet<ResourceType>(this.blacklist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearResourceTypeBlacklist() {
        Set<ResourceType> set = this.blacklist;
        synchronized (set) {
            this.blacklist.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResourceTypeBlacklisted(ResourceType type) {
        if (blacklistDisable) {
            return false;
        }
        Set<ResourceType> set = this.blacklist;
        synchronized (set) {
            return this.blacklist.contains(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceTypeToBlacklist(ResourceType type) {
        if (blacklistDisable) {
            return;
        }
        Set<ResourceType> set = this.blacklist;
        synchronized (set) {
            this.blacklist.add(type);
        }
        log.warn((Object)("The discovery component for resource type [" + type + "] has been blacklisted"));
    }

    private ExecutorService getThreadPool() {
        return this.daemonThreadPool;
    }

    static {
        try {
            blacklistDisable = Boolean.valueOf(System.getProperty("rhq.agent.blacklist.disable", "false"));
        }
        catch (Throwable t) {
            blacklistDisable = false;
        }
    }

    private class ComponentInvocationThread
    implements Callable {
        private final ResourceDiscoveryComponent component;
        private final Method method;
        private final Object[] args;
        private final ClassLoader pluginClassLoader;
        private Thread thread;

        ComponentInvocationThread(ResourceDiscoveryComponent component, Method method, Object[] args, ClassLoader pluginClassLoader) {
            this.component = component;
            this.method = method;
            this.args = args;
            this.pluginClassLoader = pluginClassLoader;
        }

        public Object call() throws Exception {
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Object results;
                this.thread = Thread.currentThread();
                this.thread.setContextClassLoader(this.pluginClassLoader);
                Object object = results = this.method.invoke((Object)this.component, this.args);
                return object;
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                throw new Exception("Discovery component invocation failed.", cause);
            }
            catch (Throwable t) {
                throw new Exception("Failed to invoke discovery component", t);
            }
            finally {
                this.thread.setContextClassLoader(originalContextClassLoader);
                this.thread = null;
            }
        }

        public Thread getThread() {
            return this.thread;
        }
    }

    private class ResourceDiscoveryComponentInvocationHandler
    implements InvocationHandler {
        private final ResourceDiscoveryComponent component;
        private final long timeout;
        private final ResourceType resourceType;
        private final ClassLoader pluginClassLoader;
        private final Class<?> componentInterface;

        public ResourceDiscoveryComponentInvocationHandler(ResourceType type, ResourceDiscoveryComponent component, long timeout, ClassLoader pluginClassLoader, Class<?> componentInterface) {
            if (timeout <= 0L) {
                throw new IllegalArgumentException("timeout value is not positive.");
            }
            if (component == null) {
                throw new IllegalArgumentException("component is null");
            }
            this.resourceType = type;
            this.component = component;
            this.timeout = timeout;
            this.pluginClassLoader = pluginClassLoader;
            this.componentInterface = componentInterface;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (DiscoveryComponentProxyFactory.this.isResourceTypeBlacklisted(this.resourceType)) {
                throw new RuntimeException("Discovery component for resource type [" + this.resourceType + "] has been blacklisted and can no longer be invoked.");
            }
            if (this.componentInterface.isAssignableFrom(method.getDeclaringClass())) {
                return this.invokeInNewThread(method, args);
            }
            return this.invokeInCurrentThread(method, args);
        }

        private Object invokeInNewThread(Method method, Object[] args) throws Throwable {
            ExecutorService threadPool = DiscoveryComponentProxyFactory.this.getThreadPool();
            ComponentInvocationThread invocationThread = new ComponentInvocationThread(this.component, method, args, this.pluginClassLoader);
            Future future = threadPool.submit(invocationThread);
            try {
                return future.get(this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Thread [" + Thread.currentThread().getName() + "] was interrupted."));
                }
                future.cancel(true);
                Thread.currentThread().interrupt();
                throw new RuntimeException(this.invokedMethodString(method, args, "was interrupted."));
            }
            catch (ExecutionException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.invokedMethodString(method, args, "failed."), (Throwable)e);
                }
                throw e.getCause();
            }
            catch (TimeoutException e) {
                Exception cause;
                DiscoveryComponentProxyFactory.this.addResourceTypeToBlacklist(this.resourceType);
                String msg = this.invokedMethodString(method, args, "timed out. Invocation thread will be interrupted.");
                Thread thread = invocationThread.getThread();
                if (thread != null) {
                    StackTraceElement[] stackTrace = thread.getStackTrace();
                    cause = new Exception(thread + " with id [" + thread.getId() + "] is hung. This exception contains its stack trace.");
                    cause.setStackTrace(stackTrace);
                } else {
                    cause = null;
                }
                org.rhq.core.pc.inventory.TimeoutException timeoutException = new org.rhq.core.pc.inventory.TimeoutException(msg, cause);
                future.cancel(true);
                throw timeoutException;
            }
        }

        private Object invokeInCurrentThread(Method method, Object[] args) throws Throwable {
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.pluginClassLoader);
                Object object = method.invoke((Object)this.component, args);
                return object;
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause() != null ? ite.getCause() : ite;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }

        private String invokedMethodString(Method method, Object[] methodArgs, String extraMsg) {
            String name = this.component.getClass().getName() + '.' + method.getName() + "()";
            String args = methodArgs != null ? Arrays.asList(methodArgs).toString() : "";
            return "Call to [" + name + "] with args [" + args + "] " + extraMsg;
        }
    }
}

