/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.embeddedagent.extension;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.Preferences;
import org.apache.log4j.LogManager;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.logging.Logger;
import org.jboss.modules.Resource;
import org.jboss.util.StringPropertyReplacer;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.agent.AgentConfiguration;
import org.rhq.enterprise.agent.AgentConfigurationUpgrade;

public class AgentConfigurationSetup {
    private final Logger log = Logger.getLogger(AgentConfigurationSetup.class);
    private static final String DATA_DIRECTORY_NAME = "embeddedagent";
    private final Resource configFile;
    private final Map<String, String> configurationOverrides;
    private final boolean resetConfigurationAtStartup;
    private final String preferencesNodeName;
    private final ServerEnvironment serverEnvironment;

    public AgentConfigurationSetup(Resource configFile, boolean resetConfigurationAtStartup, Map<String, String> overrides, ServerEnvironment serverEnv) {
        String agentName;
        this.configFile = configFile;
        this.resetConfigurationAtStartup = resetConfigurationAtStartup;
        this.serverEnvironment = serverEnv;
        this.configurationOverrides = this.prepareConfigurationOverrides(overrides);
        this.preferencesNodeName = agentName = this.configurationOverrides.get("rhq.agent.name");
        System.setProperty("rhq.agent.preferences-node", this.preferencesNodeName);
    }

    public String getPreferencesNodeName() {
        return this.preferencesNodeName;
    }

    private Map<String, String> prepareConfigurationOverrides(Map<String, String> overrides) {
        String agentName = overrides.get("rhq.agent.name");
        if (agentName == null || agentName.trim().length() == 0 || "-".equals(agentName)) {
            agentName = "embeddedagent-" + this.serverEnvironment.getNodeName();
        }
        agentName = StringPropertyReplacer.replaceProperties((String)agentName);
        overrides.put("rhq.agent.name", agentName);
        File dataDir = this.getAgentDataDirectory();
        File pluginsDir = new File(this.serverEnvironment.getServerDataDir(), "embeddedagent-plugins");
        overrides.put("rhq.agent.data-directory", dataDir.getAbsolutePath());
        overrides.put("rhq.agent.plugins.directory", pluginsDir.getAbsolutePath());
        overrides.put("rhq.communications.data-directory", dataDir.getAbsolutePath());
        overrides.put("rhq.agent.do-not-override-prefs-with-sysprops", "true");
        overrides.put("rhq.communications.service-container.mbean-server-name", "rhqembeddedagent");
        overrides.put("rhq.agent.do-not-install-shutdown-hook", "true");
        return overrides;
    }

    private File getAgentDataDirectory() {
        File dir = new File(this.serverEnvironment.getServerDataDir(), DATA_DIRECTORY_NAME);
        dir.mkdirs();
        return dir;
    }

    public void preConfigureAgent() throws Exception {
        if (this.resetConfigurationAtStartup) {
            this.log.debug((Object)"Resetting the embedded agent's configuration back to its original settings");
            this.reloadAgentConfiguration();
            this.cleanDataDirectory();
        } else {
            this.log.debug((Object)"Loading the embedded agent's pre-existing configuration from preferences");
            this.prepareConfigurationPreferences();
        }
    }

    public void prepareLogConfigFile(Resource logConfigFile) throws Exception {
        try {
            File logDir = this.serverEnvironment.getServerLogDir();
            String agentLogFile = new File(logDir, "embedded-agent.log").getAbsolutePath();
            String cmdTraceLogFile = new File(logDir, "embedded-agent-command-trace.log").getAbsolutePath();
            String logConfig = new String(StreamUtil.slurp((InputStream)logConfigFile.openStream()));
            logConfig = logConfig.replace("\"logs/agent.log\"", "\"" + agentLogFile + "\"");
            logConfig = logConfig.replace("\"logs/command-trace.log\"", "\"" + cmdTraceLogFile + "\"");
            for (String app : new String[]{"ref=\"FILE\"", "ref=\"COMMANDTRACE\""}) {
                logConfig = logConfig.replace("<!-- <appender-ref " + app + "/> -->", "<appender-ref " + app + "/>");
            }
            File runtimeLogConfigFile = new File(this.getAgentDataDirectory(), "/log4j.xml");
            ByteArrayInputStream in = new ByteArrayInputStream(logConfig.getBytes());
            StreamUtil.copy((InputStream)in, (OutputStream)new FileOutputStream(runtimeLogConfigFile));
            LogManager.resetConfiguration();
            DOMConfigurator.configure((URL)runtimeLogConfigFile.toURI().toURL());
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot tell the agent to put its logs in the logs directory - look elsewhere for the log files");
        }
    }

    private Properties getAgentConfigurationProperties() {
        try {
            Properties properties = new Properties();
            Preferences prefs = this.getPreferencesNode();
            for (String key : prefs.keys()) {
                properties.setProperty(key, prefs.get(key, "?"));
            }
            return properties;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void reloadAgentConfiguration() throws Exception {
        Preferences prefNode = this.getPreferencesNode();
        prefNode.putInt("rhq.agent.configuration-schema-version", 0);
        prefNode.flush();
        this.prepareConfigurationPreferences();
    }

    private void cleanDataDirectory() {
        AgentConfiguration config = new AgentConfiguration(this.getPreferencesNode());
        File dataDir = config.getDataDirectory();
        this.cleanDataFile(dataDir);
        File commDataDir = config.getServiceContainerPreferences().getDataDirectory();
        if (!commDataDir.getAbsolutePath().equals(dataDir.getAbsolutePath())) {
            this.cleanDataFile(commDataDir);
        }
    }

    private AgentConfiguration prepareConfigurationPreferences() throws Exception {
        Map<String, String> overrides;
        Preferences prefNode = this.getPreferencesNode();
        AgentConfiguration config = new AgentConfiguration(prefNode);
        if (config.getAgentConfigurationVersion() == 0) {
            config = this.loadConfigurationFile();
        }
        if ((overrides = this.configurationOverrides) != null) {
            for (Map.Entry<String, String> entry : overrides.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                value = StringPropertyReplacer.replaceProperties((String)value);
                prefNode.put(key, value);
            }
        }
        AgentConfigurationUpgrade.upgradeToLatest((Preferences)config.getPreferences());
        return config;
    }

    private AgentConfiguration loadConfigurationFile() throws Exception {
        Preferences prefNode = this.getPreferencesNode();
        String securityToken = prefNode.get("rhq.agent.security-token", null);
        ByteArrayOutputStream backup = new ByteArrayOutputStream();
        prefNode.exportSubtree(backup);
        prefNode.clear();
        try {
            ByteArrayOutputStream rawConfigFile = new ByteArrayOutputStream();
            InputStream rawConfigInputStream = this.configFile.openStream();
            StreamUtil.copy((InputStream)rawConfigInputStream, (OutputStream)rawConfigFile, (boolean)true);
            String newConfig = StringPropertyReplacer.replaceProperties((String)rawConfigFile.toString());
            ByteArrayInputStream newConfigInputStream = new ByteArrayInputStream(newConfig.getBytes());
            Preferences.importPreferences(newConfigInputStream);
            AgentConfiguration newAgentConfig = new AgentConfiguration(prefNode);
            if (newAgentConfig.getAgentConfigurationVersion() == 0) {
                throw new IllegalArgumentException("Bad preferences node");
            }
            if (securityToken != null) {
                if (newAgentConfig.getAgentSecurityToken() == null) {
                    this.log.debug((Object)"Restoring embedded agent security token");
                    newAgentConfig.setAgentSecurityToken(securityToken);
                } else {
                    this.log.debug((Object)"Not restoring embedded agent security token, the config file was preconfigured with one");
                }
            }
            prefNode.flush();
        }
        catch (Exception e) {
            try {
                Preferences.importPreferences(new ByteArrayInputStream(backup.toByteArray()));
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw e;
        }
        AgentConfiguration agentConfig = new AgentConfiguration(prefNode);
        return agentConfig;
    }

    private Preferences getPreferencesNode() {
        Preferences topNode = Preferences.userRoot().node("rhq-agent");
        Preferences prefNode = topNode.node(this.preferencesNodeName);
        return prefNode;
    }

    private void cleanDataFile(File file) {
        boolean deleted;
        File[] doomedFiles = file.listFiles();
        if (doomedFiles != null) {
            for (File doomedFile : doomedFiles) {
                this.cleanDataFile(doomedFile);
            }
        }
        if (!(deleted = file.delete())) {
            this.log.warn((Object)("Cannot clean data file [" + file + "]"));
        }
    }
}

