/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.embeddedagent.extension;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.Writer;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.Resource;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.rhq.embeddedagent.extension.AgentConfigurationSetup;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;

public class AgentService
implements Service<AgentService> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"org.rhq"}).append(new String[]{"embeddedagent"});
    private final Logger log = Logger.getLogger(AgentService.class);
    final InjectedValue<ServerEnvironment> envServiceValue = new InjectedValue();
    final InjectedValue<SocketBinding> agentListenerBinding = new InjectedValue();
    private Map<String, Boolean> plugins = Collections.synchronizedMap(new HashMap());
    private Map<String, String> configOverrides = Collections.synchronizedMap(new HashMap());
    private AtomicReference<AgentMain> theAgent = new AtomicReference();
    private Thread agentThread;

    public AgentService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        this.log.info((Object)"Embedded agent service starting");
        this.startAgent();
    }

    public void stop(StopContext context) {
        this.log.info((Object)"Embedded agent service stopping");
        this.stopAgent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Boolean> getPlugins() {
        Map<String, Boolean> map = this.plugins;
        synchronized (map) {
            return new HashMap<String, Boolean>(this.plugins);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPlugins(Map<String, Boolean> pluginsWithEnableFlag) {
        Map<String, Boolean> map = this.plugins;
        synchronized (map) {
            this.plugins.clear();
            if (pluginsWithEnableFlag != null) {
                this.plugins.putAll(pluginsWithEnableFlag);
            }
        }
        this.log.info((Object)("New plugin definitions: " + pluginsWithEnableFlag));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConfigurationOverrides(Map<String, String> overrides) {
        Map<String, String> map = this.configOverrides;
        synchronized (map) {
            this.configOverrides.clear();
            if (overrides != null) {
                this.configOverrides.putAll(overrides);
            }
        }
    }

    protected boolean isAgentStarted() {
        AgentMain agent = this.theAgent.get();
        return agent != null && agent.isStarted();
    }

    protected void startAgent() throws StartException {
        if (this.isAgentStarted()) {
            this.log.info((Object)"Embedded agent is already started.");
            return;
        }
        this.log.info((Object)"Starting the embedded agent now");
        try {
            SocketBinding agentListenerBindingValue = (SocketBinding)this.agentListenerBinding.getValue();
            String agentBindAddress = agentListenerBindingValue.getAddress().getHostAddress();
            String agentBindPort = String.valueOf(agentListenerBindingValue.getAbsolutePort());
            if (agentBindAddress.equals("0.0.0.0") || agentBindAddress.equals("::/128")) {
                agentBindAddress = InetAddress.getLocalHost().getCanonicalHostName();
            }
            this.configOverrides.put("rhq.communications.connector.bind-address", agentBindAddress);
            this.configOverrides.put("rhq.communications.connector.bind-port", agentBindPort);
            StringBuilder enabledPlugins = new StringBuilder();
            StringBuilder disabledPlugins = new StringBuilder();
            for (Map.Entry<String, Boolean> entry : this.plugins.entrySet()) {
                String pluginName = entry.getKey();
                Boolean enabled = entry.getValue();
                if (enabled.booleanValue()) {
                    enabledPlugins.append(enabledPlugins.length() > 0 ? "," : "").append(pluginName);
                    continue;
                }
                disabledPlugins.append(disabledPlugins.length() > 0 ? "," : "").append(pluginName);
            }
            if (enabledPlugins.length() > 0) {
                this.configOverrides.put("rhq.agent.plugins.enabled", enabledPlugins.toString());
            }
            if (disabledPlugins.length() > 0) {
                this.configOverrides.put("rhq.agent.plugins.disabled", disabledPlugins.toString());
            }
            ServerEnvironment env = (ServerEnvironment)this.envServiceValue.getValue();
            boolean resetConfigurationAtStartup = true;
            AgentConfigurationSetup configSetup = new AgentConfigurationSetup(this.getExportedResource("conf/agent-configuration.xml"), resetConfigurationAtStartup, this.configOverrides, env);
            configSetup.prepareLogConfigFile(this.getExportedResource("conf/log4j.xml"));
            configSetup.preConfigureAgent();
            String[] args = new String[]{"--daemon", "--pref=" + configSetup.getPreferencesNodeName(), "--output=" + new File(env.getServerLogDir(), "embedded-agent.out").getAbsolutePath()};
            this.theAgent.set(new AgentMain(args));
            this.agentThread = new Thread("Embedded Agent Start Thread"){

                @Override
                public void run() {
                    try {
                        ((AgentMain)AgentService.this.theAgent.get()).start();
                    }
                    catch (InterruptedException e) {
                        AgentService.this.log.debug((Object)"Embedded agent has exited.");
                    }
                    catch (Throwable t) {
                        AgentService.this.log.error((Object)"Embedded agent aborted with exception.", t);
                    }
                }
            };
            this.agentThread.setDaemon(true);
            this.agentThread.start();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopAgent() {
        try {
            if (!this.isAgentStarted()) {
                this.log.info((Object)"Embedded agent is already stopped.");
            } else {
                this.log.info((Object)"Stopping the embedded agent now");
                this.theAgent.get().shutdown();
            }
        }
        finally {
            if (this.agentThread != null) {
                this.agentThread.interrupt();
            }
        }
        this.theAgent.set(null);
    }

    protected String executePromptCommand(String command) throws Exception {
        AgentMain agent = this.theAgent.get();
        if (agent == null) {
            throw new IllegalStateException("Embedded agent is not available");
        }
        CharArrayWriter listener = new CharArrayWriter();
        AgentPrintWriter apw = agent.getOut();
        try {
            apw.addListener((Writer)listener);
            agent.executePromptCommand(command);
        }
        catch (Exception e) {
            throw new ExecutionException(listener.toString(), e);
        }
        finally {
            apw.removeListener((Writer)listener);
        }
        String output = listener.toString();
        return output;
    }

    private Resource getExportedResource(String name) {
        Module module = Module.forClass(this.getClass());
        Resource r = module.getExportedResource("rhq-agent", name);
        return r;
    }
}

