/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hadoop;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.hadoop.HadoopSupportedOperations;

public class HadoopOperationsDelegate {
    private static final Log LOG = LogFactory.getLog(HadoopOperationsDelegate.class);
    private static final long MAX_WAIT = 300000L;
    private static final int MAX_OUTPUT = 2048;
    private ResourceContext<? extends ResourceComponent<?>> resourceContext;

    public HadoopOperationsDelegate(ResourceContext<? extends ResourceComponent<?>> resourceContext) {
        this.resourceContext = resourceContext;
    }

    public OperationResult invoke(@NotNull HadoopSupportedOperations operation, Configuration parameters, String serverType) throws InterruptedException {
        ProcessExecutionResults results = null;
        switch (operation) {
            case FORMAT: {
                throw new UnsupportedOperationException("This operation requires user interaction.");
            }
            case FSCK: {
                results = this.fsck(operation);
                break;
            }
            case LS: {
                results = this.ls(operation);
                break;
            }
            case START: {
                results = this.start(operation, serverType);
                break;
            }
            case STOP: {
                results = this.stop(operation, serverType);
                break;
            }
            case QUEUE_LIST: {
                results = this.queueList(operation);
                break;
            }
            case JOB_LIST_RUNNING: {
                results = this.invokeGeneralOperation(operation);
                break;
            }
            case JOB_LIST_ALL: {
                results = this.invokeGeneralOperation(operation);
                break;
            }
            case REBALANCE_DFS: {
                results = this.invokeGeneralOperation(operation);
                break;
            }
            case KILL: {
                results = this.invokeGeneralOperation(operation, parameters, null);
                break;
            }
            case JAR: {
                results = this.invokeGeneralOperation(operation, parameters, null);
                break;
            }
            default: {
                throw new UnsupportedOperationException(operation.toString());
            }
        }
        String message = this.truncateString(results.getCapturedOutput());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CLI results: exitcode=[" + results.getExitCode() + "]; error=[" + results.getError() + "]; output=" + message));
        }
        OperationResult result = new OperationResult(message);
        return result;
    }

    private ProcessExecutionResults queueList(HadoopSupportedOperations operation) {
        return this.invokeGeneralOperation(operation);
    }

    private ProcessExecutionResults stop(HadoopSupportedOperations operation, String serverType) {
        return this.invokeGeneralOperation(operation, null, serverType);
    }

    private ProcessExecutionResults start(HadoopSupportedOperations operation, String serverType) {
        return this.invokeGeneralOperation(operation, null, serverType);
    }

    private ProcessExecutionResults format(HadoopSupportedOperations operation) {
        return this.invokeGeneralOperation(operation);
    }

    private ProcessExecutionResults ls(HadoopSupportedOperations operation) {
        return this.invokeGeneralOperation(operation);
    }

    private ProcessExecutionResults fsck(HadoopSupportedOperations operation) {
        return this.invokeGeneralOperation(operation);
    }

    private static ProcessExecutionResults executeExecutable(@NotNull SystemInfo sysInfo, String executable, String args, long wait, boolean captureOutput, boolean killOnTimeout) throws InvalidPluginConfigurationException {
        ProcessExecution processExecution = new ProcessExecution(executable);
        if (args != null) {
            processExecution.setArguments(args.split("[ \\t\\n]+"));
        }
        processExecution.setWaitForCompletion(wait);
        processExecution.setCaptureOutput(captureOutput);
        processExecution.setKillOnTimeout(killOnTimeout);
        ProcessExecutionResults results = sysInfo.executeProcess(processExecution);
        return results;
    }

    private String truncateString(String output) {
        String outputToLog = output;
        if (outputToLog != null && outputToLog.length() > 2048) {
            outputToLog = outputToLog.substring(0, 2048) + "...";
        }
        return outputToLog;
    }

    private ProcessExecutionResults invokeGeneralOperation(HadoopSupportedOperations operation) {
        return this.invokeGeneralOperation(operation, null, null);
    }

    private ProcessExecutionResults invokeGeneralOperation(HadoopSupportedOperations operation, Configuration parameters, String serverType) {
        String hadoopHome = this.resourceContext.getPluginConfiguration().getSimple("hadoop.home.dir").getStringValue();
        String executable = hadoopHome + operation.getRelativePathToExecutable();
        String args = operation.getArgs() + (serverType == null ? "" : serverType.toLowerCase());
        if (((Object)((Object)operation)).getClass() != null) {
            for (String paramName : operation.getParamsNames()) {
                args = args + " " + parameters.getSimpleValue(paramName);
            }
        }
        ProcessExecutionResults results = HadoopOperationsDelegate.executeExecutable(this.resourceContext.getSystemInformation(), executable, args, 300000L, true, operation.isKillOnTimeout());
        return results;
    }
}

