/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hadoop;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.support.metadata.LocalVMTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;

public class HadoopServerDiscovery
implements ResourceDiscoveryComponent<ResourceComponent<?>> {
    private final Log log = LogFactory.getLog(HadoopServerDiscovery.class);
    private static final String HADOOP_VERSION_MATCH = "hadoop-core-([0-9\\.]+)\\.jar";
    private static final Pattern HADOOP_VERSION_PATTERN = Pattern.compile("hadoop-core-([0-9\\.]+)\\.jar");
    private static final String MAIN_CLASS_PROPERTY = "_mainClass";
    public static final String HOME_DIR_PROPERTY = "hadoop.home.dir";
    private static final String HOME_DIR_OPTION = "-Dhadoop.home.dir";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ResourceComponent<?>> resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>();
        List processScans = resourceDiscoveryContext.getAutoDiscoveredProcesses();
        ResourceType resourceType = resourceDiscoveryContext.getResourceType();
        String rtName = resourceType.getName();
        for (ProcessScanResult psr : processScans) {
            String cwd = psr.getProcessInfo().getCurrentWorkingDirectory();
            String homeDir = this.getHadoopHomeDirIfAvailable(psr.getProcessInfo().getCommandLine());
            if (homeDir == null) {
                homeDir = cwd;
            }
            String version = this.getVersion(homeDir);
            Configuration pluginConfiguration = resourceDiscoveryContext.getDefaultPluginConfiguration();
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(resourceType, homeDir, rtName, version, rtName + " ( " + cwd + " )", pluginConfiguration, psr.getProcessInfo());
            pluginConfiguration.put((Property)new PropertySimple("commandLine", (Object)pluginConfiguration.getSimpleValue(MAIN_CLASS_PROPERTY, null)));
            pluginConfiguration.put((Property)new PropertySimple("type", (Object)LocalVMTypeDescriptor.class.getName()));
            pluginConfiguration.put((Property)new PropertySimple(HOME_DIR_PROPERTY, (Object)homeDir));
            this.log.debug((Object)("Discovered " + detail));
            details.add(detail);
        }
        return details;
    }

    private String getVersion(String hadoopHomeDir) {
        File homeDir = new File(hadoopHomeDir);
        if (homeDir.isDirectory() && homeDir.canRead()) {
            String[] foundCoreJars = homeDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return HADOOP_VERSION_PATTERN.matcher(name).matches();
                }
            });
            if (foundCoreJars == null || foundCoreJars.length == 0) {
                return null;
            }
            Matcher matcher = HADOOP_VERSION_PATTERN.matcher(foundCoreJars[0]);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return null;
        }
        return null;
    }

    private String getHadoopHomeDirIfAvailable(String[] cmdline) {
        for (int i = 0; i < cmdline.length; ++i) {
            int eqPos;
            String cmd = cmdline[i];
            if (!cmd.startsWith(HOME_DIR_OPTION) || (eqPos = cmd.indexOf(61)) <= 0) continue;
            return cmd.substring(eqPos + 1);
        }
        return null;
    }
}

