/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hadoop;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.hadoop.HadoopOperationsDelegate;
import org.rhq.plugins.hadoop.HadoopSupportedOperations;
import org.rhq.plugins.hadoop.JobTrackerServerComponent;

public class JobJarComponent
implements ResourceComponent<JobTrackerServerComponent>,
OperationFacet,
DeleteResourceFacet,
ContentFacet {
    public static final String RESOURCE_TYPE_NAME = "Job Jar";
    public static final String CONTENT_TYPE_NAME = "jobJar";
    public static final String JOB_JAR_PROP_NAME = "jobJar";
    private static final String SUBMIT_OP = "submit";
    private File jobJar;
    private ResourceContext<JobTrackerServerComponent> context;
    private HadoopOperationsDelegate operationsDelegate;

    public AvailabilityType getAvailability() {
        return this.jobJar.exists() ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public void start(ResourceContext<JobTrackerServerComponent> context) throws InvalidPluginConfigurationException, Exception {
        this.jobJar = new File(context.getResourceKey());
        this.context = context;
        this.operationsDelegate = new HadoopOperationsDelegate(((JobTrackerServerComponent)context.getParentResourceComponent()).getResourceContext());
    }

    public void stop() {
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if (SUBMIT_OP.equals(name)) {
            String args = parameters.getSimpleValue("args", "");
            args = this.context.getResourceKey() + " " + args;
            parameters.put((Property)new PropertySimple("args", (Object)args));
            return this.operationsDelegate.invoke(HadoopSupportedOperations.JAR, parameters, null);
        }
        return null;
    }

    public void deleteResource() throws Exception {
        this.jobJar.delete();
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> details, ContentServices services) {
        return null;
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        return null;
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails details) {
        return null;
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> details) {
        return null;
    }

    public InputStream retrievePackageBits(ResourcePackageDetails details) {
        return null;
    }
}

