/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.simulator;

import com.codahale.metrics.Timer;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.metrics.simulator.Metrics;
import org.rhq.metrics.simulator.ShutdownManager;
import org.rhq.server.metrics.MetricsServer;

public class MeasurementAggregator
implements Runnable {
    private final Log log = LogFactory.getLog(MeasurementAggregator.class);
    private MetricsServer metricsServer;
    private Metrics metrics;
    private ExecutorService aggregationQueue;
    private ShutdownManager shutdownManager;
    private int numSchedules;

    public MeasurementAggregator(MetricsServer metricsServer, ShutdownManager shutdownManager, Metrics metrics, ExecutorService aggregationQueue, int numSchedules) {
        this.metricsServer = metricsServer;
        this.shutdownManager = shutdownManager;
        this.metrics = metrics;
        this.aggregationQueue = aggregationQueue;
        this.numSchedules = numSchedules;
    }

    @Override
    public void run() {
        this.aggregationQueue.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Timer.Context context = ((MeasurementAggregator)MeasurementAggregator.this).metrics.totalAggregationTime.time();
                long start = System.currentTimeMillis();
                try {
                    MeasurementAggregator.this.log.info((Object)"Starting metrics aggregation");
                    MeasurementAggregator.this.metricsServer.calculateAggregates();
                }
                catch (Exception e) {
                    MeasurementAggregator.this.log.error((Object)"An error occurred while trying to perform aggregation", (Throwable)e);
                    MeasurementAggregator.this.log.error((Object)"Requesting simulation shutdown...");
                    MeasurementAggregator.this.shutdownManager.shutdown(1);
                }
                finally {
                    context.stop();
                    MeasurementAggregator.this.log.info((Object)("Finished metrics aggregation in " + (System.currentTimeMillis() - start) + " ms"));
                    ((MeasurementAggregator)MeasurementAggregator.this).metrics.totalAggregationRuns.inc();
                }
            }
        });
    }
}

