/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.simulator;

import com.codahale.metrics.Timer;
import com.google.common.base.Stopwatch;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.metrics.simulator.Metrics;
import org.rhq.server.metrics.DateTimeService;
import org.rhq.server.metrics.MetricsServer;
import org.rhq.server.metrics.RawDataInsertedCallback;

public class MeasurementCollector
implements Runnable {
    private final Log log = LogFactory.getLog(MeasurementCollector.class);
    private MetricsServer metricsServer;
    private int batchSize;
    private int startingScheduleId;
    private Metrics metrics;
    private DateTimeService dateTimeService;

    public MeasurementCollector(int batchSize, int startingScheduleId, Metrics metrics, MetricsServer metricsServer, DateTimeService dateTimeService) {
        this.batchSize = batchSize;
        this.startingScheduleId = startingScheduleId;
        this.metrics = metrics;
        this.metricsServer = metricsServer;
        this.dateTimeService = dateTimeService;
    }

    private Set<MeasurementDataNumeric> generateData() {
        HashSet<MeasurementDataNumeric> data = new HashSet<MeasurementDataNumeric>(this.batchSize);
        long timestamp = this.dateTimeService.nowInMillis();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < this.batchSize; ++i) {
            data.add(new MeasurementDataNumeric(timestamp, this.startingScheduleId + i, Double.valueOf(random.nextDouble())));
        }
        return data;
    }

    @Override
    public void run() {
        final Timer.Context context = this.metrics.batchInsertTime.time();
        final Stopwatch stopwatch = new Stopwatch().start();
        this.metricsServer.addNumericData(this.generateData(), new RawDataInsertedCallback(){

            public void onFinish() {
                stopwatch.stop();
                MeasurementCollector.this.log.info((Object)("Finished inserting raw data in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
                context.stop();
            }

            public void onSuccess(MeasurementDataNumeric result) {
                ((MeasurementCollector)MeasurementCollector.this).metrics.rawInserts.mark();
            }

            public void onFailure(Throwable t) {
                MeasurementCollector.this.log.warn((Object)"Failed to insert raw data", t);
            }
        });
    }
}

