/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.simulator;

import com.codahale.metrics.Timer;
import com.google.common.base.Stopwatch;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.Hours;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.metrics.simulator.Metrics;
import org.rhq.server.metrics.MetricsServer;

public class MeasurementReader
implements Runnable {
    private final Log log = LogFactory.getLog(MeasurementReader.class);
    private long intervalRate;
    private Metrics metrics;
    private MetricsServer metricsServer;
    private int startingSchedule;
    private int batchSize;

    public MeasurementReader(long intervalRate, Metrics metrics, MetricsServer metricsServer, int startingSchedule, int batchSize) {
        this.intervalRate = intervalRate;
        this.metrics = metrics;
        this.metricsServer = metricsServer;
        this.startingSchedule = startingSchedule;
        this.batchSize = batchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Timer.Context context = this.metrics.totalReadTime.time();
        Stopwatch stopwatch = new Stopwatch().start();
        try {
            this.log.info((Object)"Running metrics queries");
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int bound = this.startingSchedule + this.batchSize;
            this.findResourceDataForPast24Hours(random.nextInt(this.startingSchedule, bound));
            this.findResourceDataForPastWeek(random.nextInt(this.startingSchedule, bound));
            this.findResourceDataForPast2Weeks(random.nextInt(this.startingSchedule, bound));
            this.findResourceDataForPast31Days(random.nextInt(this.startingSchedule, bound));
            this.findResourceDataForPastYear(random.nextInt(this.startingSchedule, bound));
        }
        finally {
            stopwatch.stop();
            this.log.info((Object)("Finished running metrics queries in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
            context.stop();
        }
    }

    private void findResourceDataForPast24Hours(int scheduleId) {
        Duration duration = Hours.hours((int)24).toStandardSeconds().toStandardDuration();
        this.findResourceData(scheduleId, duration, this.metrics.twentyFourHourResourceQueryTime);
    }

    private void findResourceDataForPastWeek(int scheduleId) {
        Duration duration = Days.SEVEN.toStandardSeconds().minus(5).toStandardDuration();
        this.findResourceData(scheduleId, duration, this.metrics.oneWeekResourceQueryTime);
    }

    private void findResourceDataForPast2Weeks(int scheduleId) {
        Duration duration = Days.days((int)14).toStandardSeconds().minus(5).toStandardDuration();
        this.findResourceData(scheduleId, duration, this.metrics.twoWeekResourceQueryTime);
    }

    private void findResourceDataForPast31Days(int scheduleId) {
        Duration duration = Days.days((int)31).toStandardSeconds().minus(5).toStandardDuration();
        this.findResourceData(scheduleId, duration, this.metrics.monthResourceQueryTime);
    }

    private void findResourceDataForPastYear(int scheduleId) {
        Duration duration = Days.days((int)365).toStandardSeconds().minus(5).toStandardDuration();
        this.findResourceData(scheduleId, duration, this.metrics.yearResourceQueryTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findResourceData(int scheduleId, Duration duration, Timer timer) {
        long end = System.currentTimeMillis();
        long start = end - duration.getMillis() / this.intervalRate;
        Timer.Context context = timer.time();
        try {
            Iterable data = this.metricsServer.findDataForResource(scheduleId, start, end, 60);
            Iterator iterator = data.iterator();
            for (MeasurementDataNumericHighLowComposite datum : data) {
            }
        }
        finally {
            context.stop();
        }
    }
}

