/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.simulator;

import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.rhq.metrics.simulator.SimulatedDateTimeService;

public class MinutesDateTimeService
extends SimulatedDateTimeService {
    public DateTime getTimeSlice(DateTime dt, Duration duration) {
        if (duration.equals((Object)this.configuration.getRawTimeSliceDuration())) {
            int seconds = (dt.getMinuteOfHour() * 60 + dt.getSecondOfMinute()) / 150;
            return dt.hourOfDay().roundFloorCopy().plusSeconds(seconds * 150);
        }
        if (duration.equals((Object)this.configuration.getOneHourTimeSliceDuration())) {
            int minutes = dt.minuteOfHour().get() / 15;
            return dt.hourOfDay().roundFloorCopy().plusMinutes(minutes * 15);
        }
        if (duration.equals((Object)this.configuration.getSixHourTimeSliceDuration())) {
            return dt.hourOfDay().roundFloorCopy();
        }
        throw new IllegalArgumentException("The duration [" + duration + "] is not supported");
    }
}

