/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.simulator;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricRegistry;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.rhq.cassandra.schema.SchemaManager;
import org.rhq.cassandra.util.ClusterBuilder;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.metrics.simulator.MeasurementAggregator;
import org.rhq.metrics.simulator.MeasurementCollector;
import org.rhq.metrics.simulator.MeasurementReader;
import org.rhq.metrics.simulator.Metrics;
import org.rhq.metrics.simulator.ShutdownManager;
import org.rhq.metrics.simulator.SimulatedDateTimeService;
import org.rhq.metrics.simulator.SimulatedMetricsServer;
import org.rhq.metrics.simulator.SimulatorThreadFactory;
import org.rhq.metrics.simulator.WaitForRawInserts;
import org.rhq.metrics.simulator.plan.SimulationPlan;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.MetricsServer;
import org.rhq.server.metrics.RawDataInsertedCallback;
import org.rhq.server.metrics.StorageSession;

public class Simulator
implements ShutdownManager {
    private final Log log = LogFactory.getLog(Simulator.class);
    private boolean shutdown = false;
    private Metrics metrics;
    private Session session;
    private StorageSession storageSession;
    private MetricsDAO metricsDAO;
    private MetricsServer metricsServer;

    public void run(SimulationPlan plan) throws Throwable {
        if (SimulationPlan.SimulationType.THREADED.equals((Object)plan.getSimulationType())) {
            this.runThreadedSimulation(plan);
        } else if (SimulationPlan.SimulationType.SEQUENTIAL.equals((Object)plan.getSimulationType())) {
            this.runSequentialSimulation(plan);
        } else {
            throw new UnsupportedOperationException("Simulation type " + (Object)((Object)plan.getSimulationType()) + " not implemented.");
        }
    }

    private void initializeMetricsServer(SimulationPlan plan) {
        this.metrics = new Metrics();
        this.createSchema(plan.getNodes(), plan.getCqlPort());
        this.session = this.createSession(plan.getNodes(), plan.getCqlPort());
        this.storageSession = new StorageSession(this.session);
        this.metricsDAO = new MetricsDAO(this.storageSession, plan.getMetricsServerConfiguration());
        this.metricsServer = new SimulatedMetricsServer();
        this.metricsServer.setDAO(this.metricsDAO);
        this.metricsServer.setConfiguration(plan.getMetricsServerConfiguration());
        this.metricsServer.setAggregationBatchSize(plan.getAggregationBatchSize());
        this.metricsServer.setUseAsyncAggregation(plan.getAggregationType() == SimulationPlan.AggregationType.ASYNC);
        this.metricsServer.setDateTimeService(plan.getDateTimeService());
    }

    private void runSequentialSimulation(SimulationPlan plan) throws Throwable {
        long timestamp;
        this.initializeMetricsServer(plan);
        SimulatedMetricsServer simulatedMetricsServer = (SimulatedMetricsServer)this.metricsServer;
        SimulatedDateTimeService simulatedDateTimeService = (SimulatedDateTimeService)plan.getDateTimeService();
        Random random = new Random();
        long endOfSimulation = timestamp + 86400000L * (long)plan.getSimulationTime();
        long numberOfMetrics = plan.getBatchSize() * plan.getNumMeasurementCollectors();
        HashSet<MeasurementDataNumeric> data = new HashSet<MeasurementDataNumeric>(plan.getBatchSize());
        int lastAggregationHour = new DateTime(timestamp).getHourOfDay();
        for (timestamp = plan.getDateTimeService().nowInMillis(); timestamp < endOfSimulation; timestamp += 60000L) {
            DateTime currentTime = new DateTime(timestamp);
            simulatedMetricsServer.setCurrentHour(new DateTime(timestamp));
            data.clear();
            int i = 0;
            while ((long)i < numberOfMetrics) {
                data.add(new MeasurementDataNumeric(timestamp, i, Double.valueOf(random.nextDouble())));
                ++i;
            }
            WaitForRawInserts waitForRawInserts = new WaitForRawInserts(data.size());
            this.metricsServer.addNumericData(data, (RawDataInsertedCallback)waitForRawInserts);
            waitForRawInserts.await("Failed to insert raw data at time: " + timestamp);
            if (currentTime.getHourOfDay() == lastAggregationHour) continue;
            this.log.info((Object)("Current simulation time" + currentTime.toString()));
            lastAggregationHour = currentTime.getHourOfDay();
            simulatedMetricsServer.calculateAggregates();
        }
        this.metricsServer.shutdown();
        this.log.info((Object)"Simulation has completed. Initiating shutdown...");
        this.shutdown(0);
    }

    private void runThreadedSimulation(SimulationPlan plan) {
        int i;
        this.initializeMetricsServer(plan);
        final ConsoleReporter consoleReporter = this.createConsoleReporter(this.metrics, plan.getMetricsReportInterval());
        final ScheduledExecutorService aggregators = Executors.newScheduledThreadPool(1, new SimulatorThreadFactory());
        final ScheduledExecutorService collectors = Executors.newScheduledThreadPool(plan.getNumMeasurementCollectors(), new SimulatorThreadFactory());
        final ExecutorService aggregationQueue = Executors.newSingleThreadExecutor(new SimulatorThreadFactory());
        final ScheduledExecutorService readers = Executors.newScheduledThreadPool(plan.getReaderThreadPoolSize(), new SimulatorThreadFactory());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Simulator.this.shutdown(collectors, "collectors", 5);
                Simulator.this.shutdown(readers, "readers", 5);
                Simulator.this.shutdown(aggregators, "aggregators", 1);
                Simulator.this.shutdown(aggregationQueue, "aggregationQueue", Integer.MAX_VALUE);
                Simulator.this.metricsServer.shutdown();
                Simulator.this.log.info((Object)"Wait for console reporter...");
                try {
                    Thread.sleep(181000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                consoleReporter.stop();
            }
        });
        MeasurementAggregator measurementAggregator = new MeasurementAggregator(this.metricsServer, this, this.metrics, aggregationQueue, plan.getNumMeasurementCollectors() * plan.getBatchSize());
        for (i = 0; i < plan.getNumMeasurementCollectors(); ++i) {
            collectors.scheduleAtFixedRate(new MeasurementCollector(plan.getBatchSize(), plan.getBatchSize() * i, this.metrics, this.metricsServer, plan.getDateTimeService()), 0L, plan.getCollectionInterval(), TimeUnit.MILLISECONDS);
        }
        if (plan.isAggregationEnabled()) {
            aggregators.scheduleAtFixedRate(measurementAggregator, 0L, plan.getAggregationInterval(), TimeUnit.MILLISECONDS);
        }
        for (i = 0; i < plan.getNumReaders(); ++i) {
            MeasurementReader reader = new MeasurementReader(plan.getSimulationRate(), this.metrics, this.metricsServer, plan.getBatchSize() * i, plan.getBatchSize());
            readers.scheduleAtFixedRate(reader, 30L, 30L, TimeUnit.SECONDS);
        }
        try {
            Thread.sleep(Minutes.minutes((int)plan.getSimulationTime()).toStandardDuration().getMillis());
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.log.info((Object)"Simulation has completed. Initiating shutdown...");
        this.shutdown(0);
    }

    private ConsoleReporter createConsoleReporter(Metrics metrics, int reportInterval) {
        try {
            File basedir = new File(System.getProperty("rhq.metrics.simulator.basedir"));
            File logDir = new File(basedir, "log");
            ConsoleReporter consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)metrics.registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).outputTo(new PrintStream(new FileOutputStream(new File(logDir, "metrics.txt")))).build();
            consoleReporter.start((long)reportInterval, TimeUnit.SECONDS);
            return consoleReporter;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Failed to create console reporter", e);
        }
    }

    @Override
    public synchronized void shutdown(int status) {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.log.info((Object)"Preparing to shutdown simulator...");
        System.exit(status);
    }

    private void shutdown(ExecutorService service, String serviceName, int wait) {
        this.log.info((Object)("Shutting down " + serviceName));
        service.shutdown();
        try {
            service.awaitTermination(wait, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!service.isTerminated()) {
            this.log.info((Object)("Forcing " + serviceName + " shutdown."));
            service.shutdownNow();
        }
        this.log.info((Object)(serviceName + " shut down complete"));
    }

    private void createSchema(String[] nodes, int cqlPort) {
        SchemaManager schemaManager = new SchemaManager("rhqadmin", "1eeb2f255e832171df8592078de921bc", nodes, cqlPort);
        try {
            this.log.info((Object)"Creating schema");
            schemaManager.install();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start simulator. An error occurred during schema creation.", e);
        }
        finally {
            schemaManager.shutdown();
        }
    }

    private Session createSession(String[] nodes, int cqlPort) throws NoHostAvailableException {
        try {
            Cluster cluster = new ClusterBuilder().addContactPoints(nodes).withPort(cqlPort).withCredentials("rhqadmin", "rhqadmin").build();
            PoolingOptions poolingOptions = cluster.getConfiguration().getPoolingOptions();
            poolingOptions.setCoreConnectionsPerHost(HostDistance.LOCAL, 24);
            poolingOptions.setCoreConnectionsPerHost(HostDistance.REMOTE, 24);
            poolingOptions.setMaxConnectionsPerHost(HostDistance.LOCAL, 32);
            poolingOptions.setMaxConnectionsPerHost(HostDistance.REMOTE, 32);
            this.log.debug((Object)("Created cluster object with " + cluster.getConfiguration().getProtocolOptions().getCompression() + " compression."));
            return this.initSession(cluster);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to start simulator. Unable to create " + Session.class), (Throwable)e);
            throw new RuntimeException("Failed to start simulator. Unable to create " + Session.class, e);
        }
    }

    private Session initSession(Cluster cluster) {
        return cluster.connect("rhq");
    }

    private static class NodeFailureListener
    implements Host.StateListener {
        private Log log = LogFactory.getLog(NodeFailureListener.class);

        private NodeFailureListener() {
        }

        public void onAdd(Host host) {
        }

        public void onUp(Host host) {
        }

        public void onDown(Host host) {
            this.log.warn((Object)("Node " + host + " has gone down."));
            this.log.warn((Object)"Preparing to shutdown simulator...");
            System.exit(1);
        }

        public void onRemove(Host host) {
        }
    }
}

