/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.simulator;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.metrics.simulator.Simulator;
import org.rhq.metrics.simulator.plan.SimulationPlan;
import org.rhq.metrics.simulator.plan.SimulationPlanner;

public class SimulatorCLI {
    private final Log log = LogFactory.getLog(SimulatorCLI.class);
    private Options options = new Options();

    public SimulatorCLI() {
        Option help = new Option("h", "help", false, "Display this message.");
        this.options.addOption(help);
        Option simulation = new Option("s", "simulation", true, "The simulation to run. Expected to be a JSON file.");
        this.options.addOption(simulation);
    }

    public void exec(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            System.exit(1);
        }
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmdLine = parser.parse(this.options, args);
            if (cmdLine.hasOption("h")) {
                this.printUsage();
            } else if (cmdLine.hasOption("s")) {
                this.runSimulator(cmdLine.getOptionValue("s"));
            } else {
                this.printUsage();
            }
        }
        catch (ParseException e) {
            this.printUsage();
        }
    }

    public void printUsage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        String syntax = "rhq-ms [options]";
        String header = "";
        helpFormatter.setOptPrefix("");
        helpFormatter.printHelp(syntax, header, this.options, null);
    }

    public void runSimulator(String file) {
        File planFile = new File(file);
        if (!planFile.exists()) {
            throw new RuntimeException("Simulation file [" + file + "] does not exist.");
        }
        if (planFile.isDirectory()) {
            throw new RuntimeException("[" + file + "] is a directory. The --simulation argument must refer to a  " + "file.");
        }
        SimulationPlanner planner = new SimulationPlanner();
        SimulationPlan plan = null;
        try {
            plan = planner.create(planFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create simulation: " + e.getMessage(), e);
        }
        Simulator simulator = new Simulator();
        try {
            simulator.run(plan);
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    public static void main(String[] args) {
        SimulatorCLI cli = new SimulatorCLI();
        try {
            cli.exec(args);
        }
        catch (Exception e) {
            cli.log.error((Object)"There was an unxpected error", (Throwable)e);
            System.exit(1);
        }
    }
}

