/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.simulator;

import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.server.metrics.RawDataInsertedCallback;

class WaitForRawInserts
implements RawDataInsertedCallback {
    private final Log log = LogFactory.getLog(WaitForRawInserts.class);
    private CountDownLatch latch;
    private Throwable throwable;

    public WaitForRawInserts(int numInserts) {
        this.latch = new CountDownLatch(numInserts);
    }

    public void onFinish() {
    }

    public void onSuccess(MeasurementDataNumeric measurementDataNumeric) {
        this.latch.countDown();
    }

    public void onFailure(Throwable throwable) {
        this.latch.countDown();
        this.throwable = throwable;
        this.log.error((Object)"An async operation failed", throwable);
    }

    public void await(String errorMsg) throws Throwable {
        this.latch.await();
        if (this.throwable != null) {
            throw this.throwable;
        }
    }
}

