/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.simulator.plan;

import org.rhq.server.metrics.DateTimeService;
import org.rhq.server.metrics.MetricsConfiguration;

public class SimulationPlan {
    private long collectionInterval;
    private long aggregationInterval;
    private MetricsConfiguration metricsServerConfiguration;
    private int numMeasurementCollectors;
    private int simulationTime;
    private String[] nodes;
    private int cqlPort;
    private int batchSize;
    private int metricsReportInterval;
    private IntervalType intervalType;
    private DateTimeService dateTimeService;
    private int numReaders;
    private long readInterval;
    private long simulationRate;
    private int aggregationBatchSize;
    private boolean aggregationEnabled = true;
    private AggregationType aggregationType;
    private SimulationType simulationType;
    private int readerThreadPoolSize = 1;

    public int getReaderThreadPoolSize() {
        return this.readerThreadPoolSize;
    }

    public void setReaderThreadPoolSize(int readerThreadPoolSize) {
        this.readerThreadPoolSize = readerThreadPoolSize;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public long getCollectionInterval() {
        return this.collectionInterval;
    }

    public void setCollectionInterval(long collectionInterval) {
        this.collectionInterval = collectionInterval;
    }

    public MetricsConfiguration getMetricsServerConfiguration() {
        return this.metricsServerConfiguration;
    }

    public void setMetricsServerConfiguration(MetricsConfiguration metricsServerConfiguration) {
        this.metricsServerConfiguration = metricsServerConfiguration;
    }

    public long getAggregationInterval() {
        return this.aggregationInterval;
    }

    public void setAggregationInterval(long aggregationInterval) {
        this.aggregationInterval = aggregationInterval;
    }

    public int getNumMeasurementCollectors() {
        return this.numMeasurementCollectors;
    }

    public void setNumMeasurementCollectors(int numMeasurementCollectors) {
        this.numMeasurementCollectors = numMeasurementCollectors;
    }

    public int getSimulationTime() {
        return this.simulationTime;
    }

    public void setSimulationTime(int simulationTime) {
        this.simulationTime = simulationTime;
    }

    public String[] getNodes() {
        return this.nodes;
    }

    public void setNodes(String[] nodes) {
        this.nodes = nodes;
    }

    public int getCqlPort() {
        return this.cqlPort;
    }

    public void setCqlPort(int cqlPort) {
        this.cqlPort = cqlPort;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getMetricsReportInterval() {
        return this.metricsReportInterval;
    }

    public void setMetricsReportInterval(int metricsReportInterval) {
        this.metricsReportInterval = metricsReportInterval;
    }

    public IntervalType getIntervalType() {
        return this.intervalType;
    }

    public void setIntervalType(IntervalType intervalType) {
        this.intervalType = intervalType;
    }

    public int getNumReaders() {
        return this.numReaders;
    }

    public void setNumReaders(int numReaders) {
        this.numReaders = numReaders;
    }

    public long getReadInterval() {
        return this.readInterval;
    }

    public void setReadInterval(long readInterval) {
        this.readInterval = readInterval;
    }

    public long getSimulationRate() {
        return this.simulationRate;
    }

    public void setSimulationRate(long simulationRate) {
        this.simulationRate = simulationRate;
    }

    public int getAggregationBatchSize() {
        return this.aggregationBatchSize;
    }

    public void setAggregationBatchSize(int aggregationBatchSize) {
        this.aggregationBatchSize = aggregationBatchSize;
    }

    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public SimulationType getSimulationType() {
        return this.simulationType;
    }

    public void setSimulationType(SimulationType simulationType) {
        this.simulationType = simulationType;
    }

    public boolean isAggregationEnabled() {
        return this.aggregationEnabled;
    }

    public void setAggregationEnabled(boolean aggregationEnabled) {
        this.aggregationEnabled = aggregationEnabled;
    }

    public static enum SimulationType {
        THREADED("threaded"),
        SEQUENTIAL("sequential");

        private final String text;

        private SimulationType(String text) {
            this.text = text;
        }

        public static SimulationType fromText(String text) {
            if (text.equals("threaded") || text.equals("thread")) {
                return THREADED;
            }
            if (text.equals("sequential") || text.equals("seq")) {
                return SEQUENTIAL;
            }
            throw new IllegalArgumentException(text + " is not a valid simulation type");
        }
    }

    public static enum AggregationType {
        SYNC("sync"),
        ASYNC("async");

        private final String text;

        private AggregationType(String text) {
            this.text = text;
        }

        public static AggregationType fromText(String text) {
            if (text.equals("sync")) {
                return SYNC;
            }
            if (text.equals("async")) {
                return ASYNC;
            }
            throw new IllegalArgumentException(text + " is not a valid aggregation type");
        }
    }

    public static enum IntervalType {
        SECONDS("seconds"),
        MINUTES("minutes"),
        HOURS("hours");

        private final String text;

        private IntervalType(String text) {
            this.text = text;
        }

        public static IntervalType fromText(String text) {
            if (text.equals("seconds")) {
                return SECONDS;
            }
            if (text.equals("minutes")) {
                return MINUTES;
            }
            if (text.equals("hours")) {
                return HOURS;
            }
            throw new IllegalArgumentException(text + " is not a valid interval type");
        }
    }
}

