/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.simulator.plan;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.net.InetAddress;
import org.joda.time.Minutes;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.rhq.metrics.simulator.MinutesDateTimeService;
import org.rhq.metrics.simulator.SecondsDateTimeService;
import org.rhq.metrics.simulator.SimulatedDateTimeService;
import org.rhq.metrics.simulator.plan.SimulationPlan;
import org.rhq.server.metrics.DateTimeService;
import org.rhq.server.metrics.MetricsConfiguration;

public class SimulationPlanner {
    public SimulationPlan create(File jsonFile) throws Exception {
        String[] nodes;
        DateTimeService dateTimeService;
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.enable(JsonParser.Feature.ALLOW_COMMENTS);
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        JsonNode root = mapper.readTree(jsonFile);
        SimulationPlan simulation = new SimulationPlan();
        simulation.setIntervalType(SimulationPlan.IntervalType.fromText(this.getString(root.get("intervalType"), "minutes")));
        switch (simulation.getIntervalType()) {
            case SECONDS: {
                simulation.setCollectionInterval(this.getLong(root.get("collectionInterval"), 20L));
                simulation.setAggregationInterval(this.getLong(root.get("aggregationInterval"), 2500L));
                simulation.setMetricsServerConfiguration(this.createSecondsConfiguration());
                simulation.setMetricsReportInterval(this.getInt(root.get("metricsReportInterval"), 30));
                simulation.setSimulationRate(1440L);
                dateTimeService = new SecondsDateTimeService();
                break;
            }
            case MINUTES: {
                simulation.setCollectionInterval(this.getLong(root.get("collectionInterval"), 1250L));
                simulation.setAggregationInterval(this.getLong(root.get("aggregationInterval"), 150000L));
                simulation.setMetricsServerConfiguration(this.createMinutesConfiguration());
                simulation.setMetricsReportInterval(this.getInt(root.get("metricsReportInterval"), 180));
                simulation.setDateTimeService(new MinutesDateTimeService());
                simulation.setSimulationRate(2400L);
                dateTimeService = new MinutesDateTimeService();
                break;
            }
            default: {
                simulation.setCollectionInterval(this.getLong(root.get("collectionInterval"), 30000L));
                simulation.setAggregationInterval(3600000L);
                simulation.setMetricsServerConfiguration(new MetricsConfiguration());
                simulation.setMetricsReportInterval(this.getInt(root.get("metricsReportInterval"), 1200));
                simulation.setSimulationRate(1000L);
                dateTimeService = new DateTimeService();
            }
        }
        simulation.setSimulationType(SimulationPlan.SimulationType.fromText(this.getString(root.get("simulationType"), "threaded")));
        if (SimulationPlan.SimulationType.SEQUENTIAL.equals((Object)simulation.getSimulationType())) {
            dateTimeService = new SimulatedDateTimeService();
        }
        dateTimeService.setConfiguration(simulation.getMetricsServerConfiguration());
        simulation.setDateTimeService(dateTimeService);
        simulation.setNumMeasurementCollectors(this.getInt(root.get("numMeasurementCollectors"), 5));
        simulation.setNumReaders(this.getInt(root.get("numReaders"), 1));
        simulation.setReaderThreadPoolSize(this.getInt(root.get("readerThreadPoolSize"), 1));
        simulation.setSimulationTime(this.getInt(root.get("simulationTime"), 10));
        simulation.setBatchSize(this.getInt(root.get("batchSize"), 5000));
        if (root.get("nodes") == null || root.get("nodes").size() == 0) {
            nodes = new String[]{InetAddress.getLocalHost().getHostAddress()};
        } else {
            nodes = new String[root.get("nodes").size()];
            int i = 0;
            for (JsonNode node : root.get("nodes")) {
                nodes[i++] = node.asText();
            }
        }
        simulation.setNodes(nodes);
        simulation.setCqlPort(this.getInt(root.get("cqlPort"), 9142));
        simulation.setAggregationBatchSize(this.getInt(root.get("aggregationBatchSize"), 250));
        simulation.setAggregationType(SimulationPlan.AggregationType.fromText(this.getString(root.get("aggregationType"), "sync")));
        simulation.setAggregationEnabled(this.getBoolean(root.get("aggregationEnabled"), true));
        return simulation;
    }

    private MetricsConfiguration createMinutesConfiguration() {
        MetricsConfiguration configuration = new MetricsConfiguration();
        configuration.setRawTTL(Minutes.minutes((int)168).toStandardSeconds().getSeconds());
        configuration.setRawRetention(Minutes.minutes((int)168).toStandardDuration());
        configuration.setRawTimeSliceDuration(Seconds.seconds((int)150).toStandardDuration());
        configuration.setOneHourTTL(Minutes.minutes((int)336).toStandardSeconds().getSeconds());
        configuration.setOneHourRetention((ReadablePeriod)Minutes.minutes((int)336));
        configuration.setOneHourTimeSliceDuration(Minutes.minutes((int)15).toStandardDuration());
        configuration.setSixHourTTL(Minutes.minutes((int)744).toStandardSeconds().getSeconds());
        configuration.setSixHourRetention((ReadablePeriod)Minutes.minutes((int)744).toStandardSeconds());
        configuration.setSixHourTimeSliceDuration(Minutes.minutes((int)60).toStandardDuration());
        configuration.setTwentyFourHourTTL(Minutes.minutes((int)8928).toStandardSeconds().getSeconds());
        configuration.setTwentyFourHourRetention((ReadablePeriod)Minutes.minutes((int)8928).toStandardSeconds());
        return configuration;
    }

    private MetricsConfiguration createSecondsConfiguration() {
        MetricsConfiguration configuration = new MetricsConfiguration();
        configuration.setRawTTL(420);
        configuration.setRawRetention(Seconds.seconds((int)420).toStandardDuration());
        configuration.setRawTimeSliceDuration(Seconds.seconds((int)2).toStandardDuration().plus(500L));
        configuration.setOneHourTTL(Seconds.seconds((int)840).getSeconds());
        configuration.setOneHourRetention((ReadablePeriod)Seconds.seconds((int)840));
        configuration.setOneHourTimeSliceDuration(Seconds.seconds((int)15).toStandardDuration());
        configuration.setSixHourTTL(Seconds.seconds((int)1860).getSeconds());
        configuration.setSixHourRetention((ReadablePeriod)Seconds.seconds((int)1860));
        configuration.setSixHourTimeSliceDuration(Seconds.seconds((int)60).toStandardDuration());
        configuration.setTwentyFourHourTTL(Minutes.minutes((int)365).toStandardSeconds().getSeconds());
        configuration.setTwentyFourHourRetention((ReadablePeriod)Minutes.minutes((int)365));
        return configuration;
    }

    private String getString(JsonNode node, String defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return node.asText();
    }

    private long getLong(JsonNode node, long defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return node.longValue();
    }

    private int getInt(JsonNode node, int defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return node.intValue();
    }

    private boolean getBoolean(JsonNode node, boolean defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return node.booleanValue();
    }
}

