/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.embedded;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.apache.cassandra.service.CassandraDaemon;
import org.rhq.metrics.embedded.ConfigEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Startup
@Singleton
public class EmbeddedCassandraService {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedCassandraService.class);
    private static final String EMBEDDED_CASSANDRA_OPTION = "embedded_cass";
    private CassandraDaemon cassandraDaemon;

    public EmbeddedCassandraService() {
        logger.info("======== RHQ Metrics - Embedded Cassandra ========");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void start() {
        EmbeddedCassandraService embeddedCassandraService = this;
        synchronized (embeddedCassandraService) {
            String backend = System.getProperty("rhq-metrics.backend");
            if (this.cassandraDaemon == null && EMBEDDED_CASSANDRA_OPTION.equals(backend)) {
                try {
                    ConfigEditor editor = new ConfigEditor();
                    editor.initEmbeddedConfiguration();
                    this.cassandraDaemon = new CassandraDaemon();
                    this.cassandraDaemon.activate();
                }
                catch (Exception e) {
                    logger.error("Error initializing embbeded Cassandra server", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    void stop() {
        EmbeddedCassandraService embeddedCassandraService = this;
        synchronized (embeddedCassandraService) {
            if (this.cassandraDaemon != null) {
                this.cassandraDaemon.deactivate();
            }
        }
    }
}

