var Controllers;
(function (Controllers) {
    'use strict';
    var ConfigController = (function () {
        function ConfigController($scope, $modal, $log) {
            this.$scope = $scope;
            this.$modal = $modal;
            this.$log = $log;
            $scope.vm = this;
        }
        ConfigController.prototype.openConfig = function (size) {
            var configModalInstance = this.$modal.open({
                templateUrl: 'configModal.inline',
                controller: ConfigInstanceController,
                size: size
            });
            configModalInstance.result.then(function () {
            }, function () {
            });
        };
        ConfigController.$inject = ['$scope', '$modal', '$log'];
        return ConfigController;
    })();
    Controllers.ConfigController = ConfigController;
    var ConfigInstanceController = (function () {
        function ConfigInstanceController($scope, $modalInstance, $rootScope, $localStorage) {
            this.$scope = $scope;
            this.$modalInstance = $modalInstance;
            this.$rootScope = $rootScope;
            this.$localStorage = $localStorage;
            $scope.vm = this;
        }
        ConfigInstanceController.prototype.ok = function () {
            this.$localStorage.server = this.$rootScope.$storage.server;
            this.$localStorage.port = this.$rootScope.$storage.port;
            this.$modalInstance.close('ok');
        };
        ConfigInstanceController.prototype.cancel = function () {
            this.$modalInstance.dismiss('cancel');
        };
        ConfigInstanceController.$inject = ['$scope', '$modalInstance', '$rootScope', '$localStorage'];
        return ConfigInstanceController;
    })();
    Controllers.ConfigInstanceController = ConfigInstanceController;
    angular.module('chartingApp').controller('ConfigController', ConfigController);
    angular.module('chartingApp').controller('ConfigInstanceController', ConfigInstanceController);
})(Controllers || (Controllers = {}));
//# sourceMappingURL=config-controller.js.map