var Controllers;
(function (Controllers) {
    'use strict';
    var InsertMetricsController = (function () {
        function InsertMetricsController($scope, $rootScope, $log, $interval, metricDataService, TENANT_ID) {
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.$log = $log;
            this.$interval = $interval;
            this.metricDataService = metricDataService;
            this.TENANT_ID = TENANT_ID;
            this.showOpenGroup = true;
            this.streamingTimeRanges = [
                { 'range': '1s', 'rangeInSeconds': 1 },
                { 'range': '5s', 'rangeInSeconds': 5 },
                { 'range': '30s', 'rangeInSeconds': 30 },
                { 'range': '1m', 'rangeInSeconds': 60 },
                { 'range': '5m', 'rangeInSeconds': 5 * 60 },
                { 'range': '10m', 'rangeInSeconds': 10 * 60 },
                { 'range': '15m', 'rangeInSeconds': 15 * 60 },
                { 'range': '30m', 'rangeInSeconds': 30 * 60 },
                { 'range': '1h', 'rangeInSeconds': 60 * 60 }
            ];
            this.timeInterval = [1, 5, 10, 15, 30, 60];
            this.quickInsertData = {
                timeStamp: _.now(),
                id: '',
                jsonPayload: {},
                value: ''
            };
            this.multiInsertData = {
                id: '',
                jsonPayload: {}
            };
            this.rangeDurations = [1, 2, 5, 7];
            this.rangeInsertData = {
                timeStamp: _.now(),
                id: '',
                selectedTimeInterval: 5,
                jsonPayload: {},
                startNumber: 1,
                endNumber: 100,
                selectedIntervalInMinutes: this.timeInterval[2],
                selectedDuration: this.rangeDurations[1]
            };
            this.streamingInsertData = {
                timeStamp: _.now(),
                id: '',
                jsonPayload: {},
                count: 1,
                startNumber: 1,
                endNumber: 100,
                isStreamingStarted: false,
                lastStreamedValue: 2,
                selectedRefreshInterval: this.streamingTimeRanges[1].range
            };
            $scope.vm = this;
        }
        InsertMetricsController.prototype.quickInsert = function (numberOfHoursPast) {
            var _this = this;
            var computedTimestamp;
            if (angular.isUndefined(numberOfHoursPast)) {
                computedTimestamp = moment().unix();
            }
            else {
                computedTimestamp = moment().subtract('hours', numberOfHoursPast).unix();
            }
            this.$log.debug('Generated Timestamp is: ' + computedTimestamp);
            this.quickInsertData.jsonPayload = [{ name: this.quickInsertData.id, tenantId: this.TENANT_ID, data: [{ timestamp: computedTimestamp, value: this.quickInsertData.value }] }];
            this.metricDataService.insertMultiplePayload(this.quickInsertData.jsonPayload).then(function (success) {
                toastr.success('Inserted value: ' + _this.quickInsertData.value + ' for ID: ' + _this.quickInsertData.id, 'Success');
                _this.quickInsertData.value = '';
            }, function (error) {
                toastr.error('An issue with inserting data has occurred. Please see the console logs. Status: ' + error);
            });
        };
        InsertMetricsController.prototype.multiInsert = function () {
            var _this = this;
            this.metricDataService.insertMultiplePayload(this.multiInsertData.jsonPayload).then(function (success) {
                toastr.success('Inserted Multiple values Successfully.', 'Success');
                _this.multiInsertData.jsonPayload = "";
            }, function (error) {
                InsertMetricsController.insertError(error);
            });
        };
        InsertMetricsController.prototype.rangeInsert = function () {
            var _this = this;
            var jsonPayload = [];
            jsonPayload.push(this.calculateRangeDataForMetric(this.rangeInsertData.id, this.TENANT_ID, this.rangeInsertData.selectedDuration, this.rangeInsertData.selectedIntervalInMinutes, this.rangeInsertData.startNumber, this.rangeInsertData.endNumber));
            console.dir(jsonPayload);
            this.metricDataService.insertMultiplePayload(jsonPayload).then(function (success) {
                toastr.success('Advanced Range Inserted Multiple values Successfully for id: ' + _this.rangeInsertData.id, 'Success');
                _this.rangeInsertData.id = "";
            }, function (error) {
                InsertMetricsController.insertError(error);
            });
        };
        InsertMetricsController.prototype.calculateRangeDataForMetric = function (metricId, tenantId, numberOfDays, intervalInMinutes, randomStart, randomEnd) {
            var intervalTimestamps = [], startDate = moment().subtract('days', numberOfDays).valueOf(), endDate = _.now(), step = intervalInMinutes * 60 * 1000, startSeed = _.random(randomStart, randomEnd), dbData = [];
            intervalTimestamps = _.range(startDate, endDate, step);
            dbData = _.map(intervalTimestamps, function (ts) {
                return { timestamp: ts, value: startSeed + _.random(-5, 5) };
            });
            return { tenantId: tenantId, name: metricId, data: dbData };
        };
        InsertMetricsController.prototype.startStreaming = function () {
            var _this = this;
            var selectedTimeRangeInSeconds = 5;
            angular.forEach(this.streamingTimeRanges, function (value) {
                if (value.range === _this.streamingInsertData.selectedRefreshInterval) {
                    selectedTimeRangeInSeconds = value.rangeInSeconds;
                }
            });
            this.streamingInsertData.isStreamingStarted = true;
            this.streamingInsertData.count = 0;
            this.streamingInsertData.lastStreamedValue = 0;
            this.streamingIntervalPromise = this.$interval(function () {
                _this.$log.log("Timer has Run! for seconds: " + selectedTimeRangeInSeconds);
                _this.streamingInsertData.count = _this.streamingInsertData.count + 1;
                _this.streamingInsertData.lastStreamedValue = _.random(_this.streamingInsertData.startNumber, _this.streamingInsertData.endNumber);
                _this.streamingInsertData.jsonPayload = [
                    {
                        tenantId: _this.TENANT_ID,
                        name: _this.streamingInsertData.id,
                        timestamp: _.now(),
                        value: _this.streamingInsertData.lastStreamedValue,
                        data: [{ timestamp: _.now(), value: _this.streamingInsertData.lastStreamedValue }]
                    }
                ];
                _this.metricDataService.insertMultiplePayload(_this.streamingInsertData.jsonPayload).then(function (success) {
                    toastr.success('Successfully inserted: ' + _this.streamingInsertData.lastStreamedValue, 'Streaming Insert');
                }, function (error) {
                    InsertMetricsController.insertError(error);
                });
            }, selectedTimeRangeInSeconds * 1000);
            this.$scope.$on('$destroy', function () {
                _this.$log.debug('Destroying intervalPromise');
                _this.$interval.cancel(_this.streamingIntervalPromise);
            });
        };
        InsertMetricsController.prototype.stopStreaming = function () {
            toastr.info('Stop Streaming Data.');
            this.$log.info('Stop Streaming Data.');
            this.streamingInsertData.isStreamingStarted = false;
            this.$interval.cancel(this.streamingIntervalPromise);
        };
        InsertMetricsController.insertError = function (error) {
            toastr.error('An issue with inserting data has occurred. Please see the console logs. Status: ' + error);
        };
        InsertMetricsController.$inject = ['$scope', '$rootScope', '$log', '$interval', 'metricDataService', 'TENANT_ID'];
        return InsertMetricsController;
    })();
    Controllers.InsertMetricsController = InsertMetricsController;
    angular.module('chartingApp').controller('InsertMetricsController', InsertMetricsController);
})(Controllers || (Controllers = {}));
//# sourceMappingURL=insert-metrics-controller.js.map