angular.module("rhq-metrics-charts",["rhq-metrics-charts.chart","rhq-metrics-charts.enter-key","rhq-metrics-charts.date-time-range"]);var Directives;!function(){"use strict";angular.module("rhqm.directives",[]).directive("rhqmChart",["$log",function($log){function link(scope,element,attributes){function xStartPosition(d){return timeScale(d.timestamp)+calcBarWidth()/2}function getChartWidth(){return 760}function useSmallCharts(){return getChartWidth()<=smallChartThresholdInPixels}function oneTimeChartSetup(){angular.isDefined(chart)&&chartParent.selectAll("*").remove(),chartParent=d3.select(element[0]),chart=chartParent.append("svg"),createSvgDefs(chart),tip=d3.tip().attr("class","d3-tip").offset([-10,0]).html(function(d,i){return buildHover(d,i)}),svg=chart.append("g").attr("width",width+margin.left+margin.right).attr("height",innerChartHeight).attr("transform","translate("+margin.left+","+adjustedChartHeight2+")"),svg.call(tip)}function setupFilteredData(dataPoints){function determineMultiMetricMinMax(){var currentMax,currentMin,seriesMax,seriesMin,maxList=[],minList=[];return angular.forEach(multiChartOverlayData,function(series){console.warn("Series: "+series.length),currentMax=d3.max(series.map(function(d){return d.empty?0:d.avg})),maxList.push(currentMax),currentMin=d3.min(series.map(function(d){return d.empty?Number.MAX_VALUE:d.avg})),minList.push(currentMin)}),seriesMax=d3.max(maxList),seriesMin=d3.min(minList),console.debug("Series max: "+seriesMax),console.debug("Series min: "+seriesMin),[seriesMin,seriesMax]}if(avg=d3.mean(dataPoints.map(function(d){return d.empty?0:d.avg})),angular.isDefined(multiChartOverlayData)){var minMax=determineMultiMetricMinMax();peak=minMax[1],min=minMax[0]}peak=d3.max(dataPoints.map(function(d){return d.empty?0:d.max})),min=d3.min(dataPoints.map(function(d){return d.empty?void 0:d.min})),lowBound=min-.1*min,highBound=peak+.1*(peak-min)}function determineScale(dataPoints){var xTicks,xTickSubDivide,numberOfBarsForSmallGraph=20;dataPoints.length>0&&(useSmallCharts()?(width=250,xTicks=3,xTickSubDivide=2,chartData=dataPoints.slice(dataPoints.length-numberOfBarsForSmallGraph,dataPoints.length)):(xTicks=8,xTickSubDivide=5,chartData=dataPoints),setupFilteredData(dataPoints),calcBarWidth=function(){return width/chartData.length-barOffset},yScale=d3.scale.linear().clamp(!0).rangeRound([height,0]).domain([lowBound,highBound]),yAxis=d3.svg.axis().scale(yScale).tickSubdivide(1).ticks(5).tickSize(4,4,0).orient("left"),timeScale=d3.time.scale().range([0,width]).domain(d3.extent(chartData,function(d){return d.timestamp})),isDefinedAndHasValues(contextData)?timeScaleForContext=d3.time.scale().range([0,width]).domain(d3.extent(contextData,function(d){return d.timestamp})):timeScaleForBrush=d3.time.scale().range([0,width]).domain(d3.extent(chartData,function(d){return d.timestamp})),xAxis=d3.svg.axis().scale(timeScale).ticks(xTicks).tickSubdivide(xTickSubDivide).tickSize(4,4,0).orient("bottom"))}function isEmptyDataBar(d){return d.empty}function isRawMetric(d){return d.value}function buildHover(d,i){var hover,prevTimestamp,barDuration,currentTimestamp=d.timestamp,formattedDateTime=moment(d.timestamp).format(buttonBarDateTimeFormat);return i>0&&(prevTimestamp=chartData[i-1].timestamp,barDuration=moment(currentTimestamp).from(moment(prevTimestamp),!0)),hover=isEmptyDataBar(d)?"<div class='chartHover'><small class='chartHoverLabel'>"+noDataLabel+"</small><div><small><span class='chartHoverLabel'>"+durationLabel+"</span><span>: </span><span class='chartHoverValue'>"+barDuration+"</span></small> </div><hr/><div><small><span class='chartHoverLabel'>"+timestampLabel+"</span><span>: </span><span class='chartHoverValue'>"+formattedDateTime+"</span></small></div></div>":isRawMetric(d)?"<div class='chartHover'><div><small><span class='chartHoverLabel'>"+timestampLabel+"</span><span>: </span><span class='chartHoverValue'>"+formattedDateTime+"</span></small></div><div><small><span class='chartHoverLabel'>"+durationLabel+"</span><span>: </span><span class='chartHoverValue'>"+barDuration+"</span></small> </div><hr/><div><small><span class='chartHoverLabel'>"+singleValueLabel+"</span><span>: </span><span class='chartHoverValue'>"+d.value+"</span></small> </div></div> ":"<div class='chartHover'><div><small><span class='chartHoverLabel'>"+timestampLabel+"</span><span>: </span><span class='chartHoverValue'>"+formattedDateTime+"</span></small></div><div><small><span class='chartHoverLabel'>"+durationLabel+"</span><span>: </span><span class='chartHoverValue'>"+barDuration+"</span></small> </div><hr/><div><small><span class='chartHoverLabel'>"+maxLabel+"</span><span>: </span><span class='chartHoverValue'>"+d.max+"</span></small> </div> <div><small><span class='chartHoverLabel'>"+avgLabel+"</span><span>: </span><span class='chartHoverValue'>"+d.avg+"</span></small> </div> <div><small><span class='chartHoverLabel'>"+minLabel+"</span><span>: </span><span class='chartHoverValue'>"+d.min+"</span></small> </div></div> "}function createHeader(titleName){var title=chart.append("g").append("rect").attr("class","title").attr("x",30).attr("y",margin.top).attr("height",titleHeight).attr("width",width+30+margin.left).attr("fill","none");return chart.append("text").attr("class","titleName").attr("x",40).attr("y",37).text(titleName),title}function createSvgDefs(chart){var defs=chart.append("defs");defs.append("pattern").attr("id","noDataStripes").attr("patternUnits","userSpaceOnUse").attr("x","0").attr("y","0").attr("width","6").attr("height","3").append("path").attr("d","M 0 0 6 0").attr("style","stroke:#CCCCCC; fill:none;"),defs.append("pattern").attr("id","unknownStripes").attr("patternUnits","userSpaceOnUse").attr("x","0").attr("y","0").attr("width","6").attr("height","3").attr("style","stroke:#2E9EC2; fill:none;").append("path").attr("d","M 0 0 6 0"),defs.append("pattern").attr("id","downStripes").attr("patternUnits","userSpaceOnUse").attr("x","0").attr("y","0").attr("width","6").attr("height","3").attr("style","stroke:#ff8a9a; fill:none;").append("path").attr("d","M 0 0 6 0")}function createStackedBars(lowBound,highBound){svg.selectAll("rect.leaderBar").data(chartData).enter().append("rect").attr("class","leaderBar").attr("x",function(d){return timeScale(d.timestamp)}).attr("y",function(d){return isEmptyDataBar(d)?0:yScale(d.min)}).attr("height",function(d){return isEmptyDataBar(d)?height-yScale(highBound):height-yScale(d.min)}).attr("width",function(){return calcBarWidth()}).attr("opacity",".6").attr("fill",function(d){return isEmptyDataBar(d)?"url(#noDataStripes)":leaderBarColor}).on("mouseover",function(d,i){tip.show(d,i)}).on("mouseout",function(){tip.hide()}),svg.selectAll("rect.high").data(chartData).enter().append("rect").attr("class","high").attr("x",function(d){return timeScale(d.timestamp)}).attr("y",function(d){return yScale(isNaN(d.max)?lowBound:d.max)}).attr("height",function(d){return isEmptyDataBar(d)?0:yScale(d.avg)-yScale(d.max)}).attr("width",function(){return calcBarWidth()}).attr("data-rhq-value",function(d){return d.max}).attr("opacity",.9).on("mouseover",function(d,i){tip.show(d,i)}).on("mouseout",function(){tip.hide()}),svg.selectAll("rect.low").data(chartData).enter().append("rect").attr("class","low").attr("x",function(d){return timeScale(d.timestamp)}).attr("y",function(d){return isNaN(d.avg)?height:yScale(d.avg)}).attr("height",function(d){return isEmptyDataBar(d)?0:yScale(d.min)-yScale(d.avg)}).attr("width",function(){return calcBarWidth()}).attr("opacity",.9).attr("data-rhq-value",function(d){return d.min}).on("mouseover",function(d,i){tip.show(d,i)}).on("mouseout",function(){tip.hide()}),svg.selectAll("rect.singleValue").data(chartData).enter().append("rect").attr("class","singleValue").attr("x",function(d){return timeScale(d.timestamp)}).attr("y",function(d){return isNaN(d.value)?height:yScale(d.value)-2}).attr("height",function(d){return isEmptyDataBar(d)?0:d.min===d.max?yScale(d.min)-yScale(d.value)+2:0}).attr("width",function(){return calcBarWidth()}).attr("opacity",.9).attr("data-rhq-value",function(d){return d.value}).attr("fill",function(d){return d.min===d.max?rawValueBarColor:"#70c4e2"}).on("mouseover",function(d,i){tip.show(d,i)}).on("mouseout",function(){tip.hide()})}function createCandleStickChart(){function fillCandleChart(d,i){return i>0&&chartData[i].avg>chartData[i-1].avg?"green":0===i?"none":"#ff0705"}svg.selectAll("rect.candlestick.up").data(chartData).enter().append("rect").attr("class","candleStickUp").attr("x",function(d){return timeScale(d.timestamp)}).attr("y",function(d){return yScale(isNaN(d.max)?lowBound:d.max)}).attr("height",function(d){return isEmptyDataBar(d)?0:yScale(d.avg)-yScale(d.max)}).attr("width",function(){return calcBarWidth()}).attr("data-rhq-value",function(d){return d.max}).style("fill",function(d,i){return fillCandleChart(d,i)}).on("mouseover",function(d,i){tip.show(d,i)}).on("mouseout",function(){tip.hide()}),svg.selectAll("rect.candlestick.down").data(chartData).enter().append("rect").attr("class","candleStickDown").attr("x",function(d){return timeScale(d.timestamp)}).attr("y",function(d){return isNaN(d.avg)?height:yScale(d.avg)}).attr("height",function(d){return isEmptyDataBar(d)?0:yScale(d.min)-yScale(d.avg)}).attr("width",function(){return calcBarWidth()}).attr("data-rhq-value",function(d){return d.min}).style("fill",function(d,i){return fillCandleChart(d,i)}).on("mouseover",function(d,i){tip.show(d,i)}).on("mouseout",function(){tip.hide()})}function createHistogramChart(){var strokeOpacity="0.6";svg.selectAll("rect.histogram").data(chartData).enter().append("rect").attr("class","histogram").attr("x",function(d){return timeScale(d.timestamp)}).attr("width",function(){return calcBarWidth()}).attr("y",function(d){return isEmptyDataBar(d)?0:yScale(d.avg)}).attr("height",function(d){return isEmptyDataBar(d)?height-yScale(highBound):height-yScale(d.avg)}).attr("fill",function(d,i){return isEmptyDataBar(d)?"url(#noDataStripes)":i%5===0?"#989898":"#C0C0C0"}).attr("stroke",function(){return"#777"}).attr("stroke-width",function(d){return isEmptyDataBar(d)?"0":"0"}).attr("data-rhq-value",function(d){return d.avg}).on("mouseover",function(d,i){tip.show(d,i)}).on("mouseout",function(){tip.hide()}),hideHighLowValues===!1&&(svg.selectAll(".histogram.top.stem").data(chartData).enter().append("line").attr("class","histogramTopStem").attr("x1",function(d){return xStartPosition(d)}).attr("x2",function(d){return xStartPosition(d)}).attr("y1",function(d){return yScale(d.max)}).attr("y2",function(d){return yScale(d.avg)}).attr("stroke",function(){return"red"}).attr("stroke-opacity",function(){return strokeOpacity}),svg.selectAll(".histogram.bottom.stem").data(chartData).enter().append("line").attr("class","histogramBottomStem").attr("x1",function(d){return xStartPosition(d)}).attr("x2",function(d){return xStartPosition(d)}).attr("y1",function(d){return yScale(d.avg)}).attr("y2",function(d){return yScale(d.min)}).attr("stroke",function(){return"red"}).attr("stroke-opacity",function(){return strokeOpacity}),svg.selectAll(".histogram.top.cross").data(chartData).enter().append("line").attr("class","histogramTopCross").attr("x1",function(d){return xStartPosition(d)-3}).attr("x2",function(d){return xStartPosition(d)+3}).attr("y1",function(d){return yScale(d.max)}).attr("y2",function(d){return yScale(d.max)}).attr("stroke",function(){return"red"}).attr("stroke-width",function(){return"0.5"}).attr("stroke-opacity",function(){return strokeOpacity}),svg.selectAll(".histogram.bottom.cross").data(chartData).enter().append("line").attr("class","histogramBottomCross").attr("x1",function(d){return xStartPosition(d)-3}).attr("x2",function(d){return xStartPosition(d)+3}).attr("y1",function(d){return yScale(d.min)}).attr("y2",function(d){return yScale(d.min)}).attr("stroke",function(){return"red"}).attr("stroke-width",function(){return"0.5"}).attr("stroke-opacity",function(){return strokeOpacity}))}function createLineChart(){var avgLine=d3.svg.line().interpolate("linear").defined(function(d){return!d.empty}).x(function(d){return xStartPosition(d)}).y(function(d){return yScale(isRawMetric(d)?d.value:d.avg)}),highLine=d3.svg.line().interpolate("linear").defined(function(d){return!d.empty}).x(function(d){return xStartPosition(d)}).y(function(d){return yScale(isRawMetric(d)?d.value:d.max)}),lowLine=d3.svg.line().interpolate("linear").defined(function(d){return!d.empty}).x(function(d){return xStartPosition(d)}).y(function(d){return yScale(isRawMetric(d)?d.value:d.min)});svg.append("path").datum(chartData).attr("class","avgLine").attr("d",avgLine),hideHighLowValues===!1&&(svg.append("path").datum(chartData).attr("class","highLine").attr("d",highLine),svg.append("path").datum(chartData).attr("class","lowLine").attr("d",lowLine))}function createAreaChart(){var highArea=d3.svg.area().interpolate("step-before").defined(function(d){return!d.empty}).x(function(d){return xStartPosition(d)}).y(function(d){return yScale(isRawMetric(d)?d.value:d.max)}).y0(function(d){return yScale(isRawMetric(d)?d.value:d.avg)}),avgArea=d3.svg.area().interpolate("step-before").defined(function(d){return!d.empty}).x(function(d){return xStartPosition(d)}).y(function(d){return yScale(isRawMetric(d)?d.value:d.avg)}).y0(function(d){return yScale(isRawMetric(d)?d.value:d.min)}),lowArea=d3.svg.area().interpolate("step-before").defined(function(d){return!d.empty}).x(function(d){return xStartPosition(d)}).y(function(d){return yScale(isRawMetric(d)?d.value:d.min)}).y0(function(){return height});hideHighLowValues===!1&&(svg.append("path").datum(chartData).attr("class","highArea").attr("d",highArea),svg.append("path").datum(chartData).attr("class","lowArea").attr("d",lowArea)),svg.append("path").datum(chartData).attr("class","avgArea").attr("d",avgArea)}function createScatterChart(){hideHighLowValues===!1&&(svg.selectAll(".highDot").data(chartData).enter().append("circle").attr("class","highDot").attr("r",3).attr("cx",function(d){return xStartPosition(d)}).attr("cy",function(d){return yScale(isRawMetric(d)?d.value:d.max)}).style("fill",function(){return"#ff1a13"}).on("mouseover",function(d,i){tip.show(d,i)}).on("mouseout",function(){tip.hide()}),svg.selectAll(".lowDot").data(chartData).enter().append("circle").attr("class","lowDot").attr("r",3).attr("cx",function(d){return xStartPosition(d)}).attr("cy",function(d){return yScale(isRawMetric(d)?d.value:d.min)}).style("fill",function(){return"#70c4e2"}).on("mouseover",function(d,i){tip.show(d,i)}).on("mouseout",function(){tip.hide()})),svg.selectAll(".avgDot").data(chartData).enter().append("circle").attr("class","avgDot").attr("r",3).attr("cx",function(d){return xStartPosition(d)}).attr("cy",function(d){return yScale(isRawMetric(d)?d.value:d.avg)}).style("fill",function(){return"#FFF"}).on("mouseover",function(d,i){tip.show(d,i)}).on("mouseout",function(){tip.hide()})}function createScatterLineChart(){svg.selectAll(".scatterline.top.stem").data(chartData).enter().append("line").attr("class","scatterLineTopStem").attr("x1",function(d){return xStartPosition(d)}).attr("x2",function(d){return xStartPosition(d)}).attr("y1",function(d){return yScale(d.max)}).attr("y2",function(d){return yScale(d.avg)}).attr("stroke",function(){return"#000"}),svg.selectAll(".scatterline.bottom.stem").data(chartData).enter().append("line").attr("class","scatterLineBottomStem").attr("x1",function(d){return xStartPosition(d)}).attr("x2",function(d){return xStartPosition(d)}).attr("y1",function(d){return yScale(d.avg)}).attr("y2",function(d){return yScale(d.min)}).attr("stroke",function(){return"#000"}),svg.selectAll(".scatterline.top.cross").data(chartData).enter().append("line").attr("class","scatterLineTopCross").attr("x1",function(d){return xStartPosition(d)-3}).attr("x2",function(d){return xStartPosition(d)+3}).attr("y1",function(d){return yScale(d.max)}).attr("y2",function(d){return yScale(d.max)}).attr("stroke",function(){return"#000"}).attr("stroke-width",function(){return"0.5"}),svg.selectAll(".scatterline.bottom.cross").data(chartData).enter().append("line").attr("class","scatterLineBottomCross").attr("x1",function(d){return xStartPosition(d)-3}).attr("x2",function(d){return xStartPosition(d)+3}).attr("y1",function(d){return yScale(d.min)}).attr("y2",function(d){return yScale(d.min)}).attr("stroke",function(){return"#000"}).attr("stroke-width",function(){return"0.5"}),svg.selectAll(".scatterDot").data(chartData).enter().append("circle").attr("class","avgDot").attr("r",3).attr("cx",function(d){return xStartPosition(d)}).attr("cy",function(d){return yScale(isRawMetric(d)?d.value:d.avg)}).style("fill",function(){return"#70c4e2"}).style("opacity",function(){return"1"}).on("mouseover",function(d,i){tip.show(d,i)}).on("mouseout",function(){tip.hide()})}function createYAxisGridLines(){svg.append("g").classed("grid y_grid",!0).call(d3.svg.axis().scale(yScale).orient("left").ticks(10).tickSize(-width,0,0).tickFormat(""))}function createXandYAxes(){var xAxisGroup;svg.selectAll("g.axis").remove(),xAxisGroup=svg.append("g").attr("class","x axis").attr("transform","translate(0,"+height+")").call(xAxis),xAxisGroup.append("g").attr("class","x brush").call(brush).selectAll("rect").attr("y",-6).attr("height",30),svg.append("g").attr("class","y axis").call(yAxis).append("text").attr("transform","rotate(-90),translate( -70,-40)").attr("y",-30).style("text-anchor","end").text("NONE"===attributes.yAxisUnits?"":attributes.yAxisUnits)}function createCenteredLine(newInterpolation){var interpolate=newInterpolation||"monotone",line=d3.svg.line().interpolate(interpolate).defined(function(d){return!d.empty}).x(function(d){return timeScale(d.timestamp)}).y(function(d){return yScale(isRawMetric(d)?d.value:d.avg)});return line}function createAvgLines(){svg.append("path").datum(chartData).attr("class","barAvgLine").attr("d",createCenteredLine("monotone"))}function createXAxisBrush(){function brushStart(){svg.classed("selecting",!0)}function brushMove(){var extent=brush.extent();scope.$emit("DateRangeMove",extent)}function brushEnd(){var extent=brush.extent(),startTime=Math.round(extent[0].getTime()),endTime=Math.round(extent[1].getTime()),dragSelectionDelta=endTime-startTime>=6e4;svg.classed("selecting",!d3.event.target.empty()),dragSelectionDelta&&scope.$emit("DateRangeChanged",extent)}brush=d3.svg.brush().x(timeScaleForBrush).on("brushstart",brushStart).on("brush",brushMove).on("brushend",brushEnd),brushGroup=svg.append("g").attr("class","brush").call(brush),brushGroup.selectAll(".resize").append("path"),brushGroup.selectAll("rect").attr("height",height)}function createPreviousRangeOverlay(prevRangeData){isDefinedAndHasValues(prevRangeData)&&($log.debug("Running PreviousRangeOverlay"),svg.append("path").datum(prevRangeData).attr("class","prevRangeAvgLine").style("stroke-dasharray","9,3").attr("d",createCenteredLine("linear")))}function createMultiMetricOverlay(){var g=0,colorScale=d3.scale.category20();console.warn("Inside createMultiMetricOverlay"),console.dir(multiChartOverlayData),isDefinedAndHasValues(multiChartOverlayData)&&($log.warn("Running MultiChartOverlay for %i metrics",multiChartOverlayData.length),angular.forEach(multiChartOverlayData,function(singleChartData){svg.append("path").datum(singleChartData).attr("class","multiLine").attr("fill",function(d,i){return colorScale(i)}).attr("stroke",function(d,i){return colorScale(i)}).attr("stroke-width","1").attr("stroke-opacity",".8").attr("d",createCenteredLine("linear"))}),g++)}function annotateChart(annotationData){isDefinedAndHasValues(annotationData)&&svg.selectAll(".annotationDot").data(annotationData).enter().append("circle").attr("class","annotationDot").attr("r",5).attr("cx",function(d){return timeScale(d.timestamp)}).attr("cy",function(){return height-yScale(highBound)}).style("fill",function(d){return"1"===d.severity?"red":"2"===d.severity?"yellow":"white"})}function isDefinedAndHasValues(list){return angular.isDefined(list)&&list.length>0}var chartData,calcBarWidth,yScale,timeScale,yAxis,xAxis,tip,brush,brushGroup,timeScaleForBrush,timeScaleForContext,chart,chartParent,svg,lowBound,highBound,avg,peak,min,processedNewData,processedPreviousRangeData,dataPoints=[],previousRangeDataPoints=[],annotationData=[],contextData=[],multiChartOverlayData=[],chartHeight=+attributes.chartHeight||250,chartType=attributes.chartType||"bar",singleValueLabel=(attributes.timeLabel||"Time",attributes.dateLabel||"Date",attributes.singleValueLabel||"Raw Value"),noDataLabel=attributes.noDataLabel||"No Data",durationLabel=(attributes.aggregateLabel||"Aggregate",attributes.startLabel||"Start",attributes.endLabel||"End",attributes.durationLabel||"Bar Duration"),minLabel=attributes.minLabel||"Min",maxLabel=attributes.maxLabel||"Max",avgLabel=attributes.avgLabel||"Avg",timestampLabel=attributes.timestampLabel||"Timestamp",leaderBarColor=(attributes.highBarColor||"#1794bc",attributes.lowBarColor||"#70c4e2",attributes.leaderBarColor||"#d3d3d6"),rawValueBarColor=attributes.rawValueBarColor||"#50505a",avgLineColor=attributes.avgLineColor||"#2e376a",showAvgLine=!0,hideHighLowValues=!1,buttonBarDateTimeFormat=(attributes.chartHoverDateFormat||"%m/%d/%y",attributes.chartHoverTimeFormat||"%I:%M:%S %p",attributes.buttonbarDatetimeFormat||"MM/DD/YYYY h:mm a"),margin={top:10,right:5,bottom:5,left:90},width=750-margin.left-margin.right,adjustedChartHeight=chartHeight-50,height=adjustedChartHeight-margin.top-margin.bottom,smallChartThresholdInPixels=600,titleHeight=30,titleSpace=10,innerChartHeight=height+margin.top-titleHeight-titleSpace+margin.bottom,adjustedChartHeight2=+titleHeight+titleSpace+margin.top,barOffset=2;dataPoints=attributes.data,previousRangeDataPoints=attributes.previousRangeData,multiChartOverlayData=attributes.multiChartOverlayData,annotationData=attributes.annotationData,contextData=attributes.contextData,scope.$watch("data",function(newData){isDefinedAndHasValues(newData)&&($log.debug("Data Changed"),processedNewData=angular.fromJson(newData),scope.render(processedNewData,processedPreviousRangeData))},!0),scope.$watch("previousRangeData",function(newPreviousRangeValues){isDefinedAndHasValues(newPreviousRangeValues)&&($log.debug("Previous Range data changed"),processedPreviousRangeData=angular.fromJson(newPreviousRangeValues),scope.render(processedNewData,processedPreviousRangeData))},!0),scope.$watch("annotationData",function(newAnnotationData){isDefinedAndHasValues(newAnnotationData)&&(annotationData=angular.fromJson(newAnnotationData),scope.render(processedNewData,processedPreviousRangeData))},!0),scope.$watch("contextData",function(newContextData){isDefinedAndHasValues(newContextData)&&(contextData=angular.fromJson(newContextData),scope.render(processedNewData,processedPreviousRangeData))},!0),scope.$on("MultiChartOverlayDataChanged",function(event,newMultiChartData){$log.log("Handling MultiChartOverlayDataChanged in Chart Directive"),angular.isUndefined(newMultiChartData)?multiChartOverlayData=[]:(multiChartOverlayData=angular.fromJson(newMultiChartData),console.dir(multiChartOverlayData)),scope.render(processedNewData,processedPreviousRangeData)}),scope.$watch("chartType",function(newChartType){isDefinedAndHasValues(newChartType)&&(chartType=newChartType,scope.render(processedNewData,processedPreviousRangeData))}),scope.$watch("showAvgLine",function(newShowAvgLine){isDefinedAndHasValues(newShowAvgLine)&&(showAvgLine=newShowAvgLine,scope.render(processedNewData,processedPreviousRangeData))}),scope.$watch("avgLineColor",function(newAvgLineColor){isDefinedAndHasValues(newAvgLineColor)&&(avgLineColor=newAvgLineColor,scope.render(processedNewData,processedPreviousRangeData))}),scope.$watch("hideHighLowValues",function(newHideHighLowValues){isDefinedAndHasValues(newHideHighLowValues)&&(hideHighLowValues=newHideHighLowValues,scope.render(processedNewData,processedPreviousRangeData))}),scope.$on("DateRangeDragChanged",function(event,extent){$log.debug("Handling DateRangeDragChanged Fired Chart Directive: "+extent[0]+" --> "+extent[1]),scope.$emit("GraphTimeRangeChangedEvent",extent)}),scope.render=function(dataPoints,previousRangeDataPoints){isDefinedAndHasValues(dataPoints)&&($log.log("Render Chart"),console.dir(multiChartOverlayData),oneTimeChartSetup(),determineScale(dataPoints),createHeader(attributes.chartTitle),createYAxisGridLines(),createXAxisBrush(),"bar"===chartType?createStackedBars(lowBound,highBound):"histogram"===chartType?createHistogramChart():"line"===chartType?createLineChart():"area"===chartType?createAreaChart():"scatter"===chartType?createScatterChart():"scatterline"===chartType?createScatterLineChart():"candlestick"===chartType?createCandleStickChart():$log.warn("chart-type is not valid. Must be in [bar,area,line,scatter,candlestick,histogram]"),createPreviousRangeOverlay(previousRangeDataPoints),createMultiMetricOverlay(),createXandYAxes(),showAvgLine===!0&&createAvgLines(),annotateChart(annotationData))}}return{link:link,restrict:"EA",replace:!0,scope:{data:"@",previousRangeData:"@",annotationData:"@",contextData:"@",multiChartOverlayData:"@",chartHeight:"@",chartType:"@",yAxisUnits:"@",buttonbarDatetimeFormat:"@",timeLabel:"@",dateLabel:"@",chartHoverDateFormat:"@",chartHoverTimeFormat:"@",singleValueLabel:"@",noDataLabel:"@",aggregateLabel:"@",startLabel:"@",endLabel:"@",durationLabel:"@",minLabel:"@",maxLabel:"@",avgLabel:"@",timestampLabel:"@",highBarColor:"@",lowBarColor:"@",leaderBarColor:"@",rawValueBarColor:"@",avgLineColor:"@",showAvgLine:"@",hideHighLowValues:"@",chartTitle:"@"}}}])}(Directives||(Directives={}));var Directives;!function(){"use strict";angular.module("rhqm.directives").directive("relativeTimeRangeButtonBar",function(){return{templateUrl:"../views/directives/date-time-range-selection.tpl.html",controller:function($scope){$scope.dateTimeRanges=[{range:"1h",rangeInSeconds:3600},{range:"4h",rangeInSeconds:14400},{range:"8h",rangeInSeconds:28800},{range:"12h",rangeInSeconds:43200},{range:"1d",rangeInSeconds:86400},{range:"5d",rangeInSeconds:432e3},{range:"1m",rangeInSeconds:2592e3},{range:"3m",rangeInSeconds:7776e3},{range:"6m",rangeInSeconds:15552e3}],$scope.dateTimeRangeButtonBarModel={graphTimeRangeSelection:"1d"},$scope.$watch("dateTimeRangeButtonBarModel.graphTimeRangeSelection",function(){var startDateMoment,endDateMoment,startEndArray=[];endDateMoment=moment();for(var i=0;i<$scope.dateTimeRanges.length;i++){var dateTimeRange=$scope.dateTimeRanges[i];if(dateTimeRange.range===$scope.dateTimeRangeButtonBarModel.graphTimeRangeSelection){startDateMoment=endDateMoment.subtract("seconds",dateTimeRange.rangeInSeconds);break}}startEndArray.push(startDateMoment.toDate()),startEndArray.push(new Date),$scope.$emit("GraphTimeRangeChangedEvent",startEndArray)})},replace:!0,restrict:"EA",scope:{startTimeStamp:"=",endTimeStamp:"="}}})}(Directives||(Directives={}));var Directives;!function(){"use strict";angular.module("rhqm.directives").directive("ngEnter",function(){return function(scope,element,attrs){element.bind("keydown keypress",function(event){13===event.which&&(scope.$apply(function(){scope.$eval(attrs.ngEnter)}),event.preventDefault())})}})}(Directives||(Directives={}));