'use strict';
angular.module('chartingApp', ['ui.bootstrap', 'ngStorage', 'ui.sortable', 'rhqm.directives', 'rhqm.services', 'rhqmCharts', 'cgBusy', 'ngClipboard', 'angularytics']).constant('BASE_URL', '/rhq-metrics').constant('TENANT_ID', 'test').constant('DATE_TIME_FORMAT', 'MM/DD/YYYY h:mm a').config(['$httpProvider', function ($httpProvider) {
    $httpProvider.defaults.useXDomain = true;
    delete $httpProvider.defaults.headers.common['X-Requested-With'];
}]).config(['AngularyticsProvider', function (AngularyticsProvider) {
    AngularyticsProvider.setEventHandlers(['GoogleUniversal', 'Console']);
}]).run(['Angularytics', function (Angularytics) {
    Angularytics.init();
}]).run(function ($rootScope, $localStorage, $location, $interval) {
    $rootScope.$storage = $localStorage.$default({
        server: $location.host(),
        port: ($location.host() === '127.0.0.1') ? '8080' : $location.port()
    });
    var startIntervalPromise = $interval(function () {
        $rootScope.$broadcast('LoadAllSidebarMetricsEvent');
        $rootScope.$emit('LoadAllSidebarMetricsEvent');
        $interval.cancel(startIntervalPromise);
    }, 1000);
});
angular.module('rhqm.directives', ['ui.bootstrap']);
angular.module('rhqm.services', ['ngStorage']);
//# sourceMappingURL=app.js.map