var Controllers;
(function (Controllers) {
    'use strict';
    var SidebarController = (function () {
        function SidebarController($scope, $rootScope, metricDataService, dashboardStateService, Angularytics) {
            var _this = this;
            this.$scope = $scope;
            this.$rootScope = $rootScope;
            this.metricDataService = metricDataService;
            this.dashboardStateService = dashboardStateService;
            this.Angularytics = Angularytics;
            $scope.vm = this;
            $scope.$on('RemoveSelectedMetricEvent', function (event, metricId) {
                angular.forEach(_this.allMetrics, function (value) {
                    if (value.name === metricId) {
                        value.selected = false;
                        return;
                    }
                });
            });
            $scope.$on('LoadAllSidebarMetricsEvent', function () {
                _this.Angularytics.trackEvent('LoadAllSidebarMetricsEvent', 'true');
                _this.populateMetricsSidebar();
                _this.$rootScope.$emit('LoadInitialChartGroup');
            });
            $scope.$on('SelectedMetricsChangedEvent', function () {
                _this.selectedMetricsChanged();
            });
        }
        SidebarController.prototype.selectedMetricsChanged = function () {
            var _this = this;
            _.each(this.allMetrics, function (metric) {
                _.each(_this.dashboardStateService.getSelectedMetrics(), function (selectedMetric) {
                    if (selectedMetric === metric.name) {
                        metric.selected = true;
                    }
                });
            });
        };
        SidebarController.prototype.populateMetricsSidebar = function () {
            var _this = this;
            this.retrieveMetricsPromise = this.metricDataService.getAllMetrics().then(function (response) {
                _this.allMetrics = response;
                _this.selectedMetricsChanged();
                _this.$rootScope.$emit('SidebarRefreshedEvent');
            }, function (error) {
                console.error('Error Retrieving all metrics: ' + error);
                toastr.error('Error Retrieving all metrics: ' + error);
            });
        };
        SidebarController.prototype.addRemoveChart = function (metricId, checked) {
            if (checked) {
                this.Angularytics.trackEvent('SideBar', 'RemoveChart', metricId);
                this.$rootScope.$emit('RemoveChartEvent', metricId);
            }
            else {
                this.Angularytics.trackEvent('SideBar', 'AddChart', metricId);
                this.$rootScope.$emit('NewChartEvent', metricId);
            }
        };
        SidebarController.$inject = ['$scope', '$rootScope', 'metricDataService', 'dashboardStateService', 'Angularytics'];
        return SidebarController;
    })();
    Controllers.SidebarController = SidebarController;
    angular.module('chartingApp').controller('SidebarController', SidebarController);
})(Controllers || (Controllers = {}));
//# sourceMappingURL=sidebar-controller.js.map