var Services;
(function (Services) {
    'use strict';
    var DashboardStateService = (function () {
        function DashboardStateService($q, $rootScope) {
            this.$q = $q;
            this.$rootScope = $rootScope;
            this.selectedMetricIds = [];
        }
        DashboardStateService.prototype.clear = function () {
            this.selectedMetricIds = [];
        };
        DashboardStateService.prototype.setSelectedMetricIds = function (newSelectedMetricsIds) {
            this.selectedMetricIds = newSelectedMetricsIds;
        };
        DashboardStateService.prototype.add = function (metricId) {
            if (!_.contains(this.selectedMetricIds, metricId)) {
                this.selectedMetricIds.push(metricId);
            }
        };
        DashboardStateService.prototype.remove = function (metricId) {
            var pos = _.indexOf(this.selectedMetricIds, metricId);
            this.selectedMetricIds.splice(pos, 1);
        };
        DashboardStateService.prototype.getSelectedMetrics = function () {
            return this.selectedMetricIds;
        };
        DashboardStateService.prototype.getSelectedMetricsAsString = function () {
            return this.selectedMetricIds.join(',');
        };
        DashboardStateService.$inject = ['$q', '$rootScope'];
        return DashboardStateService;
    })();
    Services.DashboardStateService = DashboardStateService;
    angular.module('rhqm.services').service('dashboardStateService', DashboardStateService);
})(Services || (Services = {}));
//# sourceMappingURL=dashboard-state-service.js.map