/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.clients.ptrans;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Properties;
import org.rhq.metrics.clients.ptrans.DemuxHandler;
import org.rhq.metrics.clients.ptrans.MetricBatcher;
import org.rhq.metrics.clients.ptrans.backend.RestForwardingHandler;
import org.rhq.metrics.clients.ptrans.ganglia.UdpGangliaDecoder;
import org.rhq.metrics.clients.ptrans.statsd.StatsdDecoder;
import org.rhq.metrics.clients.ptrans.syslog.UdpSyslogEventDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final int DEFAULT_PORT = 5140;
    public static final String CONFIG_PROPERTIES_FILE_NAME = "ptrans.properties";
    private static final int GANGLIA_DEFAULT_PORT = 8649;
    int tcpPort = 5140;
    int udpPort = 5140;
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static final String GANGLIA_DEFAULT_GROUP = "239.2.11.71";
    private String gangliaGroup = "239.2.11.71";
    private int gangliaPort = 8649;
    private String multicastIfOverride;
    private static final int STATSD_DEFAULT_PORT = 8125;
    private int statsDport = 8125;

    public static void main(String[] args) throws Exception {
        Main main = new Main();
        main.run();
    }

    public Main() {
        this.loadPortsFromProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group((EventLoopGroup)group, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.tcpPort)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel socketChannel) throws Exception {
                    ChannelPipeline pipeline = socketChannel.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new DemuxHandler()});
                }
            });
            ChannelFuture graphiteFuture = serverBootstrap.bind().sync();
            logger.info("Server listening on TCP " + graphiteFuture.channel().localAddress());
            graphiteFuture.channel().closeFuture();
            Bootstrap udpBootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)udpBootstrap.group((EventLoopGroup)group)).channel(NioDatagramChannel.class)).localAddress(this.udpPort)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                public void initChannel(Channel socketChannel) throws Exception {
                    ChannelPipeline pipeline = socketChannel.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new UdpSyslogEventDecoder()});
                    pipeline.addLast(new ChannelHandler[]{new RestForwardingHandler()});
                }
            });
            ChannelFuture udpFuture = udpBootstrap.bind().sync();
            logger.info("Syslogd listening on udp " + udpFuture.channel().localAddress());
            this.setupGangliaUdp((EventLoopGroup)group);
            this.setupStatsdUdp((EventLoopGroup)group);
            udpFuture.channel().closeFuture().sync();
        }
        finally {
            group.shutdownGracefully().sync();
            group.shutdownGracefully().sync();
        }
    }

    private void setupStatsdUdp(EventLoopGroup group) {
        Bootstrap statsdBootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)statsdBootstrap.group(group)).channel(NioDatagramChannel.class)).localAddress(this.statsDport)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel socketChannel) throws Exception {
                ChannelPipeline pipeline = socketChannel.pipeline();
                pipeline.addLast(new ChannelHandler[]{new StatsdDecoder()});
                pipeline.addLast(new ChannelHandler[]{new MetricBatcher("statsd")});
                pipeline.addLast(new ChannelHandler[]{new RestForwardingHandler()});
            }
        });
        try {
            ChannelFuture statsdFuture = statsdBootstrap.bind().sync();
            logger.info("Statsd listening on udp " + statsdFuture.channel().localAddress());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void setupGangliaUdp(EventLoopGroup group) {
        try {
            NetworkInterface mcIf;
            if (this.multicastIfOverride == null) {
                Inet4Address hostAddr = (Inet4Address)InetAddress.getLocalHost();
                mcIf = NetworkInterface.getByInetAddress(hostAddr);
            } else {
                mcIf = NetworkInterface.getByName(this.multicastIfOverride);
            }
            InetSocketAddress gangliaSocket = new InetSocketAddress(this.gangliaGroup, this.gangliaPort);
            Bootstrap gangliaBootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)gangliaBootstrap.group(group)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.IP_MULTICAST_IF, (Object)mcIf)).localAddress((SocketAddress)gangliaSocket)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                public void initChannel(Channel socketChannel) throws Exception {
                    ChannelPipeline pipeline = socketChannel.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new UdpGangliaDecoder()});
                    pipeline.addLast(new ChannelHandler[]{new MetricBatcher("ganglia")});
                    pipeline.addLast(new ChannelHandler[]{new RestForwardingHandler()});
                }
            });
            logger.info("Bootstrap is " + gangliaBootstrap);
            ChannelFuture gangliaFuture = gangliaBootstrap.bind().sync();
            logger.info("Ganglia listening on udp " + gangliaFuture.channel().localAddress());
            DatagramChannel channel = (DatagramChannel)gangliaFuture.channel();
            channel.joinGroup(gangliaSocket, mcIf).sync();
            logger.info("Joined the group");
            channel.closeFuture();
        }
        catch (InterruptedException | SocketException | UnknownHostException e) {
            logger.warn("Setup of udp multicast for Ganglia failed");
            e.printStackTrace();
        }
    }

    private void loadPortsFromProperties() {
        try (InputStream inputStream = ClassLoader.getSystemResourceAsStream(CONFIG_PROPERTIES_FILE_NAME);){
            if (inputStream == null) {
                logger.warn("Can not load properties from 'ptrans.properties', using defaults");
                return;
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            this.udpPort = Integer.parseInt(properties.getProperty("port.udp", String.valueOf(5140)));
            this.tcpPort = Integer.parseInt(properties.getProperty("port.tcp", String.valueOf(5140)));
            this.gangliaGroup = properties.getProperty("ganglia.group", GANGLIA_DEFAULT_GROUP);
            this.gangliaPort = Integer.parseInt(properties.getProperty("ganglia.port", String.valueOf(8649)));
            this.multicastIfOverride = properties.getProperty("multicast.interface");
            this.statsDport = Integer.parseInt(properties.getProperty("statsd.port", String.valueOf(8125)));
        }
        catch (IOException e) {
            logger.warn("Can not load properties from 'ptrans.properties'");
        }
    }
}

