/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet.influx;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.rhq.metrics.core.MetricsService;
import org.rhq.metrics.core.RawNumericMetric;
import org.rhq.metrics.restServlet.ServiceKeeper;
import org.rhq.metrics.restServlet.StringValue;
import org.rhq.metrics.restServlet.influx.InfluxQuery;

@Path(value="/influx")
@Produces(value={"application/json"})
public class InfluxHandler {
    private static final String SELECT_FROM = "select ";
    @Inject
    private MetricsService metricsService;

    @GET
    @Path(value="/series")
    public void series(@Suspended AsyncResponse asyncResponse, @QueryParam(value="q") String queryString) {
        if (queryString == null || queryString.isEmpty()) {
            asyncResponse.cancel();
            return;
        }
        if (queryString.equals("list series")) {
            ListenableFuture future = ServiceKeeper.getInstance().service.listMetrics();
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            String query = queryString.toLowerCase();
            if (query.startsWith(SELECT_FROM)) {
                InfluxQuery iq = new InfluxQuery(query);
                String metric = iq.getMetric();
                ListenableFuture idExistsFuture = this.metricsService.idExists(metric);
                Futures.addCallback((ListenableFuture)idExistsFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                StringValue errMsg = new StringValue("Query not yet supported: " + queryString);
                asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build());
            }
        }
    }

    private List<RawNumericMetric> applyMapping(InfluxQuery query, List<RawNumericMetric> in, int bucketLengthSec, long startTime, long endTime) {
        String mapping = query.getMapping();
        if (mapping == null || mapping.isEmpty() || mapping.equals("none")) {
            return in;
        }
        long timeDiff = endTime - startTime;
        int numBuckets = (int)(timeDiff / 1000L / (long)bucketLengthSec);
        HashMap<Integer, ArrayList<RawNumericMetric>> tmpMap = new HashMap<Integer, ArrayList<RawNumericMetric>>(numBuckets);
        for (RawNumericMetric rnm : in) {
            int pos = (int)((rnm.getTimestamp() - startTime) / 1000L) / bucketLengthSec;
            ArrayList<RawNumericMetric> bucket = (ArrayList<RawNumericMetric>)tmpMap.get(pos);
            if (bucket == null) {
                bucket = new ArrayList<RawNumericMetric>();
                tmpMap.put(pos, bucket);
            }
            bucket.add(rnm);
        }
        ArrayList<RawNumericMetric> out = new ArrayList<RawNumericMetric>(numBuckets);
        TreeSet keySet = new TreeSet(tmpMap.keySet());
        for (Integer pos : keySet) {
            List list = (List)tmpMap.get(pos);
            double retVal = 0.0;
            if (list == null) continue;
            int size = list.size();
            RawNumericMetric lastElementInList = (RawNumericMetric)list.get(size - 1);
            RawNumericMetric firstElementInList = (RawNumericMetric)list.get(0);
            switch (mapping) {
                case "mean": {
                    for (RawNumericMetric rnm : list) {
                        retVal += rnm.getAvg().doubleValue();
                    }
                    retVal /= (double)size;
                    break;
                }
                case "max": {
                    retVal = Double.MIN_VALUE;
                    for (RawNumericMetric rnm : list) {
                        if (!(rnm.getAvg() > retVal)) continue;
                        retVal = rnm.getAvg();
                    }
                    break;
                }
                case "min": {
                    retVal = Double.MAX_VALUE;
                    for (RawNumericMetric rnm : list) {
                        if (!(rnm.getAvg() < retVal)) continue;
                        retVal = rnm.getAvg();
                    }
                    break;
                }
                case "sum": {
                    for (RawNumericMetric rnm : list) {
                        retVal += rnm.getAvg().doubleValue();
                    }
                    break;
                }
                case "count": {
                    retVal = size;
                    break;
                }
                case "first": {
                    if (list.isEmpty()) break;
                    retVal = firstElementInList.getAvg();
                    break;
                }
                case "last": {
                    if (list.isEmpty()) break;
                    retVal = lastElementInList.getAvg();
                    break;
                }
                case "difference": {
                    if (list.isEmpty()) break;
                    retVal = lastElementInList.getAvg() - firstElementInList.getAvg();
                    break;
                }
                case "derivative": {
                    if (list.isEmpty()) break;
                    double y = lastElementInList.getAvg() - firstElementInList.getAvg();
                    long t = (lastElementInList.getTimestamp() - firstElementInList.getTimestamp()) / 1000L;
                    retVal = y / (double)t;
                    break;
                }
                case "median": {
                    retVal = this.quantil(list, 50.0);
                    break;
                }
                case "percentile": {
                    retVal = this.quantil(list, Double.valueOf(query.getMappingArgs()).doubleValue());
                    break;
                }
                default: {
                    System.out.println("Mapping of " + query + " not yet supported");
                }
            }
            RawNumericMetric outMetric = new RawNumericMetric(firstElementInList.getId(), Double.valueOf(retVal), firstElementInList.getTimestamp());
            out.add(outMetric);
        }
        return out;
    }

    public double quantil(List<RawNumericMetric> in, double val) {
        int n = in.size();
        ArrayList<Double> bla = new ArrayList<Double>(n);
        for (RawNumericMetric rnm : in) {
            bla.add(rnm.getAvg());
        }
        Collections.sort(bla);
        float x = (float)((double)n * (val / 100.0));
        if (Math.floor(x) == (double)x) {
            return 0.5 * ((Double)bla.get((int)x - 1) + (Double)bla.get((int)x));
        }
        return (Double)bla.get((int)Math.ceil(x - 1.0f));
    }

    static /* synthetic */ MetricsService access$000(InfluxHandler x0) {
        return x0.metricsService;
    }

    static /* synthetic */ List access$100(InfluxHandler x0, InfluxQuery x1, List x2, int x3, long x4, long x5) {
        return x0.applyMapping(x1, x2, x3, x4, x5);
    }
}

