/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.rhq.metrics.restServlet.JsonPAsyncListener;
import org.rhq.metrics.restServlet.JsonPFilter;

@WebFilter(urlPatterns={"/*"}, asyncSupported=true)
@WebInitParam(name="filter.jsonp.callback", value="jsonp", description="Name of the callback to use for JsonP (?jsonp=...)")
public class JsonPFilter
implements Filter {
    private static final String DEFAULT_CALLBACK_NAME = "jsonp";
    private String callbackName;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("This filter can only process HttpServletRequest requests");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.hasCallback((ServletRequest)httpRequest)) {
            String callback = this.getCallback(httpRequest);
            JsonPResponseWrapper responseWrapper = new JsonPResponseWrapper(httpResponse, null);
            chain.doFilter(request, (ServletResponse)responseWrapper);
            if (request.isAsyncStarted()) {
                AsyncListener asyncListener = request.getAsyncContext().createListener(JsonPAsyncListener.class);
                ((JsonPAsyncListener)asyncListener).set(httpResponse, callback);
                request.getAsyncContext().addListener(asyncListener, request, (ServletResponse)responseWrapper);
            } else {
                ServletOutputStream outputStream = response.getOutputStream();
                response.setContentType("application/javascript; charset=utf-8");
                outputStream.write((callback + "(").getBytes(StandardCharsets.UTF_8));
                responseWrapper.getByteArrayOutputStream().writeTo((OutputStream)outputStream);
                outputStream.write(");".getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.callbackName = config.getInitParameter("filter.jsonp.callback");
        if (this.callbackName == null) {
            this.callbackName = DEFAULT_CALLBACK_NAME;
        }
    }

    private boolean hasCallback(ServletRequest request) {
        String cb = request.getParameter(this.callbackName);
        return cb != null && !cb.isEmpty();
    }

    private String getCallback(HttpServletRequest request) {
        String parameter = request.getParameter(this.callbackName);
        if (parameter == null) {
            parameter = DEFAULT_CALLBACK_NAME;
        }
        return parameter;
    }
}

