/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.GZIP;
import org.rhq.metrics.core.Availability;
import org.rhq.metrics.core.AvailabilityMetric;
import org.rhq.metrics.core.Counter;
import org.rhq.metrics.core.Metric;
import org.rhq.metrics.core.MetricData;
import org.rhq.metrics.core.MetricId;
import org.rhq.metrics.core.MetricType;
import org.rhq.metrics.core.MetricsService;
import org.rhq.metrics.core.NumericData;
import org.rhq.metrics.core.NumericMetric2;
import org.rhq.metrics.core.Tag;
import org.rhq.metrics.core.Tenant;
import org.rhq.metrics.restServlet.AvailabilityDataParams;
import org.rhq.metrics.restServlet.AvailabilityDataPoint;
import org.rhq.metrics.restServlet.BucketDataPoint;
import org.rhq.metrics.restServlet.DataInsertedCallback;
import org.rhq.metrics.restServlet.IdDataPoint;
import org.rhq.metrics.restServlet.MetricHandler;
import org.rhq.metrics.restServlet.MetricParams;
import org.rhq.metrics.restServlet.NumericDataParams;
import org.rhq.metrics.restServlet.NumericDataPoint;
import org.rhq.metrics.restServlet.ServiceKeeper;
import org.rhq.metrics.restServlet.StringValue;
import org.rhq.metrics.restServlet.TagParams;
import org.rhq.metrics.restServlet.TenantParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Related to metrics")
@Path(value="/")
public class MetricHandler {
    private static final Logger logger = LoggerFactory.getLogger(MetricHandler.class);
    private static final long EIGHT_HOURS = TimeUnit.MILLISECONDS.convert(8L, TimeUnit.HOURS);
    @Inject
    private MetricsService metricsService;

    public MetricHandler() {
        if (logger.isDebugEnabled()) {
            logger.debug("MetricHandler instantiated");
        }
    }

    @GET
    @POST
    @Path(value="/ping")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml", "application/vnd.rhq.wrapped+json"})
    @ApiOperation(value="Returns the current time and serves to check for the availability of the api.", responseClass="Map<String,String>")
    public Response ping() {
        StringValue reply = new StringValue(new Date().toString());
        Response.ResponseBuilder builder = Response.ok((Object)reply);
        return builder.build();
    }

    @POST
    @Path(value="/tenants")
    @Consumes(value={"application/json"})
    public void createTenant(@Suspended AsyncResponse asyncResponse, TenantParams params) {
        Tenant tenant = new Tenant().setId(params.getId());
        for (String type : params.getRetentions().keySet()) {
            if (type.equals(MetricType.NUMERIC.getText())) {
                tenant.setRetention(MetricType.NUMERIC, ((Integer)params.getRetentions().get(type)).intValue());
                continue;
            }
            if (type.equals(MetricType.AVAILABILITY.getText())) {
                tenant.setRetention(MetricType.AVAILABILITY, ((Integer)params.getRetentions().get(type)).intValue());
                continue;
            }
            ImmutableMap errors = ImmutableMap.of((Object)"errorMessage", (Object)("The retentions property is invalid. [" + type + "] is not a recognized metric type"));
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            return;
        }
        ListenableFuture insertFuture = this.metricsService.createTenant(tenant);
        Futures.addCallback((ListenableFuture)insertFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @POST
    @Path(value="/{tenantId}/metrics/numeric")
    @Consumes(value={"application/json"})
    public void createNumericMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, MetricParams params) {
        NumericMetric2 metric = new NumericMetric2(tenantId, new MetricId(params.getName()), params.getMetadata());
        ListenableFuture future = this.metricsService.createMetric((Metric)metric);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new MetricCreatedCallback(this, asyncResponse, params));
    }

    @POST
    @Path(value="/{tenantId}/metrics/availability")
    @Consumes(value={"application/json"})
    public void createAvailabilityMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, MetricParams params) {
        AvailabilityMetric metric = new AvailabilityMetric(tenantId, new MetricId(params.getName()), params.getMetadata());
        ListenableFuture future = this.metricsService.createMetric((Metric)metric);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new MetricCreatedCallback(this, asyncResponse, params));
    }

    @GET
    @Path(value="/{tenantId}/metrics/numeric/{id}/meta")
    public void getNumericMetricMetadata(@Suspended AsyncResponse response, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id) {
        ListenableFuture future = this.metricsService.findMetric(tenantId, MetricType.NUMERIC, new MetricId(id));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new GetMetadataCallback(this, response));
    }

    @PUT
    @Path(value="/{tenantId}/metrics/numeric/{id}/meta")
    public void updateNumericMetricMetadata(@Suspended AsyncResponse response, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, Map<String, ? extends Object> updates) {
        HashMap<String, String> additions = new HashMap<String, String>();
        HashSet deletions = new HashSet();
        for (String key : updates.keySet()) {
            if (key.equals("[delete]")) {
                deletions.addAll((List)updates.get(key));
                continue;
            }
            additions.put(key, (String)updates.get(key));
        }
        NumericMetric2 metric = new NumericMetric2(tenantId, new MetricId(id));
        ListenableFuture future = this.metricsService.updateMetadata((Metric)metric, additions, deletions);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new DataInsertedCallback(response, "Failed to update meta data"));
    }

    @GET
    @Path(value="/{tenantId}/metrics/availability/{id}/meta")
    public void getAvailabilityMetricMetadata(@Suspended AsyncResponse response, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id) {
        ListenableFuture future = this.metricsService.findMetric(tenantId, MetricType.AVAILABILITY, new MetricId(id));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new GetMetadataCallback(this, response));
    }

    @PUT
    @Path(value="/{tenantId}/metrics/availability/{id}/meta")
    public void updateAvailabilityMetricMetadata(@Suspended AsyncResponse response, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, Map<String, ? extends Object> updates) {
        HashMap<String, String> additions = new HashMap<String, String>();
        HashSet deletions = new HashSet();
        for (String key : updates.keySet()) {
            if (key.equals("[delete]")) {
                deletions.addAll((List)updates.get(key));
                continue;
            }
            additions.put(key, (String)updates.get(key));
        }
        AvailabilityMetric metric = new AvailabilityMetric(tenantId, new MetricId(id));
        ListenableFuture future = this.metricsService.updateMetadata((Metric)metric, additions, deletions);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new DataInsertedCallback(response, "Failed to update meta data"));
    }

    @POST
    @Path(value="/metrics/{id}")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Adds a single data point for the given id.")
    public void addMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, IdDataPoint dataPoint) {
        dataPoint.setId(id);
        this.addMetrics(asyncResponse, Arrays.asList(dataPoint));
    }

    @POST
    @Path(value="/metrics")
    @Consumes(value={"application/json", "application/xml"})
    @ApiOperation(value="Add a collection of data. Values can be for different metric ids.")
    public void addMetrics(@Suspended AsyncResponse asyncResponse, Collection<IdDataPoint> dataPoints) {
        if (dataPoints.isEmpty()) {
            asyncResponse.resume((Object)Response.ok().type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        ArrayList<NumericMetric2> metrics = new ArrayList<NumericMetric2>();
        NumericMetric2 metric = null;
        for (IdDataPoint p : dataPoints) {
            if (metric == null) {
                metric = new NumericMetric2("test", new MetricId(p.getId()));
            } else if (!p.getId().equals(metric.getId().getName())) {
                metrics.add(metric);
                metric = new NumericMetric2("test", new MetricId(p.getId()));
            }
            metric.addData(p.getTimestamp(), Double.valueOf(p.getValue()).doubleValue());
        }
        metrics.add(metric);
        ListenableFuture future = this.metricsService.addNumericData(metrics);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @POST
    @Path(value="/{tenantId}/metrics/numeric/{id}/data")
    @Consumes(value={"application/json"})
    public void addDataForMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, List<NumericDataPoint> dataPoints) {
        NumericMetric2 metric = new NumericMetric2(tenantId, new MetricId(id));
        for (NumericDataPoint p : dataPoints) {
            metric.addData(p.getTimestamp(), p.getValue());
        }
        ListenableFuture future = this.metricsService.addNumericData(Arrays.asList(metric));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new DataInsertedCallback(asyncResponse, "Failed to insert data"));
    }

    @POST
    @Path(value="/{tenantId}/metrics/availability/{id}/data")
    @Consumes(value={"application/json"})
    public void addAvailabilityForMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, List<AvailabilityDataPoint> data) {
        AvailabilityMetric metric = new AvailabilityMetric(tenantId, new MetricId(id));
        for (AvailabilityDataPoint p : data) {
            metric.addData((MetricData)new Availability(metric, p.getTimestamp(), p.getValue()));
        }
        ListenableFuture future = this.metricsService.addAvailabilityData(Arrays.asList(metric));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new DataInsertedCallback(asyncResponse, "Failed to insert data"));
    }

    @POST
    @Path(value="/{tenantId}/metrics/numeric/data")
    @Consumes(value={"application/json"})
    public void addNumericData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, List<NumericDataParams> paramsList) {
        if (paramsList.isEmpty()) {
            asyncResponse.resume((Object)Response.ok().type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        ArrayList<NumericMetric2> metrics = new ArrayList<NumericMetric2>(paramsList.size());
        for (NumericDataParams params : paramsList) {
            NumericMetric2 metric = new NumericMetric2(tenantId, new MetricId(params.getName()), params.getMetadata());
            for (NumericDataPoint p : params.getData()) {
                metric.addData(p.getTimestamp(), p.getValue());
            }
            metrics.add(metric);
        }
        ListenableFuture future = this.metricsService.addNumericData(metrics);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new DataInsertedCallback(asyncResponse, "Failed to insert data"));
    }

    @POST
    @Path(value="/{tenantId}/metrics/availability/data")
    @Consumes(value={"application/json"})
    public void addAvailabilityData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, List<AvailabilityDataParams> paramsList) {
        if (paramsList.isEmpty()) {
            asyncResponse.resume((Object)Response.ok().type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        ArrayList<AvailabilityMetric> metrics = new ArrayList<AvailabilityMetric>(paramsList.size());
        for (AvailabilityDataParams params : paramsList) {
            AvailabilityMetric metric = new AvailabilityMetric(tenantId, new MetricId(params.getName()), params.getMetadata());
            for (AvailabilityDataPoint p : params.getData()) {
                metric.addData((MetricData)new Availability(metric, p.getTimestamp(), p.getValue()));
            }
            metrics.add(metric);
        }
        ListenableFuture future = this.metricsService.addAvailabilityData(metrics);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new DataInsertedCallback(asyncResponse, "Failed to insert data"));
    }

    @GET
    @Path(value="/{tenantId}/numeric")
    public void findNumericDataByTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @QueryParam(value="tags") String tags) {
        ImmutableSet tagSet = ImmutableSet.copyOf((Object[])tags.split(","));
        ListenableFuture queryFuture = this.metricsService.findNumericDataByTags(tenantId, (Set)tagSet);
        Futures.addCallback((ListenableFuture)queryFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="/{tenantId}/availability")
    public void findAvailabilityDataByTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @QueryParam(value="tags") String tags) {
        ImmutableSet tagSet = ImmutableSet.copyOf((Object[])tags.split(","));
        ListenableFuture queryFuture = this.metricsService.findAvailabilityByTags(tenantId, (Set)tagSet);
        Futures.addCallback((ListenableFuture)queryFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Set<String> getTagNames(MetricData d) {
        if (d.getTags().isEmpty()) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (Tag tag : d.getTags()) {
            set.add(tag.getValue());
        }
        return set;
    }

    @GET
    @Path(value="/{tenantId}/metrics/numeric/{id}/data")
    public void findNumericData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, @QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="buckets") int numberOfBuckets, @QueryParam(value="bucketWidthSeconds") int bucketWidthSeconds, @QueryParam(value="skipEmpty") @DefaultValue(value="false") boolean skipEmpty, @QueryParam(value="bucketCluster") @DefaultValue(value="true") boolean bucketCluster) {
        long now = System.currentTimeMillis();
        if (start == null) {
            start = now - EIGHT_HOURS;
        }
        if (end == null) {
            end = now;
        }
        NumericMetric2 metric = new NumericMetric2(tenantId, new MetricId(id));
        ListenableFuture dataFuture = this.metricsService.findNumericData(metric, start.longValue(), end.longValue());
        ListenableFuture outputFuture = null;
        if (numberOfBuckets == 0) {
            outputFuture = Futures.transform((ListenableFuture)dataFuture, (Function)new MetricOutMapper(this, null));
        } else if (bucketWidthSeconds == 0) {
            outputFuture = Futures.transform((ListenableFuture)dataFuture, (Function)new CreateSimpleBuckets(this, start.longValue(), end.longValue(), numberOfBuckets, skipEmpty));
        } else {
            ListenableFuture bucketsFuture = Futures.transform((ListenableFuture)dataFuture, (Function)new CreateFixedNumberOfBuckets(this, numberOfBuckets, bucketWidthSeconds));
            outputFuture = bucketCluster ? Futures.transform((ListenableFuture)bucketsFuture, (Function)new FlattenBuckets(this, numberOfBuckets, bucketWidthSeconds, skipEmpty)) : Futures.transform((ListenableFuture)bucketsFuture, (Function)new ClusterBucketData(this, numberOfBuckets, bucketWidthSeconds));
        }
        Futures.addCallback((ListenableFuture)outputFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="/{tenantId}/metrics/availability/{id}/data")
    public void findAvailabilityData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, @QueryParam(value="start") Long start, @QueryParam(value="end") Long end) {
        long now = System.currentTimeMillis();
        if (start == null) {
            start = now - EIGHT_HOURS;
        }
        if (end == null) {
            end = now;
        }
        AvailabilityMetric metric = new AvailabilityMetric(tenantId, new MetricId(id));
        ListenableFuture future = this.metricsService.findAvailabilityData(metric, start.longValue(), end.longValue());
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @POST
    @Path(value="/{tenantId}/tags/numeric")
    public void tagNumericData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, TagParams params) {
        NumericMetric2 metric = new NumericMetric2(tenantId, new MetricId(params.getMetric()));
        ListenableFuture future = params.getTimestamp() != null ? this.metricsService.tagNumericData(metric, params.getTags(), params.getTimestamp().longValue()) : this.metricsService.tagNumericData(metric, params.getTags(), params.getStart().longValue(), params.getEnd().longValue());
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @POST
    @Path(value="/{tenantId}/tags/availability")
    public void tagAvailabilityData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, TagParams params) {
        AvailabilityMetric metric = new AvailabilityMetric(tenantId, new MetricId(params.getMetric()));
        ListenableFuture future = params.getTimestamp() != null ? this.metricsService.tagAvailabilityData(metric, params.getTags(), params.getTimestamp().longValue()) : this.metricsService.tagAvailabilityData(metric, params.getTags(), params.getStart().longValue(), params.getEnd().longValue());
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="/{tenantId}/tags/numeric/{tag}")
    public void findTaggedNumericData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="tag") String tag) {
        ListenableFuture future = this.metricsService.findNumericDataByTags(tenantId, (Set)ImmutableSet.of((Object)tag));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="/{tenantId}/tags/availability/{tag}")
    public void findTaggedAvailabilityData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="tag") String tag) {
        ListenableFuture future = this.metricsService.findAvailabilityByTags(tenantId, (Set)ImmutableSet.of((Object)tag));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @POST
    @Path(value="/counters")
    @Produces(value={"application/json"})
    public void updateCountersForGroups(@Suspended AsyncResponse asyncResponse, Collection<Counter> counters) {
        this.updateCounters(asyncResponse, counters);
    }

    @POST
    @Path(value="/counters/{group}")
    @Produces(value={"application/json"})
    public void updateCounterForGroup(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, Collection<Counter> counters) {
        for (Counter counter : counters) {
            counter.setGroup(group);
        }
        this.updateCounters(asyncResponse, counters);
    }

    private void updateCounters(AsyncResponse asyncResponse, Collection<Counter> counters) {
        ListenableFuture future = this.metricsService.updateCounters(counters);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @POST
    @Path(value="/counters/{group}/{counter}")
    public void updateCounter(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, @PathParam(value="counter") String counter) {
        this.updateCounterValue(asyncResponse, group, counter, Long.valueOf(1L));
    }

    @POST
    @Path(value="/counters/{group}/{counter}/{value}")
    public void updateCounter(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, @PathParam(value="counter") String counter, @PathParam(value="value") Long value) {
        this.updateCounterValue(asyncResponse, group, counter, value);
    }

    private void updateCounterValue(AsyncResponse asyncResponse, String group, String counter, Long value) {
        ListenableFuture future = this.metricsService.updateCounter(new Counter("test", group, counter, value.longValue()));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="/counters/{group}")
    @Produces(value={"application/json", "application/vnd.rhq.wrapped+json"})
    public void getCountersForGroup(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group) {
        ListenableFuture future = this.metricsService.findCounters(group);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="/counters/{group}/{counter}")
    @Produces(value={"application/json", "application/vnd.rhq.wrapped+json"})
    public void getCounter(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, @PathParam(value="counter") String counter) {
        ListenableFuture future = this.metricsService.findCounters(group, Arrays.asList(counter));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GZIP
    @GET
    @Path(value="/metrics/{id}")
    @ApiOperation(value="Return metrical values for a given metric id. If no parameters are given, the raw data for a time period of [now-8h,now] is returned.")
    @Produces(value={"application/json", "application/xml", "application/vnd.rhq.wrapped+json"})
    public void getDataForId(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Id of the metric to return data for") @PathParam(value="id") String id, @ApiParam(value="Start time in millis since epoch", defaultValue="Now - 8h") @QueryParam(value="start") Long start, @ApiParam(value="End time in millis since epoch", defaultValue="Now") @QueryParam(value="end") Long end, @ApiParam(value="If non-zero: number of buckets to partition the data into. Raw data otherwise", defaultValue="0") @QueryParam(value="buckets") int numberOfBuckets, @QueryParam(value="bucketWidthSeconds") int bucketWidthSeconds, @ApiParam(value="If true, empty buckets are not returned.") @QueryParam(value="skipEmpty") @DefaultValue(value="false") boolean skipEmpty, @QueryParam(value="bucketCluster") @DefaultValue(value="true") boolean bucketCluster, @Context HttpHeaders headers) {
        long now = System.currentTimeMillis();
        if (start == null) {
            start = now - EIGHT_HOURS;
        }
        if (end == null) {
            end = now;
        }
        Long finalStart = start;
        Long finalEnd = end;
        ListenableFuture idExistsFuture = this.metricsService.idExists(id);
        Futures.addCallback((ListenableFuture)idExistsFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="/{tenantId}/metrics")
    @Produces(value={"application/json"})
    public void findMetrics(@Suspended AsyncResponse response, @PathParam(value="tenantId") String tenantId, @QueryParam(value="type") String type) {
        MetricType metricType = null;
        try {
            metricType = MetricType.fromTextCode((String)type);
        }
        catch (IllegalArgumentException e) {
            ImmutableMap errors = ImmutableMap.of((Object)"errorMsg", (Object)("[" + type + "] is not a valid type. " + "Accepted values are num|avail|log"));
            response.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        ListenableFuture future = this.metricsService.findMetrics(tenantId, metricType);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GZIP
    @GET
    @Path(value="/metrics")
    @Produces(value={"application/json", "application/xml", "application/vnd.rhq.wrapped+json"})
    public void listMetrics(@Suspended AsyncResponse asyncResponse, @QueryParam(value="q") String filter) {
        ListenableFuture future = ServiceKeeper.getInstance().service.listMetrics();
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @DELETE
    @Path(value="/metrics/{id}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id) {
        ListenableFuture idExistsFuture = this.metricsService.idExists(id);
        Futures.addCallback((ListenableFuture)idExistsFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void handleInsertFailure(Throwable t, AsyncResponse response) {
        ImmutableMap errors = ImmutableMap.of((Object)"errorMsg", (Object)("Failed to insert data: " + Throwables.getRootCause((Throwable)t).getMessage()));
        response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errors).type(MediaType.APPLICATION_JSON_TYPE).build());
    }

    private BucketDataPoint createPointInSimpleBucket(String id, long startTime, long bucketsize, List<NumericData> metrics) {
        ArrayList<NumericData> bucketMetrics = new ArrayList<NumericData>(metrics.size());
        for (NumericData raw : metrics) {
            if (raw.getTimestamp() < startTime || raw.getTimestamp() >= startTime + bucketsize) continue;
            bucketMetrics.add(raw);
        }
        return this.getBucketDataPoint(id, startTime, bucketMetrics);
    }

    private BucketDataPoint getBucketDataPoint(String id, long startTime, List<NumericData> bucketMetrics) {
        double avg;
        Double min = null;
        Double max = null;
        double sum = 0.0;
        for (NumericData raw : bucketMetrics) {
            if (max == null || raw.getValue() > max) {
                max = raw.getValue();
            }
            if (min == null || raw.getValue() < min) {
                min = raw.getValue();
            }
            sum += raw.getValue();
        }
        double d = avg = bucketMetrics.size() > 0 ? sum / (double)bucketMetrics.size() : Double.NaN;
        if (min == null) {
            min = Double.NaN;
        }
        if (max == null) {
            max = Double.NaN;
        }
        BucketDataPoint result = new BucketDataPoint(id, startTime, min.doubleValue(), avg, max.doubleValue());
        return result;
    }

    static /* synthetic */ Set access$100(MetricHandler x0, MetricData x1) {
        return x0.getTagNames(x1);
    }

    static /* synthetic */ BucketDataPoint access$200(MetricHandler x0, String x1, long x2, long x3, List x4) {
        return x0.createPointInSimpleBucket(x1, x2, x3, x4);
    }

    static /* synthetic */ BucketDataPoint access$300(MetricHandler x0, String x1, long x2, List x3) {
        return x0.getBucketDataPoint(x1, x2, x3);
    }

    static /* synthetic */ MetricsService access$400(MetricHandler x0) {
        return x0.metricsService;
    }
}

