/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.rhq.metrics.RHQMetrics;
import org.rhq.metrics.core.MetricsService;
import org.rhq.metrics.restServlet.ServiceKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class MetricsServiceProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsServiceProducer.class);
    private MetricsService metricsService;

    @Produces
    public MetricsService getMetricsService() {
        if (this.metricsService == null) {
            String backend = System.getProperty("rhq-metrics.backend");
            RHQMetrics.Builder metricsServiceBuilder = new RHQMetrics.Builder();
            if (backend != null) {
                switch (backend) {
                    case "cass": {
                        LOG.info("Using Cassandra backend implementation");
                        metricsServiceBuilder.withCassandraDataStore();
                        break;
                    }
                    default: {
                        LOG.info("Using memory backend implementation");
                        metricsServiceBuilder.withInMemoryDataStore();
                        break;
                    }
                }
            } else {
                metricsServiceBuilder.withInMemoryDataStore();
            }
            ServiceKeeper.getInstance().service = this.metricsService = metricsServiceBuilder.build();
        }
        return this.metricsService;
    }
}

