/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet.influx;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.metrics.restServlet.influx.InfluxTimeParser;

public class InfluxQuery {
    private String alias;
    private String metric;
    private String mapping;
    private String mappingArgs = null;
    private long start;
    private long end;
    private int bucketLengthSec;
    private String inputQueryString;
    static Pattern metricSelectPattern = Pattern.compile("select +(\\S+) +(as +\\S+ +)?from +(\\S+) +where +(.*?) +group by time\\((\\S+)\\).*");

    public InfluxQuery(String query) {
        this.inputQueryString = query;
        Matcher m = metricSelectPattern.matcher(query.toLowerCase());
        if (m.matches()) {
            String expr = m.group(1);
            this.alias = m.group(2);
            if (this.alias != null && !this.alias.isEmpty()) {
                this.alias = this.alias.substring(3, this.alias.length() - 1);
                this.alias = this.deQuote(this.alias);
            } else {
                this.alias = "value";
            }
            this.metric = this.deQuote(m.group(3));
            String timeExpr = m.group(4);
            String groupExpr = m.group(5);
            if (timeExpr.contains("and")) {
                int i = timeExpr.indexOf(" and ");
                this.start = InfluxTimeParser.parseTime((String)timeExpr.substring(0, i));
                this.end = InfluxTimeParser.parseTime((String)timeExpr.substring(i + 5, timeExpr.length()));
            } else {
                this.end = System.currentTimeMillis();
                this.start = InfluxTimeParser.parseTime((String)timeExpr);
            }
            this.bucketLengthSec = (int)InfluxTimeParser.parseTime((String)groupExpr) / 1000;
            if (expr.contains("(")) {
                int parPos = expr.indexOf("(");
                this.mapping = expr.substring(0, parPos);
                if (expr.contains(",")) {
                    String tmp = expr.substring(parPos + 1);
                    tmp = tmp.substring(tmp.indexOf(",") + 1);
                    tmp = tmp.substring(0, tmp.length() - 1);
                    this.mappingArgs = tmp.trim();
                }
            } else {
                this.mapping = expr;
            }
        } else if (query.toLowerCase().startsWith("select * from")) {
            System.out.println("Not yet supported: " + query);
        } else {
            throw new IllegalArgumentException("Can not parse " + query);
        }
    }

    private String deQuote(String in) {
        if (in == null) {
            return null;
        }
        int start = 0;
        int end = in.length();
        if (in.startsWith("\"")) {
            ++start;
        }
        if (in.endsWith("\"")) {
            --end;
        }
        String out = in.substring(start, end);
        return out;
    }

    public String toString() {
        return "InfluxQuery{inputQueryString='" + this.inputQueryString + '\'' + ", mapping='" + this.mapping + '\'' + ", mappingArgs='" + this.mappingArgs + '\'' + ", start=" + this.start + ", end=" + this.end + ", bucketLengthSec=" + this.bucketLengthSec + '}';
    }

    public String getAlias() {
        return this.alias;
    }

    public String getMetric() {
        return this.metric;
    }

    public String getMapping() {
        return this.mapping;
    }

    public String getMappingArgs() {
        return this.mappingArgs;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public int getBucketLengthSec() {
        return this.bucketLengthSec;
    }
}

