/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.wordnik.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.rhq.metrics.core.Availability;
import org.rhq.metrics.core.AvailabilityMetric;
import org.rhq.metrics.core.Counter;
import org.rhq.metrics.core.Metric;
import org.rhq.metrics.core.MetricData;
import org.rhq.metrics.core.MetricId;
import org.rhq.metrics.core.MetricType;
import org.rhq.metrics.core.MetricsService;
import org.rhq.metrics.core.NumericData;
import org.rhq.metrics.core.NumericMetric;
import org.rhq.metrics.core.Tag;
import org.rhq.metrics.restServlet.AvailabilityDataParams;
import org.rhq.metrics.restServlet.AvailabilityDataPoint;
import org.rhq.metrics.restServlet.BucketDataPoint;
import org.rhq.metrics.restServlet.DataInsertedCallback;
import org.rhq.metrics.restServlet.MetricHandler;
import org.rhq.metrics.restServlet.MetricParams;
import org.rhq.metrics.restServlet.NumericDataParams;
import org.rhq.metrics.restServlet.NumericDataPoint;
import org.rhq.metrics.restServlet.TagParams;

@Api(value="Related to metrics")
@Path(value="/")
public class MetricHandler {
    private static final long EIGHT_HOURS = TimeUnit.MILLISECONDS.convert(8L, TimeUnit.HOURS);
    @Inject
    private MetricsService metricsService;

    @POST
    @Path(value="/{tenantId}/metrics/numeric")
    @Consumes(value={"application/json"})
    public void createNumericMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, MetricParams params) {
        NumericMetric metric = new NumericMetric(tenantId, new MetricId(params.getName()), params.getMetadata(), params.getDataRetention());
        ListenableFuture future = this.metricsService.createMetric((Metric)metric);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new MetricCreatedCallback(this, asyncResponse, params));
    }

    @POST
    @Path(value="/{tenantId}/metrics/availability")
    @Consumes(value={"application/json"})
    public void createAvailabilityMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, MetricParams params) {
        AvailabilityMetric metric = new AvailabilityMetric(tenantId, new MetricId(params.getName()), params.getMetadata(), params.getDataRetention());
        ListenableFuture future = this.metricsService.createMetric((Metric)metric);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new MetricCreatedCallback(this, asyncResponse, params));
    }

    @GET
    @Path(value="/{tenantId}/metrics/numeric/{id}/meta")
    public void getNumericMetricMetadata(@Suspended AsyncResponse response, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id) {
        ListenableFuture future = this.metricsService.findMetric(tenantId, MetricType.NUMERIC, new MetricId(id));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new GetMetadataCallback(this, response));
    }

    @PUT
    @Path(value="/{tenantId}/metrics/numeric/{id}/meta")
    public void updateNumericMetricMetadata(@Suspended AsyncResponse response, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, Map<String, ? extends Object> updates) {
        HashMap<String, String> additions = new HashMap<String, String>();
        HashSet deletions = new HashSet();
        for (String key : updates.keySet()) {
            if (key.equals("[delete]")) {
                deletions.addAll((List)updates.get(key));
                continue;
            }
            additions.put(key, (String)updates.get(key));
        }
        NumericMetric metric = new NumericMetric(tenantId, new MetricId(id));
        ListenableFuture future = this.metricsService.updateMetadata((Metric)metric, additions, deletions);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new DataInsertedCallback(response, "Failed to update meta data"));
    }

    @GET
    @Path(value="/{tenantId}/metrics/availability/{id}/meta")
    public void getAvailabilityMetricMetadata(@Suspended AsyncResponse response, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id) {
        ListenableFuture future = this.metricsService.findMetric(tenantId, MetricType.AVAILABILITY, new MetricId(id));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new GetMetadataCallback(this, response));
    }

    @PUT
    @Path(value="/{tenantId}/metrics/availability/{id}/meta")
    public void updateAvailabilityMetricMetadata(@Suspended AsyncResponse response, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, Map<String, ? extends Object> updates) {
        HashMap<String, String> additions = new HashMap<String, String>();
        HashSet deletions = new HashSet();
        for (String key : updates.keySet()) {
            if (key.equals("[delete]")) {
                deletions.addAll((List)updates.get(key));
                continue;
            }
            additions.put(key, (String)updates.get(key));
        }
        AvailabilityMetric metric = new AvailabilityMetric(tenantId, new MetricId(id));
        ListenableFuture future = this.metricsService.updateMetadata((Metric)metric, additions, deletions);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new DataInsertedCallback(response, "Failed to update meta data"));
    }

    @POST
    @Path(value="/{tenantId}/metrics/numeric/{id}/data")
    @Consumes(value={"application/json"})
    public void addDataForMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, List<NumericDataPoint> dataPoints) {
        NumericMetric metric = new NumericMetric(tenantId, new MetricId(id));
        for (NumericDataPoint p : dataPoints) {
            metric.addData(p.getTimestamp(), p.getValue());
        }
        ListenableFuture future = this.metricsService.addNumericData(Arrays.asList(metric));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new DataInsertedCallback(asyncResponse, "Failed to insert data"));
    }

    @POST
    @Path(value="/{tenantId}/metrics/availability/{id}/data")
    @Consumes(value={"application/json"})
    public void addAvailabilityForMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, List<AvailabilityDataPoint> data) {
        AvailabilityMetric metric = new AvailabilityMetric(tenantId, new MetricId(id));
        for (AvailabilityDataPoint p : data) {
            metric.addData((MetricData)new Availability(metric, p.getTimestamp(), p.getValue()));
        }
        ListenableFuture future = this.metricsService.addAvailabilityData(Arrays.asList(metric));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new DataInsertedCallback(asyncResponse, "Failed to insert data"));
    }

    @POST
    @Path(value="/{tenantId}/metrics/numeric/data")
    @Consumes(value={"application/json"})
    public void addNumericData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, List<NumericDataParams> paramsList) {
        if (paramsList.isEmpty()) {
            asyncResponse.resume((Object)Response.ok().type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        ArrayList<NumericMetric> metrics = new ArrayList<NumericMetric>(paramsList.size());
        for (NumericDataParams params : paramsList) {
            NumericMetric metric = new NumericMetric(tenantId, new MetricId(params.getName()), params.getMetadata());
            for (NumericDataPoint p : params.getData()) {
                metric.addData(p.getTimestamp(), p.getValue());
            }
            metrics.add(metric);
        }
        ListenableFuture future = this.metricsService.addNumericData(metrics);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new DataInsertedCallback(asyncResponse, "Failed to insert data"));
    }

    @POST
    @Path(value="/{tenantId}/metrics/availability/data")
    @Consumes(value={"application/json"})
    public void addAvailabilityData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, List<AvailabilityDataParams> paramsList) {
        if (paramsList.isEmpty()) {
            asyncResponse.resume((Object)Response.ok().type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        ArrayList<AvailabilityMetric> metrics = new ArrayList<AvailabilityMetric>(paramsList.size());
        for (AvailabilityDataParams params : paramsList) {
            AvailabilityMetric metric = new AvailabilityMetric(tenantId, new MetricId(params.getName()), params.getMetadata());
            for (AvailabilityDataPoint p : params.getData()) {
                metric.addData((MetricData)new Availability(metric, p.getTimestamp(), p.getValue()));
            }
            metrics.add(metric);
        }
        ListenableFuture future = this.metricsService.addAvailabilityData(metrics);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new DataInsertedCallback(asyncResponse, "Failed to insert data"));
    }

    @GET
    @Path(value="/{tenantId}/numeric")
    public void findNumericDataByTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @QueryParam(value="tags") String tags) {
        ImmutableSet tagSet = ImmutableSet.copyOf((Object[])tags.split(","));
        ListenableFuture queryFuture = this.metricsService.findNumericDataByTags(tenantId, (Set)tagSet);
        Futures.addCallback((ListenableFuture)queryFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="/{tenantId}/availability")
    public void findAvailabilityDataByTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @QueryParam(value="tags") String tags) {
        ImmutableSet tagSet = ImmutableSet.copyOf((Object[])tags.split(","));
        ListenableFuture queryFuture = this.metricsService.findAvailabilityByTags(tenantId, (Set)tagSet);
        Futures.addCallback((ListenableFuture)queryFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Set<String> getTagNames(MetricData d) {
        if (d.getTags().isEmpty()) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (Tag tag : d.getTags()) {
            set.add(tag.getValue());
        }
        return set;
    }

    @GET
    @Path(value="/{tenantId}/metrics/numeric/{id}/data")
    public void findNumericData(@Suspended AsyncResponse response, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, @QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="buckets") int numberOfBuckets, @QueryParam(value="bucketWidthSeconds") int bucketWidthSeconds, @QueryParam(value="skipEmpty") @DefaultValue(value="false") boolean skipEmpty, @QueryParam(value="bucketCluster") @DefaultValue(value="true") boolean bucketCluster) {
        long now = System.currentTimeMillis();
        if (start == null) {
            start = now - EIGHT_HOURS;
        }
        if (end == null) {
            end = now;
        }
        NumericMetric metric = new NumericMetric(tenantId, new MetricId(id));
        ListenableFuture dataFuture = this.metricsService.findNumericData(metric, start.longValue(), end.longValue());
        ListenableFuture outputFuture = null;
        if (numberOfBuckets == 0) {
            outputFuture = Futures.transform((ListenableFuture)dataFuture, (Function)new MetricOutMapper(this, null));
        } else if (bucketWidthSeconds == 0) {
            outputFuture = Futures.transform((ListenableFuture)dataFuture, (Function)new CreateSimpleBuckets(this, start.longValue(), end.longValue(), numberOfBuckets, skipEmpty));
        } else {
            ListenableFuture bucketsFuture = Futures.transform((ListenableFuture)dataFuture, (Function)new CreateFixedNumberOfBuckets(this, numberOfBuckets, bucketWidthSeconds));
            outputFuture = bucketCluster ? Futures.transform((ListenableFuture)bucketsFuture, (Function)new FlattenBuckets(this, numberOfBuckets, bucketWidthSeconds, skipEmpty)) : Futures.transform((ListenableFuture)bucketsFuture, (Function)new ClusterBucketData(this, numberOfBuckets, bucketWidthSeconds));
        }
        Futures.addCallback((ListenableFuture)outputFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private BucketDataPoint getBucketedDataPoint(MetricId id, long timestamp, DoubleSummaryStatistics stats) {
        if (stats.getCount() > 0L) {
            return new BucketDataPoint(id.getName(), timestamp, stats.getMin(), stats.getAverage(), stats.getMax());
        }
        return new BucketDataPoint(id.getName(), timestamp, Double.NaN, Double.NaN, Double.NaN);
    }

    @GET
    @Path(value="/{tenantId}/metrics/availability/{id}/data")
    public void findAvailabilityData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, @QueryParam(value="start") Long start, @QueryParam(value="end") Long end) {
        long now = System.currentTimeMillis();
        if (start == null) {
            start = now - EIGHT_HOURS;
        }
        if (end == null) {
            end = now;
        }
        AvailabilityMetric metric = new AvailabilityMetric(tenantId, new MetricId(id));
        ListenableFuture future = this.metricsService.findAvailabilityData(metric, start.longValue(), end.longValue());
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @POST
    @Path(value="/{tenantId}/tags/numeric")
    public void tagNumericData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, TagParams params) {
        NumericMetric metric = new NumericMetric(tenantId, new MetricId(params.getMetric()));
        ListenableFuture future = params.getTimestamp() != null ? this.metricsService.tagNumericData(metric, params.getTags(), params.getTimestamp().longValue()) : this.metricsService.tagNumericData(metric, params.getTags(), params.getStart().longValue(), params.getEnd().longValue());
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @POST
    @Path(value="/{tenantId}/tags/availability")
    public void tagAvailabilityData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, TagParams params) {
        AvailabilityMetric metric = new AvailabilityMetric(tenantId, new MetricId(params.getMetric()));
        ListenableFuture future = params.getTimestamp() != null ? this.metricsService.tagAvailabilityData(metric, params.getTags(), params.getTimestamp().longValue()) : this.metricsService.tagAvailabilityData(metric, params.getTags(), params.getStart().longValue(), params.getEnd().longValue());
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="/{tenantId}/tags/numeric/{tag}")
    public void findTaggedNumericData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="tag") String tag) {
        ListenableFuture future = this.metricsService.findNumericDataByTags(tenantId, (Set)ImmutableSet.of((Object)tag));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="/{tenantId}/tags/availability/{tag}")
    public void findTaggedAvailabilityData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="tag") String tag) {
        ListenableFuture future = this.metricsService.findAvailabilityByTags(tenantId, (Set)ImmutableSet.of((Object)tag));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @POST
    @Path(value="/counters")
    @Produces(value={"application/json"})
    public void updateCountersForGroups(@Suspended AsyncResponse asyncResponse, Collection<Counter> counters) {
        this.updateCounters(asyncResponse, counters);
    }

    @POST
    @Path(value="/counters/{group}")
    @Produces(value={"application/json"})
    public void updateCounterForGroup(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, Collection<Counter> counters) {
        for (Counter counter : counters) {
            counter.setGroup(group);
        }
        this.updateCounters(asyncResponse, counters);
    }

    private void updateCounters(AsyncResponse asyncResponse, Collection<Counter> counters) {
        ListenableFuture future = this.metricsService.updateCounters(counters);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @POST
    @Path(value="/counters/{group}/{counter}")
    public void updateCounter(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, @PathParam(value="counter") String counter) {
        this.updateCounterValue(asyncResponse, group, counter, Long.valueOf(1L));
    }

    @POST
    @Path(value="/counters/{group}/{counter}/{value}")
    public void updateCounter(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, @PathParam(value="counter") String counter, @PathParam(value="value") Long value) {
        this.updateCounterValue(asyncResponse, group, counter, value);
    }

    private void updateCounterValue(AsyncResponse asyncResponse, String group, String counter, Long value) {
        ListenableFuture future = this.metricsService.updateCounter(new Counter("test", group, counter, value.longValue()));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="/counters/{group}")
    @Produces(value={"application/json", "application/vnd.rhq.wrapped+json"})
    public void getCountersForGroup(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group) {
        ListenableFuture future = this.metricsService.findCounters(group);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="/counters/{group}/{counter}")
    @Produces(value={"application/json", "application/vnd.rhq.wrapped+json"})
    public void getCounter(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, @PathParam(value="counter") String counter) {
        ListenableFuture future = this.metricsService.findCounters(group, Arrays.asList(counter));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="/{tenantId}/metrics")
    @Produces(value={"application/json"})
    public void findMetrics(@Suspended AsyncResponse response, @PathParam(value="tenantId") String tenantId, @QueryParam(value="type") String type) {
        MetricType metricType = null;
        try {
            metricType = MetricType.fromTextCode((String)type);
        }
        catch (IllegalArgumentException e) {
            ImmutableMap errors = ImmutableMap.of((Object)"errorMsg", (Object)("[" + type + "] is not a valid type. " + "Accepted values are num|avail|log"));
            response.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        ListenableFuture future = this.metricsService.findMetrics(tenantId, metricType);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static long findBucket(long[] buckets, long bucketSize, long timestamp) {
        return Arrays.stream(buckets).filter(bucket -> timestamp >= bucket && timestamp < bucket + bucketSize).findFirst().getAsLong();
    }

    static BucketDataPoint getBucketDataPoint(String id, long startTime, List<NumericData> bucketMetrics) {
        double avg;
        Double min = null;
        Double max = null;
        double sum = 0.0;
        for (NumericData raw : bucketMetrics) {
            if (max == null || raw.getValue() > max) {
                max = raw.getValue();
            }
            if (min == null || raw.getValue() < min) {
                min = raw.getValue();
            }
            sum += raw.getValue();
        }
        double d = avg = bucketMetrics.size() > 0 ? sum / (double)bucketMetrics.size() : Double.NaN;
        if (min == null) {
            min = Double.NaN;
        }
        if (max == null) {
            max = Double.NaN;
        }
        BucketDataPoint result = new BucketDataPoint(id, startTime, min.doubleValue(), avg, max.doubleValue());
        return result;
    }

    static /* synthetic */ Set access$100(MetricHandler x0, MetricData x1) {
        return x0.getTagNames(x1);
    }

    static /* synthetic */ BucketDataPoint access$200(MetricHandler x0, MetricId x1, long x2, DoubleSummaryStatistics x3) {
        return x0.getBucketedDataPoint(x1, x2, x3);
    }
}

