/*
 * Copyright 2014-2015 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.rhq.metrics.restServlet.influx.query.parse.definition;

/**
 * @author Thomas Segismont
 */
public abstract class ColumnDefinition {
    private final boolean aliased;
    private final String alias;

    protected ColumnDefinition(String alias) {
        this.aliased = (alias != null);
        this.alias = alias;
    }

    public boolean isAliased() {
        return aliased;
    }

    public String getAlias() {
        return alias;
    }

    public abstract String getDisplayName();
}
