/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.restServlet.influx.query.validation;

import java.util.List;
import org.rhq.metrics.restServlet.influx.query.parse.definition.AggregatedColumnDefinition;
import org.rhq.metrics.restServlet.influx.query.parse.definition.AndBooleanExpression;
import org.rhq.metrics.restServlet.influx.query.parse.definition.BooleanExpression;
import org.rhq.metrics.restServlet.influx.query.parse.definition.ColumnDefinition;
import org.rhq.metrics.restServlet.influx.query.parse.definition.EqBooleanExpression;
import org.rhq.metrics.restServlet.influx.query.parse.definition.FromClause;
import org.rhq.metrics.restServlet.influx.query.parse.definition.FunctionArgument;
import org.rhq.metrics.restServlet.influx.query.parse.definition.GtBooleanExpression;
import org.rhq.metrics.restServlet.influx.query.parse.definition.LtBooleanExpression;
import org.rhq.metrics.restServlet.influx.query.parse.definition.NameFunctionArgument;
import org.rhq.metrics.restServlet.influx.query.parse.definition.NameOperand;
import org.rhq.metrics.restServlet.influx.query.parse.definition.NeqBooleanExpression;
import org.rhq.metrics.restServlet.influx.query.parse.definition.Operand;
import org.rhq.metrics.restServlet.influx.query.parse.definition.OrBooleanExpression;
import org.rhq.metrics.restServlet.influx.query.parse.definition.RawColumnDefinition;
import org.rhq.metrics.restServlet.influx.query.parse.definition.SelectQueryDefinitions;
import org.rhq.metrics.restServlet.influx.query.validation.IllegalQueryException;
import org.rhq.metrics.restServlet.influx.query.validation.SelectQueryValidationRule;

public class MetricNameRule
implements SelectQueryValidationRule {
    public void checkQuery(SelectQueryDefinitions queryDefinitions) throws IllegalQueryException {
        BooleanExpression whereClause;
        String metricEffectiveName;
        FromClause fromClause = queryDefinitions.getFromClause();
        String string = metricEffectiveName = fromClause.isAliased() ? fromClause.getAlias() : fromClause.getName();
        if (!queryDefinitions.isStarColumn()) {
            this.checkColumnDefinitions(queryDefinitions.getColumnDefinitions(), metricEffectiveName);
        }
        if ((whereClause = queryDefinitions.getWhereClause()) != null) {
            this.checkBooleanExpression(whereClause, metricEffectiveName);
        }
    }

    private void checkColumnDefinitions(List<ColumnDefinition> columnDefinitions, String metricEffectiveName) throws IllegalQueryException {
        for (ColumnDefinition columnDefinition : columnDefinitions) {
            RawColumnDefinition definition;
            if (columnDefinition instanceof RawColumnDefinition) {
                definition = (RawColumnDefinition)columnDefinition;
                if (!definition.isPrefixed() || definition.getPrefix().equals(metricEffectiveName)) continue;
                throw new IllegalQueryException("Unexpected prefix: " + definition.getPrefix());
            }
            if (columnDefinition instanceof AggregatedColumnDefinition) {
                definition = (AggregatedColumnDefinition)columnDefinition;
                for (FunctionArgument argument : definition.getAggregationFunctionArguments()) {
                    NameFunctionArgument nameArgument;
                    if (!(argument instanceof NameFunctionArgument) || !(nameArgument = (NameFunctionArgument)argument).isPrefixed() || nameArgument.getPrefix().equals(metricEffectiveName)) continue;
                    throw new IllegalQueryException("Unexpected prefix: " + nameArgument.getPrefix());
                }
                continue;
            }
            throw new IllegalQueryException("Unexpected definition type: " + columnDefinition.getClass());
        }
    }

    private void checkBooleanExpression(BooleanExpression booleanExpression, String metricEffectiveName) throws IllegalQueryException {
        if (booleanExpression instanceof AndBooleanExpression) {
            AndBooleanExpression and = (AndBooleanExpression)booleanExpression;
            this.checkBooleanExpression(and.getLeftExpression(), metricEffectiveName);
            this.checkBooleanExpression(and.getRightExpression(), metricEffectiveName);
        } else if (booleanExpression instanceof OrBooleanExpression) {
            OrBooleanExpression or = (OrBooleanExpression)booleanExpression;
            this.checkBooleanExpression(or.getLeftExpression(), metricEffectiveName);
            this.checkBooleanExpression(or.getRightExpression(), metricEffectiveName);
        } else if (booleanExpression instanceof NeqBooleanExpression) {
            NeqBooleanExpression neq = (NeqBooleanExpression)booleanExpression;
            this.checkOperand(neq.getLeftOperand(), metricEffectiveName);
            this.checkOperand(neq.getRightOperand(), metricEffectiveName);
        } else if (booleanExpression instanceof GtBooleanExpression) {
            GtBooleanExpression gt = (GtBooleanExpression)booleanExpression;
            this.checkOperand(gt.getLeftOperand(), metricEffectiveName);
            this.checkOperand(gt.getRightOperand(), metricEffectiveName);
        } else if (booleanExpression instanceof LtBooleanExpression) {
            LtBooleanExpression lt = (LtBooleanExpression)booleanExpression;
            this.checkOperand(lt.getLeftOperand(), metricEffectiveName);
            this.checkOperand(lt.getRightOperand(), metricEffectiveName);
        } else if (booleanExpression instanceof EqBooleanExpression) {
            EqBooleanExpression eq = (EqBooleanExpression)booleanExpression;
            this.checkOperand(eq.getLeftOperand(), metricEffectiveName);
            this.checkOperand(eq.getRightOperand(), metricEffectiveName);
        } else {
            throw new IllegalQueryException("Unexpected expression type: " + booleanExpression.getClass());
        }
    }

    private void checkOperand(Operand operand, String metricEffectiveName) throws IllegalQueryException {
        NameOperand nameOperand;
        if (operand instanceof NameOperand && (nameOperand = (NameOperand)operand).isPrefixed() && !nameOperand.getPrefix().equals(metricEffectiveName)) {
            throw new IllegalQueryException("Unexpected prefix: " + nameOperand.getPrefix());
        }
    }
}

