/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.core;

import com.google.common.base.Objects;
import java.nio.ByteBuffer;

public enum AvailabilityType {
    UP(0, "up"),
    DOWN(1, "down");

    private byte code;
    private String text;

    private AvailabilityType(byte code, String text) {
        this.code = code;
        this.text = text;
    }

    public byte getCode() {
        return this.code;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("code", (int)this.code).add("text", (Object)this.text).toString();
    }

    public static AvailabilityType fromString(String s) {
        switch (s.toLowerCase()) {
            case "up": {
                return UP;
            }
            case "down": {
                return DOWN;
            }
        }
        throw new IllegalArgumentException(s + " is not a recognized availability type");
    }

    public static AvailabilityType fromBytes(ByteBuffer bytes) {
        switch (bytes.array()[bytes.position()]) {
            case 0: {
                return UP;
            }
            case 1: {
                return DOWN;
            }
        }
        throw new IllegalArgumentException(bytes.array()[0] + " is not a recognized availability type");
    }
}

