/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.core;

public enum MetricType {
    NUMERIC(0, "numeric"),
    AVAILABILITY(1, "availability"),
    LOG_EVENT(2, "log event");

    private int code;
    private String text;

    private MetricType(int code, String text) {
        this.code = code;
        this.text = text;
    }

    public int getCode() {
        return this.code;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.text;
    }

    public static MetricType fromCode(int code) {
        switch (code) {
            case 0: {
                return NUMERIC;
            }
            case 1: {
                return AVAILABILITY;
            }
            case 2: {
                return LOG_EVENT;
            }
        }
        throw new IllegalArgumentException(code + " is not a recognized metric type");
    }

    public static MetricType fromTextCode(String textCode) {
        switch (textCode) {
            case "num": {
                return NUMERIC;
            }
            case "avail": {
                return AVAILABILITY;
            }
            case "log": {
                return LOG_EVENT;
            }
        }
        throw new IllegalArgumentException(textCode + " is not a recognized metric type code");
    }
}

