/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.core;

import com.datastax.driver.core.Session;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rhq.metrics.core.Availability;
import org.rhq.metrics.core.AvailabilityMetric;
import org.rhq.metrics.core.Counter;
import org.rhq.metrics.core.Metric;
import org.rhq.metrics.core.MetricId;
import org.rhq.metrics.core.MetricType;
import org.rhq.metrics.core.NumericData;
import org.rhq.metrics.core.NumericMetric2;
import org.rhq.metrics.core.Tenant;

public interface MetricsService {
    public static final String DEFAULT_TENANT_ID = "test";

    public void startUp(Map<String, String> var1);

    public void startUp(Session var1);

    public void shutdown();

    public ListenableFuture<Void> createTenant(Tenant var1);

    public ListenableFuture<Void> createMetric(Metric var1);

    public ListenableFuture<Metric> findMetric(String var1, MetricType var2, MetricId var3);

    public ListenableFuture<List<Metric>> findMetrics(String var1, MetricType var2);

    public ListenableFuture<Void> updateMetadata(Metric var1, Map<String, String> var2, Set<String> var3);

    public ListenableFuture<Void> addNumericData(List<NumericMetric2> var1);

    public ListenableFuture<NumericMetric2> findNumericData(NumericMetric2 var1, long var2, long var4);

    public ListenableFuture<List<NumericData>> findData(NumericMetric2 var1, long var2, long var4);

    public ListenableFuture<Void> addAvailabilityData(List<AvailabilityMetric> var1);

    public ListenableFuture<AvailabilityMetric> findAvailabilityData(AvailabilityMetric var1, long var2, long var4);

    public ListenableFuture<Void> updateCounter(Counter var1);

    public ListenableFuture<Void> updateCounters(Collection<Counter> var1);

    public ListenableFuture<List<Counter>> findCounters(String var1);

    public ListenableFuture<List<Counter>> findCounters(String var1, List<String> var2);

    public ListenableFuture<Boolean> idExists(String var1);

    public ListenableFuture<List<String>> listMetrics();

    public ListenableFuture<Boolean> deleteMetric(String var1);

    public ListenableFuture<List<NumericData>> tagNumericData(NumericMetric2 var1, Set<String> var2, long var3, long var5);

    public ListenableFuture<List<Availability>> tagAvailabilityData(AvailabilityMetric var1, Set<String> var2, long var3, long var5);

    public ListenableFuture<List<NumericData>> tagNumericData(NumericMetric2 var1, Set<String> var2, long var3);

    public ListenableFuture<List<Availability>> tagAvailabilityData(AvailabilityMetric var1, Set<String> var2, long var3);

    public ListenableFuture<Map<MetricId, Set<NumericData>>> findNumericDataByTags(String var1, Set<String> var2);

    public ListenableFuture<Map<MetricId, Set<Availability>>> findAvailabilityByTags(String var1, Set<String> var2);
}

