/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.core;

import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.rhq.metrics.core.Interval;
import org.rhq.metrics.core.MetricType;

public class RetentionSettings {
    private Map<RetentionKey, Integer> retentions = new HashMap<RetentionKey, Integer>();

    public Integer put(MetricType rawType, int hours) {
        return this.retentions.put(new RetentionKey(rawType), hours);
    }

    public Integer put(MetricType metricType, Interval interval, int hours) {
        return this.retentions.put(new RetentionKey(metricType, interval), hours);
    }

    public Integer get(MetricType type) {
        return this.retentions.get(new RetentionKey(type));
    }

    public Integer get(MetricType type, Interval interval) {
        return this.retentions.get(new RetentionKey(type, interval));
    }

    public Integer get(RetentionKey key) {
        return this.retentions.get(key);
    }

    public Set<RetentionKey> keySet() {
        return this.retentions.keySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetentionSettings that = (RetentionSettings)o;
        return this.retentions.equals(that.retentions);
    }

    public int hashCode() {
        return this.retentions.hashCode();
    }

    public String toString() {
        return this.retentions.toString();
    }

    public static class RetentionKey {
        public MetricType metricType;
        public Interval interval;

        public RetentionKey(MetricType metricType) {
            this.metricType = metricType;
        }

        public RetentionKey(MetricType metricType, Interval interval) {
            this.metricType = metricType;
            this.interval = interval;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RetentionKey that = (RetentionKey)o;
            if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) {
                return false;
            }
            return this.metricType == that.metricType;
        }

        public int hashCode() {
            int result = this.metricType.hashCode();
            result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
            return result;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("metricType", (Object)this.metricType).add("interval", (Object)this.interval).toString();
        }
    }
}

