/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.core;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.rhq.metrics.core.AggregationTemplate;
import org.rhq.metrics.core.Interval;
import org.rhq.metrics.core.MetricType;
import org.rhq.metrics.core.RetentionSettings;

public class Tenant {
    private String id;
    private List<AggregationTemplate> aggregationTemplates = new ArrayList<AggregationTemplate>();
    private RetentionSettings retentionSettings = new RetentionSettings();

    public String getId() {
        return this.id;
    }

    public Tenant setId(String id) {
        this.id = id;
        return this;
    }

    public List<AggregationTemplate> getAggregationTemplates() {
        return this.aggregationTemplates;
    }

    public Tenant addAggregationTemplate(AggregationTemplate template) {
        this.aggregationTemplates.add(template);
        return this;
    }

    public RetentionSettings getRetentionSettings() {
        return this.retentionSettings;
    }

    public Tenant setRetention(MetricType type, int hours) {
        this.retentionSettings.put(type, hours);
        return this;
    }

    public Tenant setRetention(MetricType type, Interval interval, int hours) {
        this.retentionSettings.put(type, interval, hours);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tenant tenant = (Tenant)o;
        return this.id.equals(tenant.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("id", (Object)this.id).add("aggregationTemplates", this.aggregationTemplates).add("retentionSettings", (Object)this.retentionSettings).toString();
    }
}

