/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.test;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.joda.time.DateTime;

public class MetricsTest {
    private static final long FUTURE_TIMEOUT = 3L;
    protected Session session;
    private PreparedStatement truncateMetrics;
    private PreparedStatement truncateCounters;

    public void initSession() {
        String nodeAddresses = System.getProperty("nodes", "127.0.0.1");
        Cluster cluster = new Cluster.Builder().addContactPoints(nodeAddresses.split(",")).build();
        this.session = cluster.connect(this.getKeyspace());
        this.truncateMetrics = this.session.prepare("TRUNCATE metrics");
        this.truncateCounters = this.session.prepare("TRUNCATE counters");
    }

    protected void resetDB() {
        this.session.execute((Statement)this.truncateMetrics.bind());
        this.session.execute((Statement)this.truncateCounters.bind());
    }

    protected String getKeyspace() {
        return System.getProperty("keyspace", "rhqtest");
    }

    protected DateTime hour0() {
        DateTime rightNow = DateTime.now();
        return rightNow.hourOfDay().roundFloorCopy().minusHours(rightNow.hourOfDay().roundFloorCopy().hourOfDay().get());
    }

    protected DateTime hour(int hourOfDay) {
        return this.hour0().plusHours(hourOfDay);
    }

    protected <V> V getUninterruptibly(ListenableFuture<V> future) throws ExecutionException, TimeoutException {
        return (V)Uninterruptibles.getUninterruptibly(future, (long)3L, (TimeUnit)TimeUnit.SECONDS);
    }
}

