/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.modcluster.config;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.rhq.plugins.modcluster.config.AbstractConfigurationFile;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JBossWebServerFile
extends AbstractConfigurationFile {
    private static final String CATALINA_LISTENER_CLASS_NAME = "org.jboss.modcluster.catalina.ModClusterListener";
    private Node listenerNode = this.getListenerNode();

    public JBossWebServerFile(String configurationFileName) throws ParserConfigurationException, SAXException, IOException {
        super(configurationFileName);
    }

    public JBossWebServerFile(File configurationFile) throws ParserConfigurationException, SAXException, IOException {
        super(configurationFile);
    }

    @Override
    public void setPropertyValue(String propertyName, String value) {
        NamedNodeMap attributeList = this.listenerNode.getAttributes();
        if (attributeList.getNamedItem(propertyName) != null && value != null) {
            Node attributeNode = attributeList.getNamedItem(propertyName);
            attributeNode.setTextContent(value);
        } else if (attributeList.getNamedItem(propertyName) != null && value == null) {
            attributeList.removeNamedItem(propertyName);
        } else if (attributeList.getNamedItem(propertyName) == null && value != null) {
            Attr property = this.getDocument().createAttribute(propertyName);
            property.setValue(propertyName);
            property.setTextContent(value);
            attributeList.setNamedItem(property);
        }
    }

    @Override
    public String getPropertyValue(String propertyName) {
        throw new UnsupportedOperationException("Property values should be retrieved from the JMX interface not from the configuration file.");
    }

    private Node getListenerNode() {
        NodeList nodeList = this.getDocument().getElementsByTagName("Listener");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getAttributes().getNamedItem("className") == null || !CATALINA_LISTENER_CLASS_NAME.equals(node.getAttributes().getNamedItem("className").getTextContent())) continue;
            return node;
        }
        return null;
    }
}

