/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.agent;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.SystemInfo;
import org.rhq.enterprise.agent.Version;
import org.rhq.plugins.agent.AgentServerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentLauncherScriptDiscoveryComponent
implements ResourceDiscoveryComponent<AgentServerComponent> {
    private final Log log = LogFactory.getLog(AgentLauncherScriptDiscoveryComponent.class);
    static final String PLUGINCONFIG_PATHNAME = "Pathname";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<AgentServerComponent> context) {
        this.log.info((Object)"Discovering RHQ Agent's launcher script service...");
        HashSet<DiscoveredResourceDetails> set = new HashSet<DiscoveredResourceDetails>();
        try {
            String baseName = this.getBaseName(context.getSystemInformation());
            if (baseName != null) {
                EmsAttribute attrib = ((AgentServerComponent)context.getParentResourceComponent()).getAgentBean().getAttribute("Version");
                attrib.refresh();
                String version = attrib.getValue() != null ? attrib.getValue().toString() : Version.getProductVersion();
                if (!this.findInAgentHome(context, version, baseName, set)) {
                    this.log.warn((Object)"Could not find the agent's launcher script anywhere");
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"An error occurred while attempting to auto-discover the agent's launcher script", (Throwable)e);
        }
        return set;
    }

    private boolean findInAgentHome(ResourceDiscoveryContext<AgentServerComponent> context, String version, String baseName, HashSet<DiscoveredResourceDetails> discoveries) {
        try {
            File file;
            EmsAttribute home = ((AgentServerComponent)context.getParentResourceComponent()).getAgentBean().getAttribute("AgentHomeDirectory");
            home.refresh();
            Object agentHome = home.getValue();
            if (agentHome != null && (file = new File(agentHome.toString(), baseName)).exists()) {
                discoveries.add(this.createDetails(context, version, file));
            }
            return discoveries.size() > 0;
        }
        catch (Exception e) {
            this.log.debug((Object)("Cannot use agent home to find launcher script. Cause: " + e));
            return false;
        }
    }

    private DiscoveredResourceDetails createDetails(ResourceDiscoveryContext<AgentServerComponent> context, String version, File discoveredLocation) {
        String location;
        String key = "launcherscript";
        String name = "RHQ Agent Launcher Script";
        String description = "A script that can start the agent and manage its lifecycle as a service";
        try {
            location = discoveredLocation.getCanonicalPath();
        }
        catch (Exception e) {
            location = discoveredLocation.getAbsolutePath();
        }
        File launcher = new File(new File(location), "rhq-agent-wrapper.sh");
        DiscoveredResourceDetails details = new DiscoveredResourceDetails(context.getResourceType(), key, name, version, description, null, null);
        Configuration pc = details.getPluginConfiguration();
        pc.put((Property)new PropertySimple(PLUGINCONFIG_PATHNAME, (Object)launcher.getAbsoluteFile()));
        return details;
    }

    private String getBaseName(SystemInfo sysInfo) {
        String location = null;
        try {
            OperatingSystemType osType = sysInfo.getOperatingSystemType();
            if (osType == OperatingSystemType.JAVA) {
                String osName = System.getProperty("os.name", "").toLowerCase();
                OperatingSystemType operatingSystemType = osType = osName.contains("windows") ? OperatingSystemType.WINDOWS : OperatingSystemType.LINUX;
            }
            if (osType != OperatingSystemType.WINDOWS) {
                location = "bin";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return location;
    }
}

