/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.agent;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.SystemInfo;
import org.rhq.enterprise.agent.Version;
import org.rhq.plugins.agent.AgentServerComponent;

public class AgentEnvironmentScriptDiscoveryComponent
implements ResourceDiscoveryComponent<AgentServerComponent> {
    private final Log log = LogFactory.getLog(AgentEnvironmentScriptDiscoveryComponent.class);
    static final String PLUGINCONFIG_PATHNAME = "Pathname";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<AgentServerComponent> context) {
        this.log.info((Object)"Discovering RHQ Agent's environment setup script...");
        HashSet<DiscoveredResourceDetails> set = new HashSet<DiscoveredResourceDetails>();
        try {
            String baseName = this.getScriptBaseName(context.getSystemInformation());
            EmsAttribute attrib = ((AgentServerComponent)context.getParentResourceComponent()).getAgentBean().getAttribute("Version");
            String version = attrib != null && attrib.getValue() != null ? attrib.getValue().toString() : Version.getProductVersion();
            if (!this.findInAgentHome(context, version, baseName, set)) {
                this.log.warn((Object)"Could not find the agent environment setup script anywhere");
            }
        }
        catch (Exception e) {
            this.log.error((Object)"An error occurred while attempting to auto-discover the agent's environment setup script", (Throwable)e);
        }
        return set;
    }

    private boolean findInAgentHome(ResourceDiscoveryContext<AgentServerComponent> context, String version, String baseName, HashSet<DiscoveredResourceDetails> discoveries) {
        try {
            File file;
            EmsAttribute home = ((AgentServerComponent)context.getParentResourceComponent()).getAgentBean().getAttribute("AgentHomeDirectory");
            home.refresh();
            Object agentHome = home.getValue();
            if (agentHome != null && (file = new File(agentHome.toString(), "bin/" + baseName)).exists()) {
                discoveries.add(this.createDetails(context, version, file));
            }
            return discoveries.size() > 0;
        }
        catch (Exception e) {
            this.log.debug((Object)("Cannot use agent home to find environment script. Cause: " + e));
            return false;
        }
    }

    private DiscoveredResourceDetails createDetails(ResourceDiscoveryContext<AgentServerComponent> context, String version, File discoveredScript) {
        String pathname;
        String key = "environment-setup-script";
        String description = "RHQ Agent Environment Setup Script";
        try {
            pathname = discoveredScript.getCanonicalPath();
        }
        catch (Exception e) {
            pathname = discoveredScript.getAbsolutePath();
        }
        DiscoveredResourceDetails details = new DiscoveredResourceDetails(context.getResourceType(), key, discoveredScript.getName(), version, description, null, null);
        details.getPluginConfiguration().put((Property)new PropertySimple(PLUGINCONFIG_PATHNAME, (Object)pathname));
        return details;
    }

    private String getScriptBaseName(SystemInfo sysInfo) {
        String extension;
        try {
            OperatingSystemType osType = sysInfo.getOperatingSystemType();
            if (osType == OperatingSystemType.JAVA) {
                String osName = System.getProperty("os.name", "").toLowerCase();
                OperatingSystemType operatingSystemType = osType = osName.contains("windows") ? OperatingSystemType.WINDOWS : OperatingSystemType.LINUX;
            }
            extension = osType == OperatingSystemType.WINDOWS ? "bat" : "sh";
        }
        catch (Exception e) {
            extension = ".sh";
        }
        return "rhq-agent-env." + extension;
    }
}

