/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.template;

import java.io.Serializable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateEngine
implements Serializable {
    private static final long serialVersionUID = -6490715202402123042L;
    private final Map<String, String> tokens;
    private static String tokenRegex = "@@\\s*(\\w+\\.?)+\\s*@@";
    private static String keyRegex = "(\\w+\\.?)+";
    private static Pattern tokenPattern = Pattern.compile(tokenRegex);
    private static Pattern keyPattern = Pattern.compile(keyRegex);

    public TemplateEngine(Map<String, String> tokens) {
        this.tokens = tokens;
    }

    public Map<String, String> getTokens() {
        return this.tokens;
    }

    public String replaceTokens(String input) {
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = tokenPattern.matcher(input);
        while (matcher.find()) {
            String key;
            String value;
            String next = matcher.group();
            Matcher keyMatcher = keyPattern.matcher(next);
            if (keyMatcher.find() && (value = this.tokens.get(key = keyMatcher.group())) != null) {
                next = value;
            }
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(next));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

