/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.ant.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Target;
import org.rhq.bundle.ant.BundleAntProject;
import org.rhq.bundle.ant.HandoverTarget;
import org.rhq.bundle.ant.type.AbstractBundleType;
import org.rhq.bundle.ant.type.ArchiveType;
import org.rhq.bundle.ant.type.FileSet;
import org.rhq.bundle.ant.type.FileType;
import org.rhq.bundle.ant.type.Handover;
import org.rhq.bundle.ant.type.HandoverInfo;
import org.rhq.bundle.ant.type.HasHandover;
import org.rhq.bundle.ant.type.IgnoreType;
import org.rhq.bundle.ant.type.SystemServiceType;
import org.rhq.bundle.ant.type.UrlArchiveType;
import org.rhq.bundle.ant.type.UrlFileType;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.template.TemplateEngine;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.core.util.updater.DeployDifferences;
import org.rhq.core.util.updater.Deployer;
import org.rhq.core.util.updater.DeploymentData;
import org.rhq.core.util.updater.DeploymentProperties;
import org.rhq.core.util.updater.DestinationComplianceMode;

public class DeploymentUnitType
extends AbstractBundleType {
    private String name;
    private DestinationComplianceMode compliance;
    private Map<File, File> files = new LinkedHashMap<File, File>();
    private Map<URL, File> urlFiles = new LinkedHashMap<URL, File>();
    private Set<File> rawFilesToReplace = new LinkedHashSet<File>();
    private Set<URL> rawUrlFilesToReplace = new LinkedHashSet<URL>();
    private Map<File, String> localFileNames = new LinkedHashMap<File, String>();
    private Map<File, File> archives = new LinkedHashMap<File, File>();
    private Map<URL, File> urlArchives = new LinkedHashMap<URL, File>();
    private Map<File, Pattern> archiveReplacePatterns = new HashMap<File, Pattern>();
    private Map<URL, Pattern> urlArchiveReplacePatterns = new HashMap<URL, Pattern>();
    private Map<File, Boolean> archivesExploded = new HashMap<File, Boolean>();
    private Map<URL, Boolean> urlArchivesExploded = new HashMap<URL, Boolean>();
    private Map<File, String> localArchiveNames = new LinkedHashMap<File, String>();
    private List<HasHandover> contentToHandover = new ArrayList<HasHandover>();
    private SystemServiceType systemService;
    private Pattern ignorePattern;
    private String preinstallTarget;
    private String postinstallTarget;

    public void init() throws BuildException {
        if (this.systemService != null) {
            this.systemService.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(boolean revert, boolean clean) throws BuildException {
        File handoverRemoteContentDownloadDirectory;
        block42: {
            if (clean) {
                this.getProject().auditLog(BundleAntProject.AuditStatus.INFO, "Clean Requested", "A clean deployment has been requested. Files will be deleted!", "A clean deployment has been requested. Files will be deleted from the destination directory prior to the new deployment files getting written", null);
            }
            if (revert) {
                this.getProject().auditLog(BundleAntProject.AuditStatus.INFO, "Revert Requested", "The previous deployment will be reverted!", "The previous deployment will be reverted. An attempt to restore backed up files and the old deployment content will be made", null);
            }
            File baseDir = this.getProject().getBaseDir();
            handoverRemoteContentDownloadDirectory = null;
            try {
                boolean dryRun = this.getProject().isDryRun();
                DestinationComplianceMode complianceToUse = DestinationComplianceMode.instanceOrDefault((DestinationComplianceMode)this.compliance);
                File deployDir = this.getProject().getDeployDir();
                TemplateEngine templateEngine = this.createTemplateEngine(this.getProject().getProperties());
                int deploymentId = this.getProject().getDeploymentId();
                DeploymentProperties deploymentProps = new DeploymentProperties(deploymentId, this.getProject().getBundleName(), this.getProject().getBundleVersion(), this.getProject().getBundleDescription(), complianceToUse);
                if (this.preinstallTarget != null) {
                    this.getProject().auditLog(BundleAntProject.AuditStatus.SUCCESS, "Pre-Install Started", "The pre install target will start", "The pre install target named [" + this.preinstallTarget + "] will start", null);
                    Target target = (Target)this.getProject().getTargets().get(this.preinstallTarget);
                    if (target == null) {
                        try {
                            this.getProject().auditLog(BundleAntProject.AuditStatus.FAILURE, "Pre-Install Failure", "The pre install target does not exist", "The pre install target specified in the recipe [" + this.preinstallTarget + "] does not exist.", null);
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                        throw new BuildException("Specified preinstall target (" + this.preinstallTarget + ") does not exist.");
                    }
                    target.performTasks();
                    this.getProject().auditLog(BundleAntProject.AuditStatus.SUCCESS, "Pre-Install Finished", "The pre install target has finished", null, null);
                }
                boolean haveSomethingToDo = false;
                if (!this.files.isEmpty()) {
                    haveSomethingToDo = true;
                    this.log("Deploying files " + this.files + "...", 3);
                }
                if (!this.urlFiles.isEmpty()) {
                    haveSomethingToDo = true;
                    this.log("Deploying files from URL " + this.urlFiles + "...", 3);
                }
                if (!this.archives.isEmpty()) {
                    haveSomethingToDo = true;
                    this.log("Deploying archives " + this.archives + "...", 3);
                }
                if (!this.urlArchives.isEmpty()) {
                    haveSomethingToDo = true;
                    this.log("Deploying archives from URL " + this.urlArchives + "...", 3);
                }
                if (!this.contentToHandover.isEmpty()) {
                    haveSomethingToDo = true;
                    this.log("Handing over " + this.contentToHandover.size() + " file(s)/archive(s)...", 3);
                }
                if (!haveSomethingToDo) {
                    throw new BuildException("You must specify at least one file to deploy via nested file, archive, url-file, url-archive types in your recipe");
                }
                this.log("Destination compliance set to '" + complianceToUse + "'.", 3);
                switch (complianceToUse) {
                    case full: {
                        if (dryRun) break;
                        this.getProject().auditLog(BundleAntProject.AuditStatus.INFO, "Managing Top Level Deployment Directory", "The top level deployment directory will be managed - files found there will be backed up and removed!", "The bundle recipe has requested that the top level deployment directory be fully managed by RHQ.This means any files currently located in the top level deployment directory will be removed and backed up", null);
                        break;
                    }
                    case filesAndDirectories: {
                        this.log("Files and directories in the destination directory not contained in the bundle will be kept intact.\nNote that the contents of the directories that ARE contained in the bundle will be synced with the contents as specified in the bundle. I.e. the subdirectories in the destination that are also contained in the bundle are made compliant with the bundle.", 3);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled destination compliance mode: " + complianceToUse.toString());
                    }
                }
                HashMap<File, File> allArchives = new HashMap<File, File>(this.archives);
                HashMap<File, File> allFiles = new HashMap<File, File>(this.files);
                HashMap<File, Pattern> allArchiveReplacePatterns = new HashMap<File, Pattern>(this.archiveReplacePatterns);
                HashSet<File> allRawFilesToReplace = new HashSet<File>(this.rawFilesToReplace);
                HashMap<File, Boolean> allArchivesExploded = new HashMap<File, Boolean>(this.archivesExploded);
                this.downloadFilesFromUrlEndpoints(allArchives, allFiles, allArchiveReplacePatterns, allRawFilesToReplace, allArchivesExploded);
                handoverRemoteContentDownloadDirectory = FileUtil.createTempDirectory((String)"handover-", (String)".download", (File)baseDir);
                Map<HasHandover, File> downloadedFilesToHandover = this.downloadRemoteContentToHandover(handoverRemoteContentDownloadDirectory);
                try {
                    DeploymentData deploymentData = new DeploymentData(deploymentProps, baseDir, deployDir, allFiles, allRawFilesToReplace, allArchives, allArchiveReplacePatterns, templateEngine, this.ignorePattern, allArchivesExploded);
                    Deployer deployer = new Deployer(deploymentData);
                    DeployDifferences diffs = this.getProject().getDeployDifferences();
                    if (!dryRun) {
                        this.getProject().auditLog(BundleAntProject.AuditStatus.SUCCESS, "Deployer Started", "The deployer has started its work", null, null);
                    }
                    if (revert) {
                        deployer.redeployAndRestoreBackupFiles(diffs, clean, dryRun);
                    } else {
                        deployer.deploy(diffs, clean, dryRun);
                    }
                    HandoverTarget handoverTarget = this.getProject().getHandoverTarget();
                    if (handoverTarget != null) {
                        for (HasHandover hasHandoverReference : this.contentToHandover) {
                            Handover handoverTag = hasHandoverReference.getHandover();
                            File source = this.getFileSource(hasHandoverReference, downloadedFilesToHandover, templateEngine);
                            FileInputStream contentStream = new FileInputStream(source);
                            HandoverInfo.Builder builder = new HandoverInfo.Builder();
                            builder.setContent(contentStream);
                            builder.setFilename(source.getName());
                            builder.setAction(handoverTag.getAction());
                            builder.setParams(handoverTag.getHandoverParams());
                            builder.setRevert(revert);
                            HandoverInfo handoverInfo = builder.createHandoverInfo();
                            if (dryRun) continue;
                            try {
                                boolean handoverSuccess = handoverTarget.handoverContent(handoverInfo);
                                String informationMessage = "Source: " + source.getName() + ", " + (Object)((Object)handoverTag);
                                if (handoverSuccess) {
                                    this.getProject().auditLog(BundleAntProject.AuditStatus.INFO, "Handover", "Handover target reported success", informationMessage, null);
                                    continue;
                                }
                                if (handoverTag.isFailonerror()) {
                                    this.getProject().auditLog(BundleAntProject.AuditStatus.FAILURE, "Handover", "Handover target reported a failure", informationMessage, null);
                                    throw new Exception("Handover failed: " + (Object)((Object)handoverTag));
                                }
                                this.getProject().auditLog(BundleAntProject.AuditStatus.WARN, "Handover", "Handover target reported a failure", informationMessage, null);
                            }
                            finally {
                                StreamUtil.safeClose((Closeable)contentStream);
                            }
                        }
                    }
                    if (!dryRun) {
                        this.getProject().auditLog(BundleAntProject.AuditStatus.SUCCESS, "Deployer Finished", "The deployer has finished its work", null, diffs.toString());
                    }
                }
                catch (Throwable t) {
                    try {
                        this.getProject().auditLog(BundleAntProject.AuditStatus.FAILURE, "Deployer Failed", "The deployer encountered an error and could not finished", ThrowableUtil.getAllMessages((Throwable)t), ThrowableUtil.getStackAsString((Throwable)t));
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    throw new BuildException("Failed to deploy bundle [" + this.getProject().getBundleName() + "] version [" + this.getProject().getBundleVersion() + "]: " + t, t);
                }
                if (this.systemService != null) {
                    this.systemService.install();
                }
                if (this.postinstallTarget == null) break block42;
                this.getProject().auditLog(BundleAntProject.AuditStatus.SUCCESS, "Post-Install Started", "The post install target will start", "The post install target named [" + this.postinstallTarget + "] will start", null);
                Target target = (Target)this.getProject().getTargets().get(this.postinstallTarget);
                if (target == null) {
                    try {
                        this.getProject().auditLog(BundleAntProject.AuditStatus.FAILURE, "Post-Install Failure", "The post install target does not exist", "The post install target specified in the recipe [" + this.postinstallTarget + "] does not exist.", null);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    throw new BuildException("Specified postinstall target (" + this.postinstallTarget + ") does not exist.");
                }
                target.performTasks();
                this.getProject().auditLog(BundleAntProject.AuditStatus.SUCCESS, "Post-Install Finished", "The post install target has finished", null, null);
            }
            catch (Throwable t) {
                try {
                    try {
                        this.getProject().auditLog(BundleAntProject.AuditStatus.FAILURE, "Error Occurred", "The deployment could not complete successfully.", ThrowableUtil.getAllMessages((Throwable)t), ThrowableUtil.getStackAsString((Throwable)t));
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    if (t instanceof BuildException) {
                        throw (BuildException)t;
                    }
                    throw new BuildException(t);
                }
                catch (Throwable throwable) {
                    FileUtil.purge(handoverRemoteContentDownloadDirectory, (boolean)true);
                    throw throwable;
                }
            }
        }
        FileUtil.purge((File)handoverRemoteContentDownloadDirectory, (boolean)true);
    }

    private File getFileSource(HasHandover hasHandoverReference, Map<HasHandover, File> downloadedFilesToHandover, TemplateEngine templateEngine) throws Exception {
        File source;
        if (hasHandoverReference instanceof UrlFileType) {
            UrlFileType urlFileType = (UrlFileType)hasHandoverReference;
            source = downloadedFilesToHandover.get(urlFileType);
            if (urlFileType.isReplace()) {
                this.processFileWithTemplateEngine(source, templateEngine);
            }
        } else if (hasHandoverReference instanceof UrlArchiveType) {
            UrlArchiveType urlArchiveType = (UrlArchiveType)hasHandoverReference;
            source = downloadedFilesToHandover.get(urlArchiveType);
            if (urlArchiveType.getReplacePattern() != null) {
                this.processArchiveWithTemplateEngine(source, urlArchiveType.getReplacePattern(), templateEngine);
            }
        } else if (hasHandoverReference instanceof FileType) {
            FileType fileType = (FileType)hasHandoverReference;
            source = fileType.getSource();
            if (fileType.isReplace()) {
                this.processFileWithTemplateEngine(source, templateEngine);
            }
        } else if (hasHandoverReference instanceof ArchiveType) {
            ArchiveType archiveType = (ArchiveType)hasHandoverReference;
            source = archiveType.getSource();
            if (archiveType.getReplacePattern() != null) {
                this.processArchiveWithTemplateEngine(source, archiveType.getReplacePattern(), templateEngine);
            }
        } else {
            throw new RuntimeException("Unsupported type: " + hasHandoverReference.getClass().getName());
        }
        return source;
    }

    private void downloadFilesFromUrlEndpoints(Map<File, File> allArchives, Map<File, File> allFiles, Map<File, Pattern> allArchiveReplacePatterns, Set<File> allRawFilesToReplace, Map<File, Boolean> allArchivesExploded) throws Exception {
        if (this.urlFiles.isEmpty() && this.urlArchives.isEmpty()) {
            return;
        }
        File downloadDir = this.getProject().getBaseDir();
        Set<File> downloadedFiles = this.getProject().getDownloadedFiles();
        try {
            URL url;
            for (Map.Entry<URL, File> fileEntry : this.urlFiles.entrySet()) {
                url = fileEntry.getKey();
                File destFile = fileEntry.getValue();
                File tmpFile = new File(downloadDir, destFile.getPath());
                this.download(url, tmpFile);
                downloadedFiles.add(tmpFile);
                allFiles.put(tmpFile, destFile);
                if (!this.rawUrlFilesToReplace.contains(url)) continue;
                allRawFilesToReplace.add(tmpFile);
            }
            for (Map.Entry<URL, File> archiveEntry : this.urlArchives.entrySet()) {
                int lastSlash;
                url = archiveEntry.getKey();
                File destinationDirectory = archiveEntry.getValue();
                String baseFileName = url.getPath();
                if (baseFileName.endsWith("/")) {
                    baseFileName = baseFileName.substring(0, baseFileName.length());
                }
                if ((lastSlash = baseFileName.lastIndexOf(47)) != -1) {
                    baseFileName = baseFileName.substring(lastSlash + 1);
                }
                if (baseFileName.length() == 0) {
                    baseFileName = url.getHost();
                }
                File tmpFile = new File(downloadDir, baseFileName);
                this.download(url, tmpFile);
                downloadedFiles.add(tmpFile);
                allArchives.put(tmpFile, destinationDirectory);
                if (this.urlArchiveReplacePatterns.containsKey(url)) {
                    allArchiveReplacePatterns.put(tmpFile, this.urlArchiveReplacePatterns.get(url));
                }
                if (!this.urlArchivesExploded.containsKey(url)) continue;
                allArchivesExploded.put(tmpFile, this.urlArchivesExploded.get(url));
            }
        }
        catch (Exception e) {
            try {
                for (File doomed : downloadedFiles) {
                    doomed.delete();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw e;
        }
    }

    private Map<HasHandover, File> downloadRemoteContentToHandover(File handoverDownloadDirectory) throws Exception {
        HashMap<HasHandover, File> result = new HashMap<HasHandover, File>();
        for (HasHandover hasHandoverReference : this.contentToHandover) {
            String baseName;
            URL source;
            if (hasHandoverReference instanceof UrlFileType) {
                UrlFileType urlFileType = (UrlFileType)hasHandoverReference;
                source = urlFileType.getSource();
                baseName = urlFileType.getBaseName();
            } else {
                if (!(hasHandoverReference instanceof UrlArchiveType)) continue;
                UrlArchiveType urlArchiveType = (UrlArchiveType)hasHandoverReference;
                source = urlArchiveType.getSource();
                baseName = urlArchiveType.getBaseName();
            }
            Set<File> downloadedFiles = this.getProject().getDownloadedFiles();
            try {
                File tmpFile = new File(handoverDownloadDirectory, baseName);
                this.download(source, tmpFile);
                downloadedFiles.add(tmpFile);
                result.put(hasHandoverReference, tmpFile);
            }
            catch (Exception e) {
                for (File file : downloadedFiles) {
                    file.delete();
                }
                throw e;
            }
        }
        return result;
    }

    private void download(URL url, File tmpFile) throws Exception {
        long size;
        this.getProject().auditLog(BundleAntProject.AuditStatus.SUCCESS, "File Download Started", "Downloading file from URL", "Downloading file from URL: " + url, null);
        try {
            InputStream in = url.openStream();
            tmpFile.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(tmpFile);
            size = StreamUtil.copy((InputStream)in, (OutputStream)out);
        }
        catch (Exception e) {
            this.getProject().auditLog(BundleAntProject.AuditStatus.FAILURE, "File Download Failed", "Failed to download content from a remote server", "Failed to download file from: " + url, ThrowableUtil.getStackAsString((Throwable)e));
            throw e;
        }
        this.getProject().auditLog(BundleAntProject.AuditStatus.SUCCESS, "File Download Finished", "Successfully downloaded file from URL", "Downloaded file of size [" + size + "] bytes from URL: " + url, null);
    }

    public void start() throws BuildException {
        if (this.systemService != null) {
            this.systemService.start();
        }
    }

    public void stop() throws BuildException {
        if (this.systemService != null) {
            this.systemService.stop();
        }
    }

    public void upgrade(boolean revert, boolean clean) throws BuildException {
        this.install(revert, clean);
    }

    public void uninstall() throws BuildException {
        if (this.systemService != null) {
            this.systemService.uninstall();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    public String getManageRootDir() {
        return Boolean.toString(this.getCompliance() == DestinationComplianceMode.full);
    }

    @Deprecated
    public void setManageRootDir(String booleanString) {
        if (!Boolean.TRUE.toString().equalsIgnoreCase(booleanString) && !Boolean.FALSE.toString().equalsIgnoreCase(booleanString)) {
            throw new BuildException("manageRootDir attribute must be 'true' or 'false': " + booleanString);
        }
        this.log("The deprecated 'manageRootDir' attribute was detected. Please consider replacing it with the 'compliance' attribute.", 2);
        boolean val = Boolean.parseBoolean(booleanString);
        this.setCompliance(val ? DestinationComplianceMode.full : DestinationComplianceMode.filesAndDirectories);
    }

    public DestinationComplianceMode getCompliance() {
        return this.compliance;
    }

    public void setCompliance(DestinationComplianceMode value) {
        this.compliance = value;
    }

    public Map<File, File> getFiles() {
        return this.files;
    }

    public Map<File, String> getLocalFileNames() {
        return this.localFileNames;
    }

    public Map<File, File> getArchives() {
        return this.archives;
    }

    public Map<File, String> getLocalArchiveNames() {
        return this.localArchiveNames;
    }

    public Map<File, Boolean> getArchivesExploded() {
        return this.archivesExploded;
    }

    public String getPreinstallTarget() {
        return this.preinstallTarget;
    }

    public void setPreinstallTarget(String preinstallTarget) {
        this.preinstallTarget = preinstallTarget;
    }

    public String getPostinstallTarget() {
        return this.postinstallTarget;
    }

    public void setPostinstallTarget(String postinstallTarget) {
        this.postinstallTarget = postinstallTarget;
    }

    public void addConfigured(SystemServiceType systemService) {
        if (this.systemService != null) {
            throw new IllegalStateException("A rhq:deployment-unit element can only have one rhq:system-service child element.");
        }
        this.systemService = systemService;
        this.systemService.validate();
        this.files.put(this.systemService.getScriptFile(), this.systemService.getScriptDestFile());
        this.localFileNames.put(this.systemService.getScriptFile(), this.systemService.getScriptFileName());
        if (this.systemService.getConfigFile() != null) {
            this.files.put(this.systemService.getConfigFile(), this.systemService.getConfigDestFile());
            this.localFileNames.put(this.systemService.getConfigFile(), this.systemService.getConfigFileName());
            this.rawFilesToReplace.add(this.systemService.getConfigFile());
        }
    }

    public void addConfigured(FileType file) {
        this.localFileNames.put(file.getSource(), file.getName());
        if (file.getHandover() != null) {
            this.contentToHandover.add(file);
            return;
        }
        File destFile = file.getDestinationFile();
        if (destFile == null) {
            File destDir = file.getDestinationDir();
            destFile = new File(destDir, file.getSource().getName());
        }
        this.files.put(file.getSource(), destFile);
        if (file.isReplace()) {
            this.rawFilesToReplace.add(file.getSource());
        }
    }

    public void addConfigured(UrlFileType file) {
        if (file.getHandover() != null) {
            this.contentToHandover.add(file);
            return;
        }
        File destFile = file.getDestinationFile();
        if (destFile == null) {
            File destDir = file.getDestinationDir();
            destFile = new File(destDir, file.getBaseName());
        }
        this.urlFiles.put(file.getSource(), destFile);
        if (file.isReplace()) {
            this.rawUrlFilesToReplace.add(file.getSource());
        }
    }

    public void addConfigured(ArchiveType archive) {
        this.localArchiveNames.put(archive.getSource(), archive.getName());
        if (archive.getHandover() != null) {
            this.contentToHandover.add(archive);
            return;
        }
        this.archives.put(archive.getSource(), archive.getDestinationDir());
        Pattern replacePattern = archive.getReplacePattern();
        if (replacePattern != null) {
            this.archiveReplacePatterns.put(archive.getSource(), replacePattern);
        }
        Boolean exploded = Boolean.valueOf(archive.getExploded());
        this.archivesExploded.put(archive.getSource(), exploded);
    }

    public void addConfigured(UrlArchiveType archive) {
        if (archive.getHandover() != null) {
            this.contentToHandover.add(archive);
            return;
        }
        this.urlArchives.put(archive.getSource(), archive.getDestinationDir());
        Pattern replacePattern = archive.getReplacePattern();
        if (replacePattern != null) {
            this.urlArchiveReplacePatterns.put(archive.getSource(), replacePattern);
        }
        Boolean exploded = Boolean.valueOf(archive.getExploded());
        this.urlArchivesExploded.put(archive.getSource(), exploded);
    }

    public void addConfigured(IgnoreType ignore) {
        List<FileSet> fileSets = ignore.getFileSets();
        this.ignorePattern = DeploymentUnitType.getPattern(fileSets);
    }

    private TemplateEngine createTemplateEngine(Hashtable<String, String> properties) {
        TemplateEngine templateEngine = SystemInfoFactory.fetchTemplateEngine();
        if (properties != null) {
            for (Map.Entry<String, String> e : properties.entrySet()) {
                templateEngine.getTokens().put(e.getKey(), e.getValue());
            }
        }
        Configuration config = this.getProject().getConfiguration();
        for (PropertySimple prop : config.getSimpleProperties().values()) {
            templateEngine.getTokens().put(prop.getName(), prop.getStringValue());
        }
        templateEngine.getTokens().put("rhq.deploy.dir", this.getProject().getProperty("rhq.deploy.dir"));
        return templateEngine;
    }

    private void processFileWithTemplateEngine(File file, TemplateEngine templateEngine) throws Exception {
        byte[] contentBytes = StreamUtil.slurp((InputStream)new FileInputStream(file));
        String processedContent = templateEngine.replaceTokens(new String(contentBytes));
        FileUtil.writeFile((InputStream)new ByteArrayInputStream(processedContent.getBytes()), (File)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processArchiveWithTemplateEngine(File archive, Pattern realizeRegex, TemplateEngine templateEngine) throws Exception {
        File baseDir = this.getProject().getBaseDir();
        File tempFile = null;
        ZipOutputStream zipOutputStream = null;
        try {
            tempFile = File.createTempFile("handover-archive-processing-", ".tmp", baseDir);
            zipOutputStream = new ZipOutputStream(new FileOutputStream(tempFile));
            ZipUtil.walkZipFile((File)archive, (ZipUtil.ZipEntryVisitor)new ArchiveEntryVisitor(zipOutputStream, realizeRegex, templateEngine));
            StreamUtil.safeClose((Closeable)zipOutputStream);
            FileUtil.copyFile((File)tempFile, (File)archive);
        }
        catch (Throwable throwable) {
            StreamUtil.safeClose(zipOutputStream);
            if (tempFile != null) {
                tempFile.delete();
            }
            throw throwable;
        }
        StreamUtil.safeClose((Closeable)zipOutputStream);
        if (tempFile != null) {
            tempFile.delete();
        }
    }

    private static class ArchiveEntryVisitor
    implements ZipUtil.ZipEntryVisitor {
        private final ZipOutputStream zipOutputStream;
        private final Pattern realizeRegex;
        private final TemplateEngine templateEngine;

        public ArchiveEntryVisitor(ZipOutputStream zipOutputStream, Pattern realizeRegex, TemplateEngine templateEngine) {
            this.zipOutputStream = zipOutputStream;
            this.realizeRegex = realizeRegex;
            this.templateEngine = templateEngine;
        }

        public boolean visit(ZipEntry entry, ZipInputStream stream) throws Exception {
            String pathName = entry.getName();
            this.zipOutputStream.putNextEntry(new ZipEntry(pathName));
            if (entry.isDirectory()) {
                return true;
            }
            if (!this.realizeRegex.matcher(pathName).matches()) {
                StreamUtil.copy((InputStream)stream, (OutputStream)this.zipOutputStream, (boolean)false);
                return true;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamUtil.copy((InputStream)stream, (OutputStream)baos, (boolean)false);
            String processedContent = this.templateEngine.replaceTokens(baos.toString());
            StreamUtil.copy((InputStream)new ByteArrayInputStream(processedContent.getBytes()), (OutputStream)this.zipOutputStream, (boolean)false);
            return true;
        }
    }
}

