/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.hyperic.sigar.SigarProxy;
import org.rhq.core.system.SigarAccessHandler;
import org.rhq.core.system.SystemInfoException;
import org.rhq.core.system.SystemInfoFactory;

public class SigarAccess {
    private static SigarAccessHandler invocationHandler;
    private static SigarProxy sigarProxy;

    public static synchronized SigarProxy getSigar() {
        if (SigarAccess.isSigarAvailable()) {
            if (sigarProxy == null) {
                invocationHandler = new SigarAccessHandler();
                sigarProxy = (SigarProxy)Proxy.newProxyInstance(SigarAccess.class.getClassLoader(), new Class[]{SigarProxy.class}, (InvocationHandler)invocationHandler);
            }
            return sigarProxy;
        }
        throw new SystemInfoException("Native layer is not available or has been disabled");
    }

    public static void close() {
        if (invocationHandler != null) {
            invocationHandler.close();
        }
        sigarProxy = null;
    }

    public static boolean isSigarAvailable() {
        if (!SystemInfoFactory.isNativeSystemInfoDisabled() && SystemInfoFactory.isNativeSystemInfoAvailable()) {
            if (!SystemInfoFactory.isNativeSystemInfoInitialized()) {
                SystemInfoFactory.getNativeSystemInfoVersion();
            }
            return true;
        }
        return false;
    }
}

