/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.rhq.core.util.collection.IntHashMap;
import org.rhq.core.util.file.FileVisitor;
import org.rhq.core.util.file.PathFilter;
import org.rhq.core.util.stream.StreamUtil;

public class FileUtil {
    private static IntHashMap invalidChars = null;

    public static Boolean isNewer(File file1, File file2) {
        long file2Date;
        if (file1 == null || file2 == null) {
            return null;
        }
        if (!file1.isFile() || !file2.isFile()) {
            return null;
        }
        long file1Date = file1.lastModified();
        return file1Date > (file2Date = file2.lastModified());
    }

    public static File createTempDirectory(String prefix, String suffix, File parentDirectory) throws IOException {
        File tmpDir = File.createTempFile(prefix, suffix, parentDirectory);
        boolean deleteOk = tmpDir.delete();
        boolean mkdirsOk = tmpDir.mkdirs();
        if (!deleteOk || !mkdirsOk) {
            throw new IOException("Failed to create temp directory named [" + tmpDir + "]");
        }
        return tmpDir;
    }

    public static void purge(File dir, boolean deleteIt) {
        if (dir != null) {
            File[] doomedFiles;
            if (dir.isDirectory() && (doomedFiles = dir.listFiles()) != null) {
                for (File doomedFile : doomedFiles) {
                    FileUtil.purge(doomedFile, true);
                }
            }
            if (deleteIt) {
                dir.delete();
            }
        }
    }

    public static void copyFile(File inFile, File outFile) throws FileNotFoundException, IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(inFile));
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outFile));
        StreamUtil.copy(is, os);
    }

    public static void copyDirectory(File inDir, File outDir) throws IOException {
        if (inDir.exists()) {
            if (!inDir.isDirectory()) {
                throw new IOException("Source directory [" + inDir + "] is not a directory");
            }
        } else {
            throw new FileNotFoundException("Source directory [" + inDir + "] does not exist");
        }
        if (!outDir.mkdirs()) {
            throw new IOException("Destination directory [" + outDir + "] failed to be created");
        }
        if (!FileUtil.canWrite(outDir)) {
            throw new IOException("Cannot write to destination directory [" + outDir + "]");
        }
        File[] files = inDir.listFiles();
        if (files == null) {
            throw new IOException("Failed to get the list of files in source directory [" + inDir + "]");
        }
        for (File file : files) {
            File copiedFile = new File(outDir, file.getName());
            if (file.isDirectory()) {
                FileUtil.copyDirectory(file, copiedFile);
                continue;
            }
            FileUtil.copyFile(file, copiedFile);
        }
        files = null;
    }

    public static List<File> getDirectoryFiles(File directory) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        if (!directory.isDirectory()) {
            throw new IOException("[" + directory + "] is not an existing directory");
        }
        FileUtil.getDirectoryFilesRecursive(directory, files, null);
        return files;
    }

    private static void getDirectoryFilesRecursive(File directory, List<File> files, String relativeTo) throws IOException {
        File[] children = directory.listFiles();
        if (children == null) {
            throw new IOException("Cannot obtain files from directory [" + directory + "]");
        }
        for (File child : children) {
            if (child.isDirectory()) {
                FileUtil.getDirectoryFilesRecursive(child, files, (relativeTo == null ? "" : relativeTo) + child.getName() + File.separatorChar);
                continue;
            }
            files.add(new File(relativeTo, child.getName()));
        }
    }

    @Deprecated
    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        StreamUtil.copy(is, os, false);
    }

    @Deprecated
    public static void copyStream(InputStream is, OutputStream os, byte[] buf) throws IOException {
        int bytesRead = 0;
        while ((bytesRead = is.read(buf)) != -1) {
            os.write(buf, 0, bytesRead);
        }
    }

    public static void writeFile(InputStream inputStream, File outputFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputFile);
        FileUtil.copyStream(inputStream, fos);
        inputStream.close();
        fos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findString(String fname, String toFind) throws IOException {
        StringBuffer result = null;
        BufferedReader in = new BufferedReader(new FileReader(fname));
        try {
            int numread;
            char[] data = new char[8096];
            int toFindIndex = 0;
            char lastchar = 'a';
            while ((numread = in.read(data, 0, 8096)) != -1) {
                for (int i = 0; i < numread; ++i) {
                    if (toFindIndex >= toFind.length() || data[i] == toFind.charAt(toFindIndex)) {
                        if (result == null) {
                            result = new StringBuffer();
                        }
                        if (Character.isISOControl(data[i])) {
                            String string = result.toString();
                            return string;
                        }
                        result.append(data[i]);
                        ++toFindIndex;
                    } else if (toFindIndex > 0) {
                        if (data[i] != lastchar) {
                            result = null;
                            toFindIndex = 0;
                            continue;
                        }
                        --toFindIndex;
                        --i;
                        result.deleteCharAt(result.length() - 1);
                        continue;
                    }
                    lastchar = data[i];
                }
            }
        }
        catch (IOException e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public static String getRelativePath(File path, File base) {
        String base_abs;
        String path_abs = path.getAbsolutePath();
        int idx = path_abs.indexOf(base_abs = base.getAbsolutePath());
        if (idx == -1) {
            throw new IllegalArgumentException("Path (" + path_abs + ") " + "does not contain " + "base (" + base_abs + ")");
        }
        String relativePath = "." + path_abs.substring(idx + base_abs.length());
        return relativePath;
    }

    private static void initInvalidChars() {
        if (invalidChars != null) {
            return;
        }
        invalidChars = new IntHashMap();
        char[] invalid = new char[]{'\\', '/', ':', '*', '?', '\'', '\"', '~', '<', '>', '|', '#', '{', '}', '%', '&', ' '};
        for (int i = 0; i < invalid.length; ++i) {
            invalidChars.put(invalid[i], Boolean.TRUE);
        }
    }

    public static String escape(String name) {
        FileUtil.initInvalidChars();
        int len = name.length();
        StringBuffer buf = new StringBuffer(len);
        char[] chars = name.toCharArray();
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (invalidChars.get(c) == Boolean.TRUE) {
                buf.append("_");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException(dir.getPath() + " is not a directory");
        }
        File tmp = null;
        try {
            tmp = File.createTempFile("rhq", null, dir);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
        }
    }

    public static String stripDriveLetter(StringBuilder path) {
        String driveLetter = null;
        Pattern regex = Pattern.compile("^([a-zA-Z]):.*");
        Matcher matcher = regex.matcher(path);
        if (matcher.matches()) {
            driveLetter = matcher.group(1).toUpperCase();
            path.replace(0, 2, "");
        }
        return driveLetter;
    }

    public static String useForwardSlash(String path) {
        return null != path ? path.replace('\\', '/') : null;
    }

    public static String getFileName(String path, String separator) {
        if (null == path) {
            return null;
        }
        int i = path.lastIndexOf(separator);
        return i < 0 ? path.trim() : path.substring(++i).trim();
    }

    public static void forEachFile(File directory, FileVisitor visitor) {
        LinkedList<File> directories = new LinkedList<File>();
        directories.push(directory);
        while (!directories.isEmpty()) {
            File dir = (File)directories.pop();
            File[] files = dir.listFiles();
            if (files == null) continue;
            for (File file : files) {
                if (file.isDirectory()) {
                    directories.push(file);
                    continue;
                }
                visitor.visit(file);
            }
        }
    }

    public static Pattern generateRegex(List<PathFilter> filters) {
        boolean first = true;
        StringBuilder regex = new StringBuilder();
        for (PathFilter filter : filters) {
            if (!first) {
                regex.append("|");
            } else {
                first = false;
            }
            regex.append("(");
            File pathFile = new File(filter.getPath());
            if (FileUtil.isEmpty(filter.getPattern()) && pathFile.isDirectory()) {
                regex.append(".*");
            } else if (FileUtil.isEmpty(filter.getPattern()) && !pathFile.isDirectory()) {
                FileUtil.buildPatternRegex(pathFile.getAbsolutePath(), regex);
            } else if (!FileUtil.isEmpty(filter.getPattern())) {
                String pathString = pathFile.getAbsolutePath();
                if (!pathString.endsWith(File.separator)) {
                    pathString = pathString + File.separator;
                }
                pathString = pathString.replace("\\", "\\\\");
                pathString = pathString.replace("(", "\\(");
                pathString = pathString.replace(")", "\\)");
                regex.append(pathString).append("(");
                FileUtil.buildPatternRegex(filter.getPattern(), regex);
                regex.append(")");
            }
            regex.append(")");
        }
        return Pattern.compile(regex.toString());
    }

    private static void buildPatternRegex(String pattern, StringBuilder regex) {
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '?') {
                regex.append('.');
                continue;
            }
            if (c == '*') {
                char c2;
                if (i + 1 < pattern.length() && (c2 = pattern.charAt(i + 1)) == '*') {
                    regex.append(".*");
                    i += 2;
                    continue;
                }
                String separator = File.separator;
                if ("\\".equals(separator)) {
                    separator = "\\\\";
                }
                regex.append("[^" + separator + "]*");
                continue;
            }
            if (c == '.' || c == '(' || c == ')') {
                regex.append("\\");
                regex.append(c);
                continue;
            }
            if (c == '\\') {
                regex.append("\\\\");
                continue;
            }
            regex.append(c);
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static File normalizePath(File file) {
        File ret;
        String path = file.getPath();
        File root = null;
        int rootLength = FileSystem.get().getPathRootLength(path);
        if (rootLength > 0) {
            StringBuilder rootPath = new StringBuilder(path.substring(0, rootLength));
            String driveLetter = FileUtil.stripDriveLetter(rootPath);
            root = new File(null == driveLetter ? rootPath.toString() : driveLetter + ":" + rootPath.toString());
        }
        StringTokenizer tokenizer = new StringTokenizer(path.substring(rootLength), FileSystem.get().getSeparatorChars(), true);
        LinkedList<String> pathStack = new LinkedList<String>();
        boolean previousWasDelimiter = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (File.separator.equals(token)) {
                if (previousWasDelimiter) continue;
                pathStack.push(token);
                previousWasDelimiter = true;
                continue;
            }
            if ("..".equals(token)) {
                previousWasDelimiter = true;
                if (pathStack.isEmpty()) {
                    return null;
                }
                pathStack.pop();
                if (pathStack.isEmpty()) {
                    return null;
                }
                pathStack.pop();
                continue;
            }
            if (".".equals(token)) {
                previousWasDelimiter = true;
                continue;
            }
            if (token.length() > 0) {
                previousWasDelimiter = false;
                pathStack.push(token);
                continue;
            }
            previousWasDelimiter = false;
        }
        StringBuilder normalizedPath = new StringBuilder();
        int i = pathStack.size();
        while (--i >= 0) {
            normalizedPath.append((String)pathStack.get(i));
        }
        File file2 = ret = root == null ? new File(normalizedPath.toString()) : new File(root, normalizedPath.toString());
        if (file.isAbsolute() != ret.isAbsolute()) {
            return null;
        }
        return ret;
    }

    public static boolean isAbsolutePath(String path) {
        File filepath = new File(path);
        if (File.separatorChar == '/') {
            return filepath.isAbsolute();
        }
        if (filepath.isAbsolute()) {
            return true;
        }
        String driveLetter = FileUtil.stripDriveLetter(new StringBuilder(path));
        if (driveLetter != null) {
            return false;
        }
        char cwdDriveLetter = new File("\\").getAbsolutePath().charAt(0);
        return new File(cwdDriveLetter + ":" + path).isAbsolute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressFile(File originalFile) throws IOException {
        File decompressedFile = new File(originalFile + ".d");
        try {
            FileUtil.copyFile(originalFile, decompressedFile);
            try {
                FileOutputStream out = new FileOutputStream(originalFile);
                out.write(new byte[]{0});
                GZIPOutputStream zip = new GZIPOutputStream(out);
                StreamUtil.copy(new FileInputStream(decompressedFile), zip);
            }
            catch (IOException e) {
                try {
                    FileUtil.copyFile(decompressedFile, originalFile);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
        }
        finally {
            decompressedFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decompressFile(File originalFile) throws IOException {
        File compressedFile = new File(originalFile + ".c");
        try {
            FileUtil.copyFile(originalFile, compressedFile);
            try {
                FileInputStream in = new FileInputStream(compressedFile);
                in.read();
                GZIPInputStream zip = new GZIPInputStream(in);
                StreamUtil.copy(zip, new FileOutputStream(originalFile));
            }
            catch (IOException e) {
                try {
                    FileUtil.copyFile(compressedFile, originalFile);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
        }
        finally {
            compressedFile.delete();
        }
    }

    private static enum FileSystem {
        UNIX{

            @Override
            public int getPathRootLength(String path) {
                if (path != null && path.charAt(0) == '/') {
                    return 1;
                }
                return 0;
            }

            @Override
            public String getSeparatorChars() {
                return "/";
            }
        }
        ,
        WINDOWS{

            @Override
            public int getPathRootLength(String path) {
                if (path == null || path.length() < 3) {
                    return 0;
                }
                char c0 = path.charAt(0);
                char c1 = path.charAt(1);
                char c2 = path.charAt(2);
                switch (c0) {
                    case '/': 
                    case '\\': {
                        if (FileSystem.isSlash(c1)) {
                            int nextSlash = FileSystem.nextSlash(path, 2);
                            if (nextSlash < 3) {
                                throw new IllegalArgumentException("Invalid UNC path - no host specified");
                            }
                            int hostSlash = nextSlash;
                            if ((nextSlash = FileSystem.nextSlash(path, nextSlash + 1)) <= hostSlash) {
                                throw new IllegalArgumentException("Invalid UNC path - no share specified");
                            }
                            return nextSlash;
                        }
                        return 0;
                    }
                }
                if (c1 == ':') {
                    char driveLetter = Character.toLowerCase(c0);
                    if ('a' <= driveLetter && 'z' >= driveLetter) {
                        return c2 == '\\' ? 3 : 2;
                    }
                    return 0;
                }
                return 0;
            }

            @Override
            public String getSeparatorChars() {
                return "\\/";
            }
        };


        private static boolean isSlash(char c) {
            return c == '\\' || c == '/';
        }

        private static int nextSlash(String str, int from) {
            int len = str.length();
            for (int i = from; i < len; ++i) {
                if (!FileSystem.isSlash(str.charAt(i))) continue;
                return i;
            }
            return -1;
        }

        public static FileSystem get() {
            switch (File.separatorChar) {
                case '/': {
                    return UNIX;
                }
                case '\\': {
                    return WINDOWS;
                }
            }
            throw new IllegalStateException("Unsupported filesystem");
        }

        public abstract int getPathRootLength(String var1);

        public abstract String getSeparatorChars();
    }
}

