 /*
  * RHQ Management Platform
  * Copyright (C) 2005-2008 Red Hat, Inc.
  * All rights reserved.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License, version 2, as
  * published by the Free Software Foundation, and/or the GNU Lesser
  * General Public License, version 2.1, also as published by the Free
  * Software Foundation.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  * GNU General Public License and the GNU Lesser General Public License
  * for more details.
  *
  * You should have received a copy of the GNU General Public License
  * and the GNU Lesser General Public License along with this program;
  * if not, write to the Free Software Foundation, Inc.,
  * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
  */
package org.rhq.core.domain.discovery;

import java.io.Serializable;

/**
 * A response to a merge resource request that indicates the id of the merged resource, as well as whether or not the
 * resource already existed in inventory.
 *
 * @author Ian Springer
 */
public class MergeResourceResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    private int resourceId;
    private long mtime;
    private boolean resourceAlreadyExisted;

    /**
     * @deprecated use {@link #MergeResourceResponse(int, long, boolean)}
     */
    @Deprecated
    public MergeResourceResponse(int resourceId, boolean resourceAlreadyExisted) {
        this(resourceId, 0L, resourceAlreadyExisted);
    }

    /**
     * @param resourceId
     * @param mtime for new resources, this is the ctime, for existing resources it is the mtime
     * @param resourceAlreadyExisted
     */
    public MergeResourceResponse(int resourceId, long mtime, boolean resourceAlreadyExisted) {
        this.resourceId = resourceId;
        this.mtime = mtime;
        this.resourceAlreadyExisted = resourceAlreadyExisted;
    }

    public int getResourceId() {
        return resourceId;
    }

    public long getMtime() {
        return mtime;
    }

    public boolean resourceAlreadyExisted() {
        return resourceAlreadyExisted;
    }
}